/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Depend
implements PersistentDependency {
    private static final Logger log = Logger.getLogger(Depend.class.getName());
    private final Path _source;
    private final long _lastModified;
    private long _length;
    private boolean _requireSource = true;
    private boolean _isDigestModified;

    public Depend(Path source, long lastModified, long length) {
        this._source = source;
        this._lastModified = lastModified;
        this._length = length;
    }

    public Depend(Path source) {
        this(source, source.getLastModified(), source.getLength());
    }

    public Depend(Path source, long digest) {
        this(source, digest, true);
    }

    public Depend(Path source, long digest, boolean requireSource) {
        this(source);
        long newDigest = source.getCrc64();
        this._requireSource = requireSource;
        if (newDigest != digest && (requireSource || newDigest != -1L)) {
            if (newDigest == -1L) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this._source.getNativePath() + " source is deleted.");
                }
                this._isDigestModified = true;
            } else {
                this._isDigestModified = true;
            }
        }
    }

    public Path getPath() {
        return this._source;
    }

    public long getLastModified() {
        return this._source.getLastModified();
    }

    public long getLength() {
        return this._source.getLength();
    }

    public boolean getRequireSource() {
        return this._requireSource;
    }

    public void setRequireSource(boolean requireSource) {
        this._requireSource = requireSource;
    }

    public boolean isModified() {
        if (this._isDigestModified) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._source.getNativePath() + " digest is modified.");
            }
            return true;
        }
        long sourceLastModified = this._source.getLastModified();
        long sourceLength = this._source.getLength();
        if (!this._requireSource && sourceLastModified == 0L) {
            return false;
        }
        if (sourceLength != this._length) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._source.getNativePath() + " length is modified (" + this._length + " -> " + sourceLength + ")");
            }
            return true;
        }
        if (sourceLastModified != this._lastModified) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._source.getNativePath() + " time is modified.");
            }
            return true;
        }
        return false;
    }

    public boolean logModified(Logger log) {
        if (this._isDigestModified) {
            log.info(this._source.getNativePath() + " digest is modified.");
            return true;
        }
        long sourceLastModified = this._source.getLastModified();
        long sourceLength = this._source.getLength();
        if (!this._requireSource && sourceLastModified == 0L) {
            return false;
        }
        if (sourceLength != this._length) {
            log.info(this._source.getNativePath() + " length is modified (" + this._length + " -> " + sourceLength + ")");
            return true;
        }
        if (sourceLastModified != this._lastModified) {
            log.info(this._source.getNativePath() + " time is modified.");
            return true;
        }
        return false;
    }

    public long getDigest() {
        return this._source.getCrc64();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Depend)) {
            return false;
        }
        Depend depend = (Depend)obj;
        return this._source.equals(depend._source);
    }

    public String getJavaCreateString() {
        return "new com.caucho.vfs.Depend(com.caucho.vfs.Vfs.lookup(\"" + this._source.getPath() + "\"), " + this._source.getCrc64() + "L)";
    }

    public String toString() {
        return "Depend[" + this._source + ",time=" + this._lastModified + ",time-ch=" + (this._source.getLastModified() - this._lastModified) + ",len-ch=" + (this._source.getLength() - this._length) + "]";
    }
}

