/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.make.CachedDependency;
import com.caucho.util.Alarm;
import com.caucho.util.CacheListener;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.util.LruCache;
import com.caucho.vfs.Depend;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.StreamImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Jar
implements CacheListener {
    private static final Logger log = Log.open(Jar.class);
    private static final L10N L = new L10N(Jar.class);
    private static LruCache<Path, Jar> _jarCache;
    private static EnvironmentLocal<Integer> _jarSize;
    private static ZipEntry NULL_ZIP;
    private LruCache<String, ZipEntry> _zipEntryCache = new LruCache(64);
    private Path _backing;
    private boolean _backingIsFile;
    private AtomicInteger _changeSequence = new AtomicInteger();
    private JarDepend _depend;
    private long _lastModified;
    private long _length;
    private long _lastTime;
    private SoftReference<JarFile> _jarFileRef;
    private long _jarLength;
    private Boolean _isSigned;
    private final AtomicReference<SoftReference<JarFile>> _closeJarFileRef = new AtomicReference();

    private Jar(Path backing) {
        if (backing instanceof JarPath) {
            throw new IllegalStateException();
        }
        this._backing = backing;
        this._backingIsFile = this._backing.getScheme().equals("file") && this._backing.canRead();
    }

    static Jar create(Path backing) {
        Jar jar;
        if (_jarCache == null) {
            int size = 256;
            Integer iSize = _jarSize.get();
            if (iSize != null) {
                size = iSize;
            }
            _jarCache = new LruCache(size);
        }
        if ((jar = _jarCache.get(backing)) == null) {
            jar = new Jar(backing);
            jar = _jarCache.putIfNew(backing, jar);
        }
        return jar;
    }

    static Jar getJar(Path backing) {
        if (_jarCache != null) {
            Jar jar = _jarCache.get(backing);
            return jar;
        }
        return null;
    }

    public static PersistentDependency createDepend(Path backing) {
        Jar jar = Jar.create(backing);
        return jar.getDepend();
    }

    public static PersistentDependency createDepend(Path backing, long digest) {
        Jar jar = Jar.create(backing);
        return new JarDigestDepend(jar.getJarDepend(), digest);
    }

    Path getBacking() {
        return this._backing;
    }

    public PersistentDependency getDepend() {
        return this.getJarDepend();
    }

    private JarDepend getJarDepend() {
        if (this._depend == null || this._depend.isModified()) {
            this._depend = new JarDepend(new Depend(this.getBacking()));
        }
        return this._depend;
    }

    public int getChangeSequence() {
        return this._changeSequence.get();
    }

    private boolean isSigned() {
        Boolean isSigned = this._isSigned;
        if (isSigned != null) {
            return isSigned;
        }
        try {
            Manifest manifest = this.getManifest();
            if (manifest == null) {
                this._isSigned = Boolean.FALSE;
                return false;
            }
            Map<String, Attributes> entries = manifest.getEntries();
            if (entries == null) {
                this._isSigned = Boolean.FALSE;
                return false;
            }
            for (Attributes attr : entries.values()) {
                for (Object key : attr.keySet()) {
                    String keyString = String.valueOf(key);
                    if (!keyString.contains("Digest")) continue;
                    this._isSigned = Boolean.TRUE;
                    return true;
                }
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this._isSigned = Boolean.FALSE;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws IOException {
        Manifest manifest;
        Jar jar = this;
        synchronized (jar) {
            JarFile jarFile = this.getJarFile();
            manifest = jarFile == null ? null : jarFile.getManifest();
        }
        this.closeJarFile();
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Certificate[] getCertificates(String path) {
        if (!this.isSigned()) {
            return null;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        try {
            JarFile jarFile;
            block8: {
                Certificate[] certificateArray;
                if (!this._backing.canRead()) {
                    return null;
                }
                jarFile = new JarFile(this._backing.getNativePath());
                InputStream is = null;
                try {
                    JarEntry entry = jarFile.getJarEntry(path);
                    if (entry == null) break block8;
                    is = jarFile.getInputStream(entry);
                    while (is.skip(65536L) > 0L) {
                    }
                    is.close();
                    certificateArray = entry.getCertificates();
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    jarFile.close();
                    throw throwable;
                }
                jarFile.close();
                return certificateArray;
            }
            Object var7_8 = null;
            jarFile.close();
            return null;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public boolean exists(String path) {
        try {
            ZipEntry entry = this.getJarEntry(path);
            return entry != null;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean isDirectory(String path) {
        boolean result = false;
        try {
            ZipEntry entry = this.getJarEntry(path);
            return entry != null && entry.isDirectory();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean isFile(String path) {
        try {
            ZipEntry entry = this.getJarEntry(path);
            return entry != null && !entry.isDirectory();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public long getLastModified(String path) {
        try {
            ZipEntry entry = this.getJarEntry(path);
            return entry != null ? entry.getTime() : -1L;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return -1L;
        }
    }

    public long getLength(String path) {
        try {
            ZipEntry entry = this.getJarEntry(path);
            long length = entry != null ? entry.getSize() : -1L;
            return length;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return -1L;
        }
    }

    public boolean canRead(String path) {
        try {
            ZipEntry entry = this.getJarEntry(path);
            return entry != null && !entry.isDirectory();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean canWrite(String path) {
        return false;
    }

    public String[] list(String path) throws IOException {
        return new String[0];
    }

    public StreamImpl openReadImpl(Path path) throws IOException {
        block4: {
            ZipStreamImpl zipStreamImpl;
            block5: {
                String pathName = path.getPath();
                if (pathName.length() > 0 && pathName.charAt(0) == '/') {
                    pathName = pathName.substring(1);
                }
                ZipFile zipFile = new ZipFile(this._backing.getNativePath());
                InputStream is = null;
                try {
                    ZipEntry entry = zipFile.getEntry(pathName);
                    if (entry == null) break block4;
                    is = zipFile.getInputStream(entry);
                    zipStreamImpl = new ZipStreamImpl(zipFile, is, null, path);
                    Object var8_7 = null;
                    if (is != null) break block5;
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var8_8 = null;
                        if (is != null) break block6;
                        zipFile.close();
                    }
                    throw throwable;
                }
                zipFile.close();
            }
            return zipStreamImpl;
        }
        throw new FileNotFoundException(path.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        JarFile jarFile = null;
        Jar jar = this;
        synchronized (jar) {
            SoftReference<JarFile> jarFileRef = this._jarFileRef;
            this._jarFileRef = null;
            if (jarFileRef != null) {
                jarFile = jarFileRef.get();
            }
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipEntry getJarEntry(String path) throws IOException {
        ZipEntry entry = this._zipEntryCache.get(path);
        if (entry != null && this.isCacheValid()) {
            if (entry == NULL_ZIP) {
                return null;
            }
            return entry;
        }
        Jar jar = this;
        synchronized (jar) {
            entry = this.getJarEntryImpl(path);
        }
        this.closeJarFile();
        if (entry != null) {
            this._zipEntryCache.put(path, entry);
        } else {
            this._zipEntryCache.put(path, NULL_ZIP);
        }
        return entry;
    }

    private ZipEntry getJarEntryImpl(String path) throws IOException {
        JarFile jarFile;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((jarFile = this.getJarFile()) != null) {
            return jarFile.getJarEntry(path);
        }
        return null;
    }

    private JarFile getJarFile() throws IOException {
        JarFile jarFile = null;
        this.isCacheValid();
        SoftReference<JarFile> jarFileRef = this._jarFileRef;
        if (jarFileRef != null && (jarFile = jarFileRef.get()) != null) {
            return jarFile;
        }
        SoftReference<JarFile> oldJarRef = this._jarFileRef;
        this._jarFileRef = null;
        ZipFile oldFile = null;
        if (oldJarRef != null && !this._closeJarFileRef.compareAndSet(null, oldJarRef)) {
            oldFile = oldJarRef.get();
        }
        if (oldFile != null) {
            try {
                oldFile.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this._backingIsFile) {
            try {
                jarFile = new JarFile(this._backing.getNativePath());
            }
            catch (IOException ex) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, L.l("Error opening jar file '{0}'", this._backing.getNativePath()));
                }
                throw ex;
            }
            this._jarFileRef = new SoftReference<JarFile>(jarFile);
            this.getLastModifiedImpl();
        }
        return jarFile;
    }

    private long getLastModifiedImpl() {
        this.isCacheValid();
        return this._lastModified;
    }

    private boolean isCacheValid() {
        long now = Alarm.getCurrentTime();
        if (now - this._lastTime < 100L && !Alarm.isTest()) {
            return true;
        }
        long oldLastModified = this._lastModified;
        long oldLength = this._length;
        long newLastModified = this._backing.getLastModified();
        long newLength = this._backing.getLength();
        this._lastTime = now;
        if (newLastModified == oldLastModified && newLength == oldLength) {
            this._lastTime = now;
            return true;
        }
        this._changeSequence.incrementAndGet();
        SoftReference<JarFile> oldFileRef = this._jarFileRef;
        this._jarFileRef = null;
        this._depend = null;
        this._isSigned = null;
        this._zipEntryCache.clear();
        this._lastModified = newLastModified;
        this._length = newLength;
        this._lastTime = now;
        SoftReference<JarFile> oldCloseFileRef = null;
        oldCloseFileRef = this._closeJarFileRef.getAndSet(oldFileRef);
        if (oldCloseFileRef != null) {
            JarFile oldCloseFile = oldCloseFileRef.get();
            try {
                if (oldCloseFile != null) {
                    oldCloseFile.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return false;
    }

    private void closeJarFile() {
        JarFile jarFile;
        SoftReference jarFileRef = this._closeJarFileRef.getAndSet(null);
        if (jarFileRef != null && (jarFile = (JarFile)jarFileRef.get()) != null) {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void close() {
        this.removeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent() {
        JarFile jarFile = null;
        Jar jar = this;
        synchronized (jar) {
            if (this._jarFileRef != null) {
                jarFile = this._jarFileRef.get();
            }
            this._jarFileRef = null;
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this.closeJarFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Jar jar = (Jar)o;
        return this._backing.equals(jar._backing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearJarCache() {
        LruCache<Path, Jar> jarCache = _jarCache;
        if (jarCache == null) {
            return;
        }
        ArrayList<Jar> jars = new ArrayList<Jar>();
        LruCache<Path, Jar> lruCache = jarCache;
        synchronized (lruCache) {
            Iterator<Jar> iter = jarCache.values();
            while (iter.hasNext()) {
                jars.add(iter.next());
            }
        }
        for (int i = 0; i < jars.size(); ++i) {
            Jar jar = (Jar)jars.get(i);
            if (jar == null) continue;
            jar.clearCache();
        }
    }

    public String toString() {
        return this._backing.toString();
    }

    static {
        _jarSize = new EnvironmentLocal("caucho.vfs.jar-size");
        NULL_ZIP = new ZipEntry("null");
    }

    static class JarDigestDepend
    implements PersistentDependency {
        private JarDepend _jarDepend;
        private Depend _depend;
        private boolean _isDigestModified;

        JarDigestDepend(JarDepend jarDepend, long digest) {
            this._jarDepend = jarDepend;
            this._depend = jarDepend.getDepend();
            this._isDigestModified = this._depend.getDigest() != digest;
        }

        public boolean isModified() {
            return this._isDigestModified || this._jarDepend.isModified();
        }

        public boolean logModified(Logger log) {
            return this._depend.logModified(log) || this._jarDepend.logModified(log);
        }

        public String getJavaCreateString() {
            String sourcePath = this._depend.getPath().getPath();
            long digest = this._depend.getDigest();
            return "new com.caucho.vfs.Jar.createDepend(com.caucho.vfs.Vfs.lookup(\"" + sourcePath + "\"), " + digest + "L)";
        }
    }

    class JarDepend
    extends CachedDependency
    implements PersistentDependency {
        private Depend _depend;
        private boolean _isDigestModified;

        JarDepend(Depend depend) {
            this._depend = depend;
        }

        JarDepend(Depend depend, long digest) {
            this._depend = depend;
            this._isDigestModified = this._depend.getDigest() != digest;
        }

        Depend getDepend() {
            return this._depend;
        }

        public boolean isModifiedImpl() {
            if (this._isDigestModified || this._depend.isModified()) {
                Jar.this._changeSequence.incrementAndGet();
                return true;
            }
            return false;
        }

        public boolean logModified(Logger log) {
            return this._depend.logModified(log);
        }

        public String getJavaCreateString() {
            String sourcePath = this._depend.getPath().getPath();
            long digest = this._depend.getDigest();
            return "new com.caucho.vfs.Jar.createDepend(com.caucho.vfs.Vfs.lookup(\"" + sourcePath + "\"), " + digest + "L)";
        }

        public String toString() {
            return "Jar$JarDepend[" + this._depend.getPath() + "]";
        }
    }

    static class ZipStreamImpl
    extends StreamImpl {
        private ZipFile _zipFile;
        private InputStream _zis;
        private InputStream _is;

        ZipStreamImpl(ZipFile file, InputStream zis, InputStream is, Path path) {
            this._zipFile = file;
            this._zis = zis;
            this._is = is;
            this.setPath(path);
        }

        public boolean canRead() {
            return true;
        }

        public int getAvailable() throws IOException {
            if (this._zis == null) {
                return -1;
            }
            return this._zis.available();
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            int readLen = this._zis.read(buf, off, len);
            return readLen;
        }

        public void close() throws IOException {
            ZipFile zipFile = this._zipFile;
            this._zipFile = null;
            InputStream zis = this._zis;
            this._zis = null;
            InputStream is = this._is;
            this._is = null;
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (is != null) {
                is.close();
            }
        }

        protected void finalize() throws IOException {
            this.close();
        }
    }
}

