/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.LruCache;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Jar;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarPath
extends FilesystemPath {
    private static LruCache<Path, JarPath> _jarCache = new LruCache(256);
    private Path _backing;

    protected JarPath(FilesystemPath root, String userPath, String path, Path backing) {
        super(root, userPath, path);
        if (this._root == null) {
            this._root = this;
        }
        if (backing instanceof JarPath) {
            throw new IllegalStateException(backing.toString() + " is already a jar");
        }
        this._backing = backing;
    }

    public static JarPath create(Path backing) {
        if (backing instanceof JarPath) {
            return (JarPath)backing;
        }
        JarPath path = _jarCache.get(backing);
        if (path == null) {
            path = new JarPath(null, "/", "/", backing);
            _jarCache.put(backing, path);
        }
        return path;
    }

    @Override
    public Path fsWalk(String userPath, Map<String, Object> attributes, String path) {
        if ("/".equals(userPath) && "/".equals(path)) {
            return this._root;
        }
        return new JarPath(this._root, userPath, path, this._backing);
    }

    @Override
    public String getScheme() {
        return "jar";
    }

    @Override
    public boolean isPathCacheable() {
        return true;
    }

    @Override
    public String getURL() {
        String path = this.getFullPath();
        return this.getScheme() + ":" + this.getContainer().getURL() + "!" + path;
    }

    public Path getContainer() {
        return this._backing;
    }

    @Override
    public Certificate[] getCertificates() {
        return this.getJar().getCertificates(this.getPath());
    }

    @Override
    public boolean exists() {
        return this.getJar().exists(this.getPath());
    }

    @Override
    public boolean isDirectory() {
        return this.getJar().isDirectory(this.getPath());
    }

    @Override
    public boolean isFile() {
        return this.getJar().isFile(this.getPath());
    }

    @Override
    public long getLength() {
        return this.getJar().getLength(this.getPath());
    }

    @Override
    public long getLastModified() {
        return this.getJar().getLastModified(this.getPath());
    }

    @Override
    public boolean canRead() {
        return this.getJar().canRead(this.getPath());
    }

    @Override
    public boolean canWrite() {
        return this.getJar().canWrite(this.getPath());
    }

    @Override
    public String[] list() throws IOException {
        return this.getJar().list(this.getPath());
    }

    public Manifest getManifest() throws IOException {
        return this.getJar().getManifest();
    }

    public PersistentDependency getDepend() {
        return this.getJar().getDepend();
    }

    @Override
    public StreamImpl openReadImpl() throws IOException {
        return this.getJar().openReadImpl(this);
    }

    protected Jar getJar() {
        return Jar.create(this._backing);
    }

    public void closeJar() {
        Jar jar = Jar.getJar(this._backing);
        if (jar != null) {
            jar.close();
        }
    }

    @Override
    public String toString() {
        return "jar:(" + this._backing + ")" + this.getPath();
    }

    @Override
    public int hashCode() {
        return 65531 * this.getPath().hashCode() + this.getContainer().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        JarPath jarPath = (JarPath)o;
        return this._backing.equals(jarPath._backing) && this.getPath().equals(jarPath.getPath());
    }
}

