/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.inject.Module;
import com.caucho.util.Alarm;
import com.caucho.util.JniTroubleshoot;
import com.caucho.vfs.JniStream;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public final class JniSocketImpl
extends QSocket {
    private static final Logger log = Logger.getLogger(JniSocketImpl.class.getName());
    private static boolean _hasJni;
    private static final JniTroubleshoot _jniTroubleshoot;
    private long _fd;
    private JniStream _stream;
    private final byte[] _localAddrBuffer = new byte[16];
    private final char[] _localAddrCharBuffer = new char[256];
    private int _localAddrLength;
    private String _localName;
    private InetAddress _localAddr;
    private int _localPort;
    private final byte[] _remoteAddrBuffer = new byte[16];
    private final char[] _remoteAddrCharBuffer = new char[256];
    private int _remoteAddrLength;
    private String _remoteName;
    private InetAddress _remoteAddr;
    private int _remotePort;
    private boolean _isSecure;
    private Object _readLock = new Object();
    private Object _writeLock = new Object();
    private final AtomicBoolean _isClosed = new AtomicBoolean();

    JniSocketImpl() {
        this._fd = this.nativeAllocate();
    }

    public static boolean isEnabled() {
        return _jniTroubleshoot.isEnabled();
    }

    public static String getInitMessage() {
        if (!_jniTroubleshoot.isEnabled()) {
            return _jniTroubleshoot.getMessage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean accept(long serverSocketFd) {
        this._localName = null;
        this._localAddr = null;
        this._localAddrLength = 0;
        this._remoteName = null;
        this._remoteAddr = null;
        this._remoteAddrLength = 0;
        this._isSecure = false;
        this._isClosed.set(false);
        JniSocketImpl jniSocketImpl = this;
        synchronized (jniSocketImpl) {
            return this.nativeAccept(serverSocketFd, this._fd, this._localAddrBuffer, this._remoteAddrBuffer);
        }
    }

    public long getFd() {
        return this._fd;
    }

    public int getNativeFd() {
        return this.getNativeFd(this._fd);
    }

    public int getLocalPort() {
        return this._localPort;
    }

    public String getRemoteHost() {
        if (this._remoteName == null) {
            byte[] remoteAddrBuffer = this._remoteAddrBuffer;
            char[] remoteAddrCharBuffer = this._remoteAddrCharBuffer;
            if (this._remoteAddrLength <= 0) {
                this._remoteAddrLength = this.createIpAddress(remoteAddrBuffer, remoteAddrCharBuffer);
            }
            this._remoteName = new String(remoteAddrCharBuffer, 0, this._remoteAddrLength);
        }
        return this._remoteName;
    }

    public InetAddress getRemoteAddress() {
        if (this._remoteAddr == null) {
            try {
                this._remoteAddr = InetAddress.getByName(this.getRemoteHost());
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._remoteAddr;
    }

    public int getRemoteAddress(byte[] buffer, int offset, int length) {
        int len = this._remoteAddrLength;
        if (len <= 0) {
            len = this._remoteAddrLength = this.createIpAddress(this._remoteAddrBuffer, this._remoteAddrCharBuffer);
        }
        char[] charBuffer = this._remoteAddrCharBuffer;
        for (int i = len - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)charBuffer[i];
        }
        return len;
    }

    public byte[] getRemoteIP() {
        return this._remoteAddrBuffer;
    }

    public int getRemotePort() {
        return this._remotePort;
    }

    public String getLocalHost() {
        if (this._localName == null) {
            byte[] localAddrBuffer = this._localAddrBuffer;
            char[] localAddrCharBuffer = this._localAddrCharBuffer;
            if (this._localAddrLength <= 0) {
                this._localAddrLength = this.createIpAddress(localAddrBuffer, localAddrCharBuffer);
            }
            this._localName = new String(localAddrCharBuffer, 0, this._localAddrLength);
        }
        return this._localName;
    }

    public InetAddress getLocalAddress() {
        if (this._localAddr == null) {
            try {
                this._localAddr = InetAddress.getByName(this.getLocalHost());
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._localAddr;
    }

    public int getLocalAddress(byte[] buffer, int offset, int length) {
        System.arraycopy(this._localAddrBuffer, 0, buffer, offset, this._localAddrLength);
        return this._localAddrLength;
    }

    public void setSecure(boolean isSecure) {
        this._isSecure = isSecure;
    }

    public final boolean isSecure() {
        return this._isSecure;
    }

    public String getCipherSuite() {
        return this.getCipher(this._fd);
    }

    public int getCipherBits() {
        return this.getCipherBits(this._fd);
    }

    public X509Certificate getClientCertificate() throws CertificateException {
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        int len = this.getClientCertificate(this._fd, buffer, 0, buffer.length);
        X509Certificate cert = null;
        if (len > 0 && len < buffer.length) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream is = new ByteArrayInputStream(buffer, 0, len);
                cert = (X509Certificate)cf.generateCertificate(is);
                ((InputStream)is).close();
            }
            catch (IOException e) {
                return null;
            }
        }
        TempBuffer.free(tb);
        tb = null;
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readNonBlock(int ms) {
        Object object = this._readLock;
        synchronized (object) {
            return this.nativeReadNonBlock(this._fd, ms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int offset, int length, long timeout) throws IOException {
        Object object = this._readLock;
        synchronized (object) {
            long expires = timeout + Alarm.getCurrentTimeActual();
            int result = 0;
            while ((result = this.readNative(this._fd, buffer, offset, length, timeout)) == -4 && Alarm.getCurrentTimeActual() <= expires) {
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
        Object object = this._writeLock;
        synchronized (object) {
            if (!isEnd) {
                return this.writeNative(this._fd, buffer, offset, length);
            }
            this._isClosed.set(true);
            return this.writeCloseNative(this._fd, buffer, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush() throws IOException {
        Object object = this._writeLock;
        synchronized (object) {
            return this.flushNative(this._fd);
        }
    }

    public StreamImpl getStream() throws IOException {
        if (this._stream == null) {
            this._stream = new JniStream(this);
        }
        this._stream.init();
        return this._stream;
    }

    public long getTotalReadBytes() {
        return this._stream == null ? 0L : this._stream.getTotalReadBytes();
    }

    public long getTotalWriteBytes() {
        return this._stream == null ? 0L : this._stream.getTotalWriteBytes();
    }

    private int createIpAddress(byte[] address, char[] buffer) {
        if (this.isIpv4(address)) {
            return this.createIpv4Address(address, 0, buffer, 0);
        }
        int offset = 0;
        boolean isZeroCompress = false;
        boolean isInZeroCompress = false;
        buffer[offset++] = 91;
        for (int i = 0; i < 16; i += 2) {
            int value = (address[i] & 0xFF) * 256 + (address[i + 1] & 0xFF);
            if (value == 0 && i != 14) {
                if (isInZeroCompress) continue;
                if (!isZeroCompress) {
                    isZeroCompress = true;
                    isInZeroCompress = true;
                    continue;
                }
            }
            if (isInZeroCompress) {
                isInZeroCompress = false;
                buffer[offset++] = 58;
                buffer[offset++] = 58;
            } else if (i != 0) {
                buffer[offset++] = 58;
            }
            if (value == 0) {
                buffer[offset++] = 48;
                continue;
            }
            offset = this.writeHexDigit(buffer, offset, value >> 12);
            offset = this.writeHexDigit(buffer, offset, value >> 8);
            offset = this.writeHexDigit(buffer, offset, value >> 4);
            offset = this.writeHexDigit(buffer, offset, value);
        }
        buffer[offset++] = 93;
        return offset;
    }

    private boolean isIpv4(byte[] buffer) {
        if (buffer[10] != -1 || buffer[11] != -1) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            if (buffer[i] == 0) continue;
            return false;
        }
        return true;
    }

    private int writeHexDigit(char[] buffer, int offset, int value) {
        if (value == 0) {
            return offset;
        }
        buffer[offset++] = (value &= 0xF) < 10 ? (char)(48 + value) : (char)(97 + value - 10);
        return offset;
    }

    private int createIpv4Address(byte[] address, int addressOffset, char[] buffer, int bufferOffset) {
        int tailOffset = bufferOffset;
        for (int i = 12; i < 16; ++i) {
            if (i > 12) {
                buffer[tailOffset++] = 46;
            }
            int digit = address[addressOffset + i] & 0xFF;
            int d1 = digit / 100;
            int d2 = digit / 10 % 10;
            int d3 = digit % 10;
            if (digit >= 100) {
                buffer[tailOffset++] = (char)(48 + d1);
            }
            if (digit >= 10) {
                buffer[tailOffset++] = (char)(48 + d2);
            }
            buffer[tailOffset++] = (char)(48 + d3);
        }
        return tailOffset - bufferOffset;
    }

    public boolean isClosed() {
        return this._isClosed.get();
    }

    public void forceShutdown() {
        this.nativeCloseFd(this._fd);
    }

    public void close() throws IOException {
        if (this._isClosed.getAndSet(true)) {
            return;
        }
        if (this._stream != null) {
            this._stream.close();
        }
        this.nativeClose(this._fd);
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
            this.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        long fd = this._fd;
        this._fd = 0L;
        this.nativeFree(fd);
    }

    native int getNativeFd(long var1);

    native boolean nativeReadNonBlock(long var1, int var3);

    private native boolean nativeAccept(long var1, long var3, byte[] var5, byte[] var6);

    native String getCipher(long var1);

    native int getCipherBits(long var1);

    native int getClientCertificate(long var1, byte[] var3, int var4, int var5);

    native int readNative(long var1, byte[] var3, int var4, int var5, long var6) throws IOException;

    private native int writeNative(long var1, byte[] var3, int var4, int var5) throws IOException;

    private native int writeCloseNative(long var1, byte[] var3, int var4, int var5) throws IOException;

    native int writeNative2(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws IOException;

    native int flushNative(long var1) throws IOException;

    private native void nativeCloseFd(long var1);

    private native void nativeClose(long var1);

    native long nativeAllocate();

    native void nativeFree(long var1);

    public String toString() {
        return "JniSocketImpl$" + System.identityHashCode(this) + "[" + this._fd + ",fd=" + this.getNativeFd(this._fd) + "]";
    }

    static {
        JniTroubleshoot jniTroubleshoot = null;
        try {
            System.loadLibrary("resin_os");
            jniTroubleshoot = new JniTroubleshoot(JniSocketImpl.class, "resin_os");
        }
        catch (Throwable e) {
            jniTroubleshoot = new JniTroubleshoot(JniSocketImpl.class, "resin_os", e);
        }
        _jniTroubleshoot = jniTroubleshoot;
    }
}

