/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import sun.security.x509.CertAndKeyGen;
import sun.security.x509.X500Name;

public class SelfSignedCert {
    private static final Logger log = Logger.getLogger(SelfSignedCert.class.getName());
    private X509Certificate _cert;
    private PrivateKey _key;
    private KeyManagerFactory _kmf;

    private SelfSignedCert(X509Certificate cert, PrivateKey key) throws Exception {
        this._cert = cert;
        this._key = key;
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, "password".toCharArray());
        ks.setKeyEntry("anonymous", this.getPrivateKey(), "key-password".toCharArray(), this.getCertificateChain());
        kmf.init(ks, "key-password".toCharArray());
        this._kmf = kmf;
    }

    public static SelfSignedCert create(String name, String[] cipherSuites) {
        try {
            String keyAlgName = null;
            String sigAlgName = null;
            if (cipherSuites != null) {
                for (String s : cipherSuites) {
                    if (s.indexOf("RSA") >= 0 && s.indexOf("SHA") >= 0) {
                        keyAlgName = "RSA";
                        sigAlgName = "SHA1WithRSA";
                        continue;
                    }
                    if (sigAlgName == null && s.indexOf("DSS") >= 0 && s.indexOf("SHA") >= 0) {
                        keyAlgName = "DSA";
                        sigAlgName = "SHA1WithDSA";
                        continue;
                    }
                    if (sigAlgName != null || s.indexOf("RSA") < 0 || s.indexOf("MD5") < 0) continue;
                    keyAlgName = "RSA";
                    sigAlgName = "MD5WithRSA";
                }
            }
            if (sigAlgName == null) {
                keyAlgName = "DSA";
                sigAlgName = "SHA1WithDSA";
            }
            String providerName = null;
            int keysize = 1024;
            int days = 365;
            CertAndKeyGen keypair = new CertAndKeyGen(keyAlgName, sigAlgName, providerName);
            keypair.generate(keysize);
            PrivateKey privKey = keypair.getPrivateKey();
            X500Name x500name = new X500Name("CN=" + name);
            X509Certificate cert = keypair.getSelfCertificate(x500name, (long)(days * 24 * 3600));
            return new SelfSignedCert(cert, privKey);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            e.printStackTrace();
            return null;
        }
    }

    public PrivateKey getPrivateKey() {
        return this._key;
    }

    public X509Certificate[] getCertificateChain() {
        return new X509Certificate[]{this._cert};
    }

    public KeyManager[] getKeyManagers() {
        return this._kmf.getKeyManagers();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cert.getSubjectX500Principal() + "]";
    }
}

