/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TcpPath;
import com.caucho.vfs.TcpsPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

class TcpStream
extends StreamImpl {
    private static final Logger log = Logger.getLogger(TcpStream.class.getName());
    private Socket _s;
    private InputStream _is;
    private OutputStream _os;

    private TcpStream(TcpPath path, long connectTimeout, long socketTimeout, boolean isNoDelay) throws IOException {
        this.setPath(path);
        this._s = new Socket();
        if (connectTimeout > 0L) {
            this._s.connect(path.getSocketAddress(), (int)connectTimeout);
        } else {
            this._s.connect(path.getSocketAddress());
        }
        if (!this._s.isConnected()) {
            throw new IOException("connection timeout");
        }
        if (socketTimeout < 0L) {
            socketTimeout = 120000L;
        }
        this._s.setSoTimeout((int)socketTimeout);
        if (isNoDelay) {
            this._s.setTcpNoDelay(true);
        }
        try {
            if (path instanceof TcpsPath) {
                SSLContext context = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] cert, String foo) {
                    }

                    public void checkServerTrusted(X509Certificate[] cert, String foo) {
                    }
                };
                context.init(null, new TrustManager[]{tm}, null);
                SSLSocketFactory factory = context.getSocketFactory();
                this._s = factory.createSocket(this._s, path.getHost(), path.getPort(), true);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
        this._is = this._s.getInputStream();
        this._os = this._s.getOutputStream();
    }

    public void setAttribute(String name, Object value) {
        block9: {
            if (name.equals("timeout")) {
                try {
                    if (value instanceof Number) {
                        this._s.setSoTimeout(((Number)value).intValue());
                        break block9;
                    }
                    this._s.setSoTimeout(Integer.parseInt(String.valueOf(value)));
                }
                catch (SocketException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            } else if (name.equals("no-delay")) {
                try {
                    if (Boolean.TRUE.equals(value)) {
                        this._s.setTcpNoDelay(true);
                    }
                }
                catch (SocketException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
    }

    static TcpStream openRead(TcpPath path, long connectTimeout, long socketTimeout, boolean isNoDelay) throws IOException {
        return new TcpStream(path, connectTimeout, socketTimeout, isNoDelay);
    }

    static TcpStream openReadWrite(TcpPath path, long connectTimeout, long socketTimeout, boolean isNoDelay) throws IOException {
        return new TcpStream(path, connectTimeout, socketTimeout, isNoDelay);
    }

    public boolean canWrite() {
        return this._os != null;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (this._os != null) {
            this._os.write(buf, offset, length);
        }
    }

    public boolean canRead() {
        return this._is != null;
    }

    public int getAvailable() throws IOException {
        if (this._is != null) {
            return this._is.available();
        }
        return -1;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        InputStream is = this._is;
        if (is != null) {
            int len = is.read(buf, offset, length);
            if (len < 0) {
                this.close();
            }
            return len;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeWrite() throws IOException {
        Socket s2;
        OutputStream os = this._os;
        this._os = null;
        try {
            if (os != null) {
                this._s.shutdownOutput();
            }
            Object var3_2 = null;
            if (this._is != null) return;
            s2 = this._s;
            this._s = null;
            if (s2 == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this._is != null) throw throwable;
            Socket s2 = this._s;
            this._s = null;
            if (s2 == null) throw throwable;
            s2.close();
            throw throwable;
        }
        s2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        InputStream is = this._is;
        this._is = null;
        OutputStream os = this._os;
        this._os = null;
        Socket s = this._s;
        this._s = null;
        try {
            if (os != null) {
                os.close();
            }
            if (is != null) {
                is.close();
            }
            Object var5_4 = null;
            if (s == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (s == null) throw throwable;
            s.close();
            throw throwable;
        }
        s.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._s + "]";
    }
}

