/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.L10N;
import com.caucho.xml.QDOMException;
import java.io.Serializable;

public class QName
implements Comparable,
Serializable {
    protected static L10N L = new L10N(QName.class);
    private String _prefix;
    private String _localName;
    private String _namespace;
    private String _fullName;
    private String _canonicalName;

    public QName(String qName) {
        this(qName, "");
    }

    public QName(String qName, String namespace) {
        this._fullName = qName;
        if (namespace == null) {
            this._prefix = null;
            this._namespace = null;
            this._localName = this._fullName;
        } else if (namespace.equals("")) {
            this._prefix = null;
            this._namespace = "";
            this._localName = this._fullName;
        } else {
            this._namespace = namespace;
            int p = qName.indexOf(58);
            if (p > 0) {
                this._prefix = qName.substring(0, p);
                this._localName = qName.substring(p + 1);
            } else {
                this._prefix = null;
                this._localName = this._fullName;
            }
        }
    }

    public QName(String prefix, String localName, String namespace) {
        this.init(prefix, localName, namespace);
    }

    public QName(String qName, String prefix, String localName, String namespace) {
        this._fullName = qName;
        if (prefix != null) {
            this._prefix = prefix;
        }
        if (localName != null) {
            this._localName = localName;
        }
        if (namespace != null) {
            this._namespace = namespace;
        }
    }

    private void init(String prefix, String localName, String namespace) {
        if (localName == null || localName.equals("")) {
            throw new QDOMException(5, L.l("`{0}' is an invalid XML name because the local name is empty.  XML names must be `prefix:name' or simply `name'.", prefix + ":"));
        }
        this._prefix = prefix == null || prefix.equals("") ? null : prefix;
        this._localName = localName;
        this._fullName = this._prefix != null && this._prefix != "" ? this._prefix + ":" + localName : this._localName;
        if ("".equals(namespace)) {
            this._namespace = "";
            this._localName = this._fullName;
        } else if (namespace != null) {
            this._namespace = namespace;
        }
    }

    public String getName() {
        return this._fullName;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getCanonicalName() {
        if (this._canonicalName == null) {
            this._canonicalName = this._namespace != null ? "{" + this._namespace + "}" + this._localName : this._fullName;
        }
        return this._canonicalName;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getNamespaceURI() {
        return this._namespace;
    }

    public int hashCode() {
        if (this._namespace != null) {
            return this._localName.hashCode() * 65521 + this._namespace.hashCode();
        }
        return this._localName.hashCode();
    }

    public boolean equals(Object b) {
        if (this == b) {
            return true;
        }
        if (!(b instanceof QName)) {
            return false;
        }
        QName name = (QName)b;
        if (!this._localName.equals(name._localName)) {
            return false;
        }
        if (this._namespace == name._namespace) {
            return true;
        }
        return this._namespace != null && this._namespace.equals(name._namespace);
    }

    public int compareTo(Object b) {
        if (this == b) {
            return 0;
        }
        if (!(b instanceof QName)) {
            return -1;
        }
        QName name = (QName)b;
        return this.getCanonicalName().compareTo(name.getCanonicalName());
    }

    public String toString() {
        if (this._prefix != null) {
            return "QName[" + this._prefix + ":" + this.getCanonicalName() + "]";
        }
        return "QName[" + this.getCanonicalName() + "]";
    }
}

