/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.caucho.xml.stream.DOMResultXMLStreamWriterImpl;
import com.caucho.xml.stream.SAXResultXMLStreamWriterImpl;
import com.caucho.xml.stream.XMLEventWriterImpl;
import com.caucho.xml.stream.XMLStreamWriterImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;

public class XMLOutputFactoryImpl
extends XMLOutputFactory {
    private static final L10N L = new L10N(XMLOutputFactoryImpl.class);
    private boolean _repair = false;

    public XMLEventWriter createXMLEventWriter(OutputStream stream) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(stream));
    }

    public XMLEventWriter createXMLEventWriter(OutputStream stream, String encoding) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(stream, encoding));
    }

    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(result));
    }

    public XMLEventWriter createXMLEventWriter(Writer stream) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(stream));
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream stream) throws XMLStreamException {
        return new XMLStreamWriterImpl(Vfs.openWrite(stream), this._repair);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream stream, String encoding) throws XMLStreamException {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(stream, encoding);
            return new XMLStreamWriterImpl(Vfs.openWrite(osw), this._repair);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        if (result instanceof DOMResult) {
            return new DOMResultXMLStreamWriterImpl((DOMResult)result, this._repair);
        }
        if (result instanceof SAXResult) {
            return new SAXResultXMLStreamWriterImpl((SAXResult)result);
        }
        if (result instanceof StreamResult) {
            Writer writer = ((StreamResult)result).getWriter();
            if (writer != null) {
                return this.createXMLStreamWriter(writer);
            }
            OutputStream os = ((StreamResult)result).getOutputStream();
            if (os != null) {
                return this.createXMLStreamWriter(os);
            }
            throw new XMLStreamException("StreamResult has no output stream or writer");
        }
        throw new UnsupportedOperationException(L.l("Results of type {0} are not supported", result.getClass().getName()));
    }

    public XMLStreamWriter createXMLStreamWriter(Writer stream) throws XMLStreamException {
        return new XMLStreamWriterImpl(Vfs.openWrite(stream), this._repair);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException("property \"" + name + "\" not supported");
    }

    public boolean isPropertySupported(String name) {
        return false;
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if ("javax.xml.stream.isRepairingNamespaces".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("value of " + name + " must be Boolean, not " + value);
            }
        } else {
            throw new IllegalArgumentException("property \"" + name + "\" not supported");
        }
        this._repair = (Boolean)value;
    }
}

