/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2;

import com.caucho.java.LineMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.EnclosedWriteStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml2.Entities;
import com.caucho.xml2.ExtendedLocator;
import com.caucho.xml2.HtmlEntities;
import com.caucho.xml2.OtherEntities;
import com.caucho.xml2.QAbstractNode;
import com.caucho.xml2.QDocument;
import com.caucho.xml2.QDocumentType;
import com.caucho.xml2.XMLWriter;
import com.caucho.xml2.XmlEntities;
import com.caucho.xml2.XmlLatin1Entities;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlPrinter
implements XMLWriter {
    static final Logger log = Logger.getLogger(XmlPrinter.class.getName());
    static final L10N L = new L10N(XmlPrinter.class);
    private static final int NO_PRETTY = 0;
    private static final int INLINE = 1;
    private static final int NO_INDENT = 2;
    private static final int PRE = 3;
    private static final char OMITTED_SPACE = '\u0000';
    private static final char OMITTED_NEWLINE = '\u0001';
    private static final char OMITTED = '\u0002';
    private static final char NULL_SPACE = '\u0003';
    private static final char SPACE = '\u0004';
    private static final char NEWLINE = '\u0005';
    private static final char WHITESPACE = '\u0006';
    private static final int ALWAYS_EMPTY = 1;
    private static final int EMPTY_IF_EMPTY = 2;
    private static IntMap _empties = new IntMap();
    private static HashMap<String, String> _booleanAttrs;
    private static HashMap<String, String> _verbatimTags;
    private static IntMap _prettyMap;
    private WriteStream _os;
    private char[] _buffer = new char[256];
    private int _capacity = this._buffer.length;
    private int _length;
    boolean _isAutomaticMethod = true;
    boolean _isTop = true;
    boolean _isJsp = false;
    String _encoding;
    String _method;
    boolean _isText;
    boolean _isHtml;
    boolean _inHead;
    String _version;
    boolean _isAutomaticPretty = true;
    boolean _isPretty;
    int _indent;
    int _preCount;
    int _lastTextChar = 3;
    boolean _hasMetaContentType = false;
    boolean _includeContentType = true;
    boolean _printDeclaration;
    String _standalone;
    String _systemId;
    String _publicId;
    private ExtendedLocator _locator;
    boolean _escapeText = true;
    boolean _inVerbatim = false;
    private HashMap<String, String> _namespace;
    private HashMap<String, String> _cdataElements;
    private Entities _entities;
    private String _mimeType;
    private ArrayList<String> _prefixList;
    private ArrayList<String> _attributeNames = new ArrayList();
    private ArrayList<String> _attributeValues = new ArrayList();
    private char[] _cbuf = new char[256];
    private char[] _abuf = new char[256];
    private LineMap _lineMap;
    private int _line;
    private String _srcFilename;
    private int _srcLine;
    private String _currentElement;
    private Document _currentDocument;
    private boolean _isEnclosedStream;

    public XmlPrinter() {
    }

    public XmlPrinter(OutputStream os) {
        if (os instanceof WriteStream) {
            this.init((WriteStream)os);
        } else if (os instanceof EnclosedWriteStream) {
            this.init(((EnclosedWriteStream)((Object)os)).getWriteStream());
        } else {
            this._isEnclosedStream = true;
            WriteStream ws = Vfs.openWrite(os);
            try {
                ws.setEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.init(ws);
        }
    }

    public XmlPrinter(Writer writer) {
        if (writer instanceof EnclosedWriteStream) {
            this.init(((EnclosedWriteStream)((Object)writer)).getWriteStream());
        } else {
            this._isEnclosedStream = true;
            WriteStream ws = Vfs.openWrite(writer);
            this.init(ws);
        }
    }

    public void init(WriteStream os) {
        this._os = os;
        this.init();
    }

    void init() {
        String encoding = null;
        if (this._os != null) {
            encoding = this._os.getEncoding();
        }
        this._length = 0;
        this._entities = encoding == null || encoding.equals("US-ASCII") || encoding.equals("ISO-8859-1") ? XmlLatin1Entities.create() : XmlEntities.create();
        this._encoding = encoding;
        this._namespace = new HashMap();
        this._line = 1;
        this._isTop = true;
        this._hasMetaContentType = false;
        this._attributeNames.clear();
        this._attributeValues.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(Path path, Node node) throws IOException {
        WriteStream os = path.openWrite();
        try {
            new XmlPrinter(os).printXml(node);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            os.close();
            throw throwable;
        }
        os.close();
    }

    public void printXml(Node node) throws IOException {
        this._isAutomaticMethod = false;
        ((QAbstractNode)node).print(this);
        this.flush();
    }

    public void printHtml(Node node) throws IOException {
        this.setMethod("html");
        this.setVersion("4.0");
        ((QAbstractNode)node).print(this);
        this.flush();
    }

    public void printPrettyXml(Node node) throws IOException {
        this._isAutomaticMethod = false;
        this.setPretty(true);
        ((QAbstractNode)node).print(this);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printString(Node node) throws IOException {
        CharBuffer cb = CharBuffer.allocate();
        this._os = Vfs.openWrite(cb);
        this.init(this._os);
        try {
            ((QAbstractNode)node).print(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.flush();
            this._os.close();
            throw throwable;
        }
        this.flush();
        this._os.close();
        return cb.close();
    }

    public void setEscaping(boolean escapeText) {
        if (!this._isText) {
            this._escapeText = escapeText;
        }
    }

    public boolean getEscaping() {
        return this._escapeText;
    }

    public void setMethod(String method) {
        this._method = method;
        if (method == null) {
            this._isAutomaticMethod = true;
            this._isHtml = false;
        } else if (method.equals("html")) {
            this._isAutomaticMethod = false;
            this._isHtml = true;
            if (this._isAutomaticPretty) {
                this._isPretty = true;
            }
        } else if (method.equals("text")) {
            this._isAutomaticMethod = false;
            this._isText = true;
            this._escapeText = false;
        } else {
            this._isAutomaticMethod = false;
            this._isHtml = false;
        }
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
        try {
            if (encoding != null) {
                this._os.setEncoding(encoding);
                this._entities = encoding.equals("US-ASCII") || encoding.equals("ISO-8859-1") ? XmlLatin1Entities.create() : XmlEntities.create();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMimeType(String mimeType) {
        this._mimeType = mimeType;
        if (this._method == null && mimeType != null && mimeType.equals("text/html")) {
            this.setMethod("html");
        }
    }

    public void setJSP(boolean isJsp) {
        this._isJsp = isJsp;
    }

    public boolean isJSP() {
        return this._isJsp;
    }

    boolean isHtml() {
        return this._isHtml;
    }

    public void setPretty(boolean isPretty) {
        this._isPretty = isPretty;
        this._isAutomaticPretty = false;
    }

    public boolean isPretty() {
        return this._isPretty;
    }

    public void setPrintDeclaration(boolean printDeclaration) {
        this._printDeclaration = printDeclaration;
    }

    boolean getPrintDeclaration() {
        return this._printDeclaration;
    }

    public void setStandalone(String standalone) {
        this._standalone = standalone;
    }

    String getStandalone() {
        return this._standalone;
    }

    public void setSystemId(String id) {
        this._systemId = id;
    }

    String getSystemId() {
        return this._systemId;
    }

    public void setIncludeContentType(boolean include) {
        this._includeContentType = include;
    }

    public boolean getIncludeContentType() {
        return this._includeContentType;
    }

    public void setPublicId(String id) {
        this._publicId = id;
    }

    String getPublicId() {
        return this._publicId;
    }

    public Path getPath() {
        if (this._os instanceof WriteStream) {
            return this._os.getPath();
        }
        return null;
    }

    public void setLineMap(String filename) {
        this._lineMap = new LineMap(filename);
    }

    public LineMap getLineMap() {
        return this._lineMap;
    }

    public void addCdataElement(String elt) {
        if (this._cdataElements == null) {
            this._cdataElements = new HashMap();
        }
        this._cdataElements.put(elt, "");
    }

    public void print(Node node) throws IOException {
        if (node instanceof QAbstractNode) {
            ((QAbstractNode)node).print(this);
        } else {
            this.printNode(node);
        }
        if (this._isEnclosedStream) {
            this._os.flush();
        }
    }

    public void printNode(Node node) throws IOException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                this.startDocument((Document)node);
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.printNode(child);
                }
                this.endDocument();
                break;
            }
            case 1: {
                Element elt = (Element)node;
                this.startElement(elt.getNamespaceURI(), elt.getLocalName(), elt.getNodeName());
                NamedNodeMap attrs = elt.getAttributes();
                int len = attrs.getLength();
                for (int i = 0; i < len; ++i) {
                    Attr attr = (Attr)attrs.item(i);
                    this.attribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getNodeName(), attr.getNodeValue());
                }
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.printNode(child);
                }
                this.endElement(elt.getNamespaceURI(), elt.getLocalName(), elt.getNodeName());
                break;
            }
            case 3: 
            case 4: {
                CharacterData text = (CharacterData)node;
                this.text(text.getData());
                break;
            }
            case 8: {
                Comment comment = (Comment)node;
                this.comment(comment.getData());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                this.processingInstruction(pi.getNodeName(), pi.getData());
                break;
            }
        }
    }

    WriteStream getStream() {
        return this._os;
    }

    public void startDocument(Document document) throws IOException {
        this._currentDocument = document;
        this.startDocument();
    }

    @Override
    public void startDocument() throws IOException {
        this._isTop = true;
    }

    @Override
    public void endDocument() throws IOException {
        if (this._isPretty && this._lastTextChar < 4) {
            this.println();
        }
        this.flush();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = (ExtendedLocator)locator;
    }

    public void setLocation(String filename, int line, int column) {
        this._srcFilename = filename;
        this._srcLine = line;
    }

    @Override
    public void startElement(String url, String localName, String qName) throws IOException {
        if (this._isText) {
            return;
        }
        if (this._isAutomaticMethod) {
            boolean bl = this._isHtml = qName.equalsIgnoreCase("html") && (url == null || url.equals(""));
            if (this._isAutomaticPretty) {
                this._isPretty = this._isHtml;
            }
            this._isAutomaticMethod = false;
        }
        if (this._isTop) {
            this.printHeader(qName);
        }
        if (this._currentElement != null) {
            this.completeOpenTag();
        }
        this._attributeNames.clear();
        this._attributeValues.clear();
        if (this._isHtml && _verbatimTags.get(qName.toLowerCase()) != null) {
            this._inVerbatim = true;
        }
        if (this._isPretty && this._preCount <= 0) {
            this.printPrettyStart(qName);
        }
        if (this._lineMap != null) {
            if (this._locator != null) {
                this._lineMap.add(this._locator.getFilename(), this._locator.getLineNumber(), this._line);
            } else if (this._srcFilename != null) {
                this._lineMap.add(this._srcFilename, this._srcLine, this._line);
            }
        }
        this.print('<');
        this.print(qName);
        this._currentElement = qName;
        this._lastTextChar = 3;
    }

    public void printHeader(String top) throws IOException {
        if (!this._isTop) {
            return;
        }
        this._isTop = false;
        String encoding = this._encoding;
        if (encoding != null && encoding.equalsIgnoreCase("UTF-16")) {
            this.print('\ufeff');
        }
        if (this._isHtml) {
            double dVersion = 4.0;
            if (this._version != null && this._version.compareTo("4.0") < 0) {
                dVersion = 3.2;
            }
            if (this._systemId != null || this._publicId != null) {
                this.printDoctype("html");
            }
            this._entities = encoding == null || encoding.equalsIgnoreCase("ISO-8859-1") ? HtmlEntities.create(dVersion) : (encoding.equalsIgnoreCase("US-ASCII") ? HtmlEntities.create(dVersion) : OtherEntities.create(dVersion));
        } else {
            if (this._printDeclaration) {
                String version = this._version;
                if (version == null) {
                    version = "1.0";
                }
                this.print("<?xml version=\"");
                this.print(version);
                this.print("\"");
                if (!(encoding == null || encoding.equals("") || encoding.equalsIgnoreCase("UTF-16") || encoding.equalsIgnoreCase("US-ASCII"))) {
                    this.print(" encoding=\"" + encoding + "\"");
                }
                if (this._standalone != null && (this._standalone.equals("true") || this._standalone.equals("yes"))) {
                    this.print(" standalone=\"yes\"");
                }
                this.println("?>");
            }
            this.printDoctype(top);
            this._entities = encoding == null || encoding.equalsIgnoreCase("US-ASCII") || encoding.equalsIgnoreCase("ISO-8859-1") ? XmlLatin1Entities.create() : XmlEntities.create();
        }
        this._lastTextChar = 5;
    }

    private void printDoctype(String topElt) throws IOException {
        QDocumentType dtd;
        if (this._publicId != null && this._systemId != null) {
            this.println("<!DOCTYPE " + topElt + " PUBLIC \"" + this._publicId + "\" \"" + this._systemId + "\">");
        } else if (this._publicId != null) {
            this.println("<!DOCTYPE " + topElt + " PUBLIC \"" + this._publicId + "\">");
        } else if (this._systemId != null) {
            this.println("<!DOCTYPE " + topElt + " SYSTEM \"" + this._systemId + "\">");
        } else if (this._currentDocument instanceof QDocument && (dtd = (QDocumentType)this._currentDocument.getDoctype()) != null && dtd.getName() != null && dtd.getParentNode() == null) {
            dtd.print(this);
            this.println();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws IOException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws IOException {
    }

    private void printPrettyStart(String qName) throws IOException {
        int code;
        int n = code = this._isHtml ? _prettyMap.get(qName.toLowerCase()) : -1;
        if (code == 0) {
            if (this._lastTextChar == 1) {
                this.println();
            } else if (this._lastTextChar == 0) {
                this.print(' ');
            }
        } else if (code != 1 && this._lastTextChar < 6) {
            if (this._lastTextChar != 5) {
                this.println();
            }
            for (int i = 0; i < this._indent; ++i) {
                this.print(' ');
            }
        } else if (code == 1 && this._lastTextChar < 6) {
            if (this._lastTextChar == 1) {
                this.println();
            } else if (this._lastTextChar == 0) {
                this.print(' ');
            }
        }
        if (!this._isHtml || code < 0) {
            this._indent += 2;
        }
        if (code == 3) {
            ++this._preCount;
            this._lastTextChar = 97;
        } else {
            this._lastTextChar = code == 0 || code == 1 ? 97 : 3;
        }
    }

    @Override
    public void attribute(String uri, String localName, String qName, String value) throws IOException {
        if (this._isText) {
            return;
        }
        if (this._currentElement == null) {
            if (qName.equals("encoding")) {
                this._encoding = value;
                return;
            }
            if (!qName.startsWith("xmlns")) {
                throw new IOException(L.l("attribute `{0}' outside element.", qName));
            }
        }
        if ((qName = qName.intern()).startsWith("xmlns")) {
            if (localName == null) {
                localName = "";
            }
            if (this._isHtml && localName.equals("") && value.equals("")) {
                return;
            }
            this._namespace.put(localName, value);
            if (this._prefixList == null) {
                this._prefixList = new ArrayList();
            }
            if (!this._prefixList.contains(localName)) {
                this._prefixList.add(localName);
            }
            return;
        }
        if (qName.equals("xtp:jsp-attribute")) {
            this._attributeNames.add("<%= " + value + "%>");
            this._attributeValues.add(null);
            return;
        }
        if (this._isHtml && !this._hasMetaContentType && this._currentElement.equals("meta") && qName.equalsIgnoreCase("http-equiv") && value.equalsIgnoreCase("content-type")) {
            this._hasMetaContentType = true;
        }
        for (int i = 0; i < this._attributeNames.size(); ++i) {
            String oldName = this._attributeNames.get(i);
            if (oldName != qName) continue;
            this._attributeValues.set(i, value);
            return;
        }
        if (qName == null || qName.equals("")) {
            throw new NullPointerException();
        }
        this._attributeNames.add(qName);
        this._attributeValues.add(value);
    }

    public boolean finishAttributes() throws IOException {
        int i;
        if (this._currentElement == null) {
            return false;
        }
        for (i = 0; i < this._attributeNames.size(); ++i) {
            String qName = this._attributeNames.get(i);
            String value = this._attributeValues.get(i);
            if (this._isHtml && _booleanAttrs.get(qName.toLowerCase()) != null && (value == null || value.equals("") || value.equals(qName))) {
                this.print(' ');
                this.print(qName);
                continue;
            }
            this.print(' ');
            this.print(qName);
            if (value != null) {
                this.print("=\"");
                if (!this._escapeText || this._inVerbatim) {
                    this.print(value);
                } else {
                    int len = value.length();
                    int offset = 0;
                    while (len > this._abuf.length) {
                        value.getChars(offset, offset + this._abuf.length, this._abuf, 0);
                        this._entities.printText(this, this._abuf, 0, this._abuf.length, true);
                        len -= this._abuf.length;
                        offset += this._abuf.length;
                    }
                    value.getChars(offset, offset + len, this._abuf, 0);
                    this._entities.printText(this, this._abuf, 0, len, true);
                }
                this.print('\"');
                continue;
            }
            if (this._isHtml) continue;
            this.print("=\"\"");
        }
        if (this._prefixList != null && this._prefixList.size() > 0) {
            for (i = 0; i < this._prefixList.size(); ++i) {
                String prefix = this._prefixList.get(i);
                String url = this._namespace.get(prefix);
                if (prefix.equals("")) {
                    this.print(" xmlns=\"");
                    this.print(url);
                    this.print('\"');
                    continue;
                }
                if (prefix.startsWith("xmlns")) {
                    this.print(" ");
                    this.print(prefix);
                    this.print("=\"");
                    this.print(url);
                    this.print('\"');
                    continue;
                }
                this.print(" xmlns:");
                this.print(prefix);
                this.print("=\"");
                this.print(url);
                this.print('\"');
            }
            this._prefixList.clear();
            this._namespace.clear();
        }
        this._currentElement = null;
        return true;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws IOException {
        boolean isEmpty;
        String normalName;
        if (this._isText) {
            return;
        }
        String string = normalName = this._isHtml ? qName.toLowerCase() : qName;
        if (this._isHtml && _verbatimTags.get(normalName) != null) {
            this._inVerbatim = false;
        }
        int prevTextChar = this._lastTextChar;
        boolean bl = isEmpty = this._currentElement != null;
        if (this._currentElement != null) {
            this.finishAttributes();
        }
        if (this._isHtml && !this._hasMetaContentType && normalName.equals("head")) {
            if (isEmpty) {
                this.print(">");
            }
            isEmpty = false;
            this.printMetaContentType();
            this._currentElement = null;
        }
        if (isEmpty) {
            if (this._isHtml && _empties.get(normalName) >= 0) {
                this.print(">");
            } else {
                if (prevTextChar <= 2) {
                    this.print(">");
                    this.printPrettyEnd(qName);
                    this.print("</");
                    this.print(qName);
                    this.print(">");
                    return;
                }
                if (this._isHtml) {
                    this.print("></");
                    this.print(qName);
                    this.print(">");
                } else {
                    this.print("/>");
                }
            }
            if (this._isPretty) {
                this.closePretty(qName);
            }
        } else if (this._isHtml && _empties.get(normalName) >= 0 && !normalName.equals("p")) {
            if (this._isPretty) {
                this.closePretty(qName);
            }
        } else if (this._isPretty) {
            this.printPrettyEnd(qName);
            this.print("</");
            this.print(qName);
            this.print(">");
        } else {
            this.print("</");
            this.print(qName);
            this.print(">");
        }
        this._currentElement = null;
    }

    private void printPrettyEnd(String qName) throws IOException {
        int code;
        int n = code = this._isHtml ? _prettyMap.get(qName.toLowerCase()) : -1;
        if (code == 3) {
            --this._preCount;
            this._lastTextChar = 3;
            return;
        }
        if (this._preCount > 0) {
            return;
        }
        if (code == 0) {
            if (this._lastTextChar <= 2) {
                this.println();
            }
            this._lastTextChar = 97;
            return;
        }
        if (code == 1) {
            this._lastTextChar = 3;
            return;
        }
        if (!this._isHtml || code < 0) {
            this._indent -= 2;
        }
        if (this._lastTextChar <= 6) {
            if (this._lastTextChar != 5) {
                this.println();
            }
            for (int i = 0; i < this._indent; ++i) {
                this.print(' ');
            }
        }
        this._lastTextChar = 3;
    }

    private void closePretty(String qName) {
        int code;
        int n = code = this._isHtml ? _prettyMap.get(qName.toLowerCase()) : -1;
        if (code == 3) {
            --this._preCount;
            this._lastTextChar = 3;
            return;
        }
        if (this._preCount > 0) {
            return;
        }
        if (!this._isHtml || code < 0) {
            this._indent -= 2;
        }
        this._lastTextChar = code != 0 ? 3 : 97;
    }

    @Override
    public void processingInstruction(String name, String data) throws IOException {
        if (this._isText) {
            return;
        }
        if (this._currentElement != null) {
            this.completeOpenTag();
        }
        if (this._isTop && !this._isHtml && !this._isAutomaticMethod) {
            this.printHeader(null);
            this._isTop = false;
        }
        this.print("<?");
        this.print(name);
        if (data != null && data.length() > 0) {
            this.print(" ");
            this.print(data);
        }
        if (this.isHtml()) {
            this.print(">");
        } else {
            this.print("?>");
        }
        this._lastTextChar = 3;
    }

    @Override
    public void comment(String data) throws IOException {
        if (this._isText) {
            return;
        }
        int textChar = this._lastTextChar;
        if (this._currentElement != null) {
            this.completeOpenTag();
        }
        if (this._isPretty && this._preCount <= 0 && (textChar == 1 || textChar == 3)) {
            this.println();
            for (int i = 0; i < this._indent; ++i) {
                this.print(' ');
            }
        }
        this.print("<!--");
        this.print(data);
        this.print("-->");
        this._lastTextChar = 3;
    }

    @Override
    public boolean getEscapeText() {
        return this._escapeText;
    }

    @Override
    public void setEscapeText(boolean isEscaped) {
        this._escapeText = isEscaped;
    }

    @Override
    public void text(String text) throws IOException {
        int length = text.length();
        for (int offset = 0; offset < length; offset += this._cbuf.length) {
            int sublen = length - offset;
            if (sublen > this._cbuf.length) {
                sublen = this._cbuf.length;
            }
            text.getChars(offset, offset + sublen, this._cbuf, 0);
            this.text(this._cbuf, 0, sublen);
        }
    }

    @Override
    public void text(char[] buffer, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        int prevTextChar = this._lastTextChar;
        if ((this._isPretty && this._preCount <= 0 || this._isTop) && !this._isText && this.trimPrettyWhitespace(buffer, offset, length)) {
            if (prevTextChar <= 6) {
                return;
            }
            if (this._lastTextChar == 0) {
                this._lastTextChar = 4;
            }
            if (this._lastTextChar == 1) {
                this._lastTextChar = 5;
            }
        }
        int nextTextChar = this._lastTextChar;
        if (this._currentElement != null) {
            this.completeOpenTag();
            if (this._isPretty && this._preCount <= 0 && prevTextChar <= 2) {
                this.println();
            }
        }
        this._lastTextChar = nextTextChar;
        if (this._isTop) {
            if (!this._isJsp) {
                this._isTop = false;
            } else if (!this._isAutomaticMethod && !this._isHtml) {
                this.printHeader(null);
                this._isTop = false;
            }
        }
        if (this._isHtml && !this._hasMetaContentType && !this._inHead) {
            int textChar = this._lastTextChar;
            if (this._isPretty && this._preCount <= 0 && prevTextChar <= 2) {
                this.println();
            }
            this._lastTextChar = textChar;
            prevTextChar = 97;
        }
        if (this._isPretty && this._preCount <= 0) {
            char ch;
            if (prevTextChar == 1) {
                if (buffer[offset] != '\n') {
                    this.println();
                }
            } else if (prevTextChar == 0 && (ch = buffer[offset]) != ' ' && ch != '\n') {
                this.print(' ');
            }
        }
        if (this._lineMap != null) {
            if (this._locator != null) {
                this._lineMap.add(this._locator.getFilename(), this._locator.getLineNumber(), this._line);
            } else if (this._srcFilename != null) {
                this._lineMap.add(this._srcFilename, this._srcLine, this._line);
            }
        }
        if (!this._escapeText || this._inVerbatim || this._entities == null) {
            this.print(buffer, offset, length);
        } else {
            this._entities.printText(this, buffer, offset, length, false);
        }
    }

    boolean trimPrettyWhitespace(char[] buffer, int offset, int length) {
        int i;
        int textChar = 97;
        for (i = length - 1; i >= 0; --i) {
            char ch = buffer[offset + i];
            if (ch == '\r' || ch == '\n') {
                if (textChar == 5) continue;
                textChar = 1;
                continue;
            }
            if (ch == ' ' || ch == '\t') {
                if (textChar != 97 && textChar != 3) continue;
                textChar = 0;
                continue;
            }
            if (textChar == 1) {
                textChar = 5;
                break;
            }
            if (textChar != 0) break;
            textChar = 4;
            break;
        }
        this._lastTextChar = textChar;
        return i < 0 && textChar <= 6;
    }

    @Override
    public void cdata(String text) throws IOException {
        if (text.length() == 0) {
            return;
        }
        this._isTop = false;
        if (this._currentElement != null) {
            this.completeOpenTag();
        }
        if (this._lineMap != null && this._srcFilename != null) {
            this._lineMap.add(this._srcFilename, this._srcLine, this._line);
        }
        this.print("<![CDATA[");
        this.print(text);
        this.print("]]>");
        this._lastTextChar = 5;
    }

    private void completeOpenTag() throws IOException {
        boolean isHead = this._isHtml && !this._hasMetaContentType && this._currentElement.equalsIgnoreCase("head");
        this.finishAttributes();
        this.print(">");
        if (isHead) {
            this.printHeadContentType();
        }
    }

    @Override
    public void cdata(char[] buffer, int offset, int length) throws IOException {
        this.cdata(new String(buffer, offset, length));
    }

    private void printHeadContentType() throws IOException {
        this.printMetaContentType();
    }

    private void printMetaContentType() throws IOException {
        String mimeType;
        if (!this._includeContentType) {
            return;
        }
        this._hasMetaContentType = true;
        if (this._lastTextChar != 5) {
            this.println();
        }
        if (this._encoding == null || this._encoding.equals("US-ASCII")) {
            this._encoding = "ISO-8859-1";
        }
        if ((mimeType = this._mimeType) == null) {
            mimeType = "text/html";
        }
        this.println("  <meta http-equiv=\"Content-Type\" content=\"" + mimeType + "; charset=" + this._encoding + "\">");
        this._lastTextChar = 5;
    }

    void printDecl(String text) throws IOException {
        block6: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    if (i + 1 < text.length() && text.charAt(i + 1) == '#') {
                        this.print("&#38;");
                        continue block6;
                    }
                    this.print(ch);
                    continue block6;
                }
                case '\"': {
                    this.print("&#34;");
                    continue block6;
                }
                case '\'': {
                    this.print("&#39;");
                    continue block6;
                }
                case '\n': {
                    this.print("\n");
                    continue block6;
                }
                default: {
                    this.print(ch);
                }
            }
        }
    }

    void println() throws IOException {
        this.print('\n');
    }

    void println(String text) throws IOException {
        this.print(text);
        this.println();
    }

    void print(char[] buf) throws IOException {
        this.print(buf, 0, buf.length);
    }

    void print(char[] buf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.print(buf[off + i]);
        }
    }

    void print(String text) throws IOException {
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char ch = text.charAt(i);
            this.print(ch);
        }
    }

    void print(char ch) throws IOException {
        if (this._capacity <= this._length) {
            this._os.print(this._buffer, 0, this._length);
            this._length = 0;
        }
        this._buffer[this._length++] = ch;
        if (ch == '\n') {
            ++this._line;
        }
    }

    void print(int i) throws IOException {
        if (i >= 0) {
            if (i < 10) {
                this.print((char)(48 + i));
                return;
            }
            if (i < 100) {
                this.print((char)(48 + i / 10));
                this.print((char)(48 + i % 10));
                return;
            }
        }
        if (this._length >= 0) {
            this._os.print(this._buffer, 0, this._length);
            this._length = 0;
        }
        this._os.print(i);
    }

    private void flush() throws IOException {
        if (this._length >= 0) {
            this._os.print(this._buffer, 0, this._length);
            this._length = 0;
        }
        if (this._isEnclosedStream) {
            this._os.flush();
        }
    }

    private void close() throws IOException {
        this.flush();
        if (this._isEnclosedStream) {
            this._os.close();
        }
    }

    static void add(IntMap map, String name, int value) {
        map.put(name, value);
        map.put(name.toUpperCase(), value);
    }

    static void add(HashMap<String, String> map, String name) {
        map.put(name, name);
        map.put(name.toUpperCase(), name);
    }

    static {
        XmlPrinter.add(_empties, "basefont", 1);
        XmlPrinter.add(_empties, "br", 1);
        XmlPrinter.add(_empties, "area", 1);
        XmlPrinter.add(_empties, "link", 1);
        XmlPrinter.add(_empties, "img", 1);
        XmlPrinter.add(_empties, "param", 1);
        XmlPrinter.add(_empties, "hr", 1);
        XmlPrinter.add(_empties, "input", 1);
        XmlPrinter.add(_empties, "col", 1);
        XmlPrinter.add(_empties, "frame", 1);
        XmlPrinter.add(_empties, "isindex", 1);
        XmlPrinter.add(_empties, "base", 1);
        XmlPrinter.add(_empties, "meta", 1);
        XmlPrinter.add(_empties, "p", 1);
        XmlPrinter.add(_empties, "li", 1);
        XmlPrinter.add(_empties, "option", 2);
        _booleanAttrs = new HashMap();
        XmlPrinter.add(_booleanAttrs, "checked");
        XmlPrinter.add(_booleanAttrs, "compact");
        XmlPrinter.add(_booleanAttrs, "declare");
        XmlPrinter.add(_booleanAttrs, "defer");
        XmlPrinter.add(_booleanAttrs, "disabled");
        XmlPrinter.add(_booleanAttrs, "ismap");
        XmlPrinter.add(_booleanAttrs, "multiple");
        XmlPrinter.add(_booleanAttrs, "nohref");
        XmlPrinter.add(_booleanAttrs, "noresize");
        XmlPrinter.add(_booleanAttrs, "noshade");
        XmlPrinter.add(_booleanAttrs, "nowrap");
        XmlPrinter.add(_booleanAttrs, "readonly");
        XmlPrinter.add(_booleanAttrs, "selected");
        _prettyMap = new IntMap();
        XmlPrinter.add(_prettyMap, "img", 0);
        XmlPrinter.add(_prettyMap, "a", 0);
        XmlPrinter.add(_prettyMap, "embed", 0);
        XmlPrinter.add(_prettyMap, "th", 0);
        XmlPrinter.add(_prettyMap, "td", 0);
        XmlPrinter.add(_prettyMap, "tt", 1);
        XmlPrinter.add(_prettyMap, "i", 1);
        XmlPrinter.add(_prettyMap, "b", 1);
        XmlPrinter.add(_prettyMap, "big", 1);
        XmlPrinter.add(_prettyMap, "em", 1);
        XmlPrinter.add(_prettyMap, "string", 1);
        XmlPrinter.add(_prettyMap, "dfn", 1);
        XmlPrinter.add(_prettyMap, "code", 1);
        XmlPrinter.add(_prettyMap, "samp", 1);
        XmlPrinter.add(_prettyMap, "kbd", 1);
        XmlPrinter.add(_prettyMap, "var", 1);
        XmlPrinter.add(_prettyMap, "cite", 1);
        XmlPrinter.add(_prettyMap, "abbr", 1);
        XmlPrinter.add(_prettyMap, "acronym", 1);
        XmlPrinter.add(_prettyMap, "object", 1);
        XmlPrinter.add(_prettyMap, "q", 1);
        XmlPrinter.add(_prettyMap, "sub", 1);
        XmlPrinter.add(_prettyMap, "sup", 1);
        XmlPrinter.add(_prettyMap, "font", 1);
        XmlPrinter.add(_prettyMap, "small", 1);
        XmlPrinter.add(_prettyMap, "span", 1);
        XmlPrinter.add(_prettyMap, "bdo", 1);
        XmlPrinter.add(_prettyMap, "jsp:expression", 1);
        XmlPrinter.add(_prettyMap, "textarea", 3);
        XmlPrinter.add(_prettyMap, "pre", 3);
        XmlPrinter.add(_prettyMap, "html", 2);
        XmlPrinter.add(_prettyMap, "body", 2);
        XmlPrinter.add(_prettyMap, "ul", 2);
        XmlPrinter.add(_prettyMap, "table", 2);
        XmlPrinter.add(_prettyMap, "frameset", 2);
        _verbatimTags = new HashMap();
        XmlPrinter.add(_verbatimTags, "script");
        XmlPrinter.add(_verbatimTags, "style");
    }
}

