/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp;

import com.caucho.xmpp.XmppMarshal;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class AbstractXmppMarshal
implements XmppMarshal {
    private static final Logger log = Logger.getLogger(AbstractXmppMarshal.class.getName());

    public abstract void toXml(XmppStreamWriter var1, Serializable var2) throws IOException, XMLStreamException;

    public abstract Serializable fromXml(XmppStreamReader var1) throws IOException, XMLStreamException;

    protected void skipToEnd(XMLStreamReader in, String tagName) throws IOException, XMLStreamException {
        if (in == null) {
            return;
        }
        int tag = in.getEventType();
        while (tag > 0) {
            if (log.isLoggable(Level.FINEST)) {
                this.debug(in);
            }
            if (tag != 1 && tag == 2 && tagName.equals(in.getLocalName())) {
                return;
            }
            tag = in.next();
        }
    }

    protected void expectEnd(XMLStreamReader in, String tagName) throws IOException, XMLStreamException {
        this.expectEnd(in, tagName, in.nextTag());
    }

    protected void expectEnd(XMLStreamReader in, String tagName, int tag) throws IOException, XMLStreamException {
        if (tag != 2) {
            throw new IllegalStateException("expected </" + tagName + ">" + " at <" + in.getLocalName() + ">");
        }
        if (!tagName.equals(in.getLocalName())) {
            throw new IllegalStateException("expected </" + tagName + ">" + " at </" + in.getLocalName() + ">");
        }
    }

    protected void debug(XMLStreamReader in) throws IOException, XMLStreamException {
        if (1 == in.getEventType()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<").append(in.getLocalName());
            if (in.getNamespaceURI() != null) {
                sb.append("{").append(in.getNamespaceURI()).append("}");
            }
            for (int i = 0; i < in.getAttributeCount(); ++i) {
                sb.append(" ");
                sb.append(in.getAttributeLocalName(i));
                sb.append("='");
                sb.append(in.getAttributeValue(i));
                sb.append("'");
            }
            sb.append(">");
            log.finest(this + " " + sb);
        } else if (2 == in.getEventType()) {
            log.finest(this + " </" + in.getLocalName() + ">");
        } else if (4 == in.getEventType()) {
            String text = in.getText().trim();
            if (!"".equals(text)) {
                log.finest(this + " text='" + text + "'");
            }
        } else {
            log.finest(this + " tag=" + in.getEventType());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

