/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp;

import com.caucho.bam.ActorError;
import com.caucho.bam.ActorStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xmpp.XmppBrokerStream;
import com.caucho.xmpp.XmppContext;
import com.caucho.xmpp.XmppMarshalFactory;
import com.caucho.xmpp.XmppStreamWriterImpl;
import com.caucho.xmpp.XmppWriterImpl;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XmppAgentStream
implements ActorStream {
    private static final Logger log = Logger.getLogger(XmppAgentStream.class.getName());
    private XmppBrokerStream _packetHandler;
    private XmppContext _xmppContext;
    private WriteStream _os;
    private XmppWriterImpl _writer;

    XmppAgentStream(XmppBrokerStream packetHandler, WriteStream os) {
        this._packetHandler = packetHandler;
        this._os = os;
        this._xmppContext = packetHandler.getXmppContext();
        XmppMarshalFactory marshalFactory = packetHandler.getMarshalFactory();
        XmppStreamWriterImpl out = new XmppStreamWriterImpl(this._os, marshalFactory);
        this._writer = new XmppWriterImpl(this._xmppContext, out);
    }

    public String getJid() {
        return this._packetHandler.getJid();
    }

    public void message(String to, String from, Serializable value) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send message to=" + to + " from=" + from);
            }
            this._writer.message(to, from, value);
            this._os.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void messageError(String to, String from, Serializable value, ActorError error) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send error message to=" + to + " from=" + from + " error=" + error);
            }
            this._os.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void queryGet(long id, String to, String from, Serializable query) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " queryGet to=" + to + " from=" + from);
            }
            this._os.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void querySet(long id, String to, String from, Serializable query) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " querySet to=" + to + " from=" + from);
            }
            String xmppId = this._packetHandler.findId(id);
            this._os.print("<iq id=\"");
            this._os.print(xmppId);
            this._os.print("\" type=\"set\" to=\"");
            this._os.print(to);
            this._os.print("\" from=\"");
            this._os.print(from);
            this._os.print("\">");
            this._os.print("</iq>");
            this._os.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void queryResult(long bamId, String to, String from, Serializable value) {
        String id = this._xmppContext.findId(bamId);
        this._writer.sendQuery(id, to, from, value, "result", null);
    }

    public void queryError(long id, String to, String from, Serializable query, ActorError error) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " queryError id=" + id + " to=" + to + " from=" + from + " error=" + error);
            }
            String xmppId = this._packetHandler.findId(id);
            this._os.print("<iq id=\"");
            this._os.print(xmppId);
            this._os.print("\" type=\"error\" to=\"");
            this._os.print(to);
            this._os.print("\" from=\"");
            this._os.print(from);
            this._os.print("\">");
            this._os.print("</iq>");
            this._os.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void presence(String to, String from, Serializable data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presence to=" + to + " from=" + from + " value=" + data);
            }
            this._writer.sendPresence(to, from, data, null, null);
            this._os.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void presenceUnavailable(String to, String from, Serializable data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceUnavailable to=" + to + " from=" + from + " value=" + data);
            }
            this._writer.sendPresence(to, from, data, "unavailable", null);
            this._os.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void presenceProbe(String to, String from, Serializable data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceProbe to=" + to + " from=" + from + " value=" + data);
            }
            this._writer.sendPresence(to, from, data, "probe", null);
            this._os.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void presenceSubscribe(String to, String from, Serializable data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceSubscribe to=" + to + " from=" + from + " value=" + data);
            }
            this._writer.sendPresence(to, from, data, "subscribe", null);
            this._os.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void presenceSubscribed(String to, String from, Serializable data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceSubscribed to=" + to + " from=" + from + " value=" + data);
            }
            this._writer.sendPresence(to, from, data, "subscribed", null);
            this._os.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void presenceUnsubscribe(String to, String from, Serializable data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceUnsubscribe to=" + to + " from=" + from + " value=" + data);
            }
            this._writer.sendPresence(to, from, data, "unsubscribe", null);
            this._os.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void presenceUnsubscribed(String to, String from, Serializable data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceUnsubscribed to=" + to + " from=" + from + " value=" + data);
            }
            this._writer.sendPresence(to, from, data, "unsubscribed", null);
            this._os.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void presenceError(String to, String from, Serializable data, ActorError error) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceError to=" + to + " from=" + from + " value=" + data);
            }
            this._os.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public boolean isClosed() {
        return false;
    }

    public void close() {
    }
}

