/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp;

import com.caucho.bam.ActorClient;
import com.caucho.bam.ActorError;
import com.caucho.bam.ActorStream;
import com.caucho.bam.Broker;
import com.caucho.inject.Module;
import com.caucho.network.listen.SocketLinkDuplexController;
import com.caucho.network.listen.SocketLinkDuplexListener;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xmpp.XmppAgentStream;
import com.caucho.xmpp.XmppBindCallback;
import com.caucho.xmpp.XmppContext;
import com.caucho.xmpp.XmppMarshal;
import com.caucho.xmpp.XmppMarshalFactory;
import com.caucho.xmpp.XmppProtocol;
import com.caucho.xmpp.XmppReader;
import com.caucho.xmpp.XmppRequest;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamWriter;
import com.caucho.xmpp.XmppStreamWriterImpl;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;

@Module
public class XmppBrokerStream
implements SocketLinkDuplexListener,
ActorStream {
    private static final Logger log = Logger.getLogger(XmppBrokerStream.class.getName());
    private XmppRequest _request;
    private XmppProtocol _protocol;
    private XmppContext _xmppContext;
    private Broker _broker;
    private ActorClient _conn;
    private ActorStream _toBroker;
    private ActorStream _toClient;
    private ActorStream _authHandler;
    private ReadStream _is;
    private WriteStream _os;
    private XmppStreamReader _in;
    private XmppStreamWriter _out;
    private XmppReader _reader;
    private String _jid;
    private long _requestId;
    private String _uid = "test@localhost";
    private boolean _isFinest;
    private HashMap<Long, String> _idMap = new HashMap();

    XmppBrokerStream(XmppRequest request, Broker broker, ReadStream is, XmppStreamReader in, WriteStream os) {
        this._request = request;
        this._protocol = request.getProtocol();
        this._xmppContext = new XmppContext(this._protocol.getMarshalFactory());
        this._broker = broker;
        if (broker == null) {
            throw new NullPointerException();
        }
        this._in = in;
        this._os = os;
        this._uid = request.getUid();
        this._out = new XmppStreamWriterImpl(os, this._protocol.getMarshalFactory());
        this._toClient = new XmppAgentStream(this, this._os);
        this._authHandler = null;
        this._reader = new XmppReader(this._xmppContext, is, this._in, this._toClient, new XmppBindCallback(this));
        this._reader.setUid(this._uid);
        this._isFinest = log.isLoggable(Level.FINEST);
    }

    public String getJid() {
        return this._jid;
    }

    ActorStream getActorStream() {
        return this._toClient;
    }

    XmppMarshalFactory getMarshalFactory() {
        return this._protocol.getMarshalFactory();
    }

    XmppContext getXmppContext() {
        return this._xmppContext;
    }

    public void onRead(SocketLinkDuplexController context) throws IOException {
        this._reader.readNext();
    }

    public void onComplete(SocketLinkDuplexController context) throws IOException {
    }

    public void onTimeout(SocketLinkDuplexController context) throws IOException {
    }

    public boolean serviceWrite(WriteStream os, SocketLinkDuplexController controller) throws IOException {
        return false;
    }

    String login(String uid, Serializable credentials, String resource) {
        String password = (String)((Object)credentials);
        this._uid = uid + this._broker.getJid();
        this._toBroker = this._broker.getBrokerStream();
        this._jid = this._broker.createClient(this._toClient, uid, resource);
        return this._jid;
    }

    String bind(String resource, String jid) {
        Object password = null;
        this._toBroker = this._broker.getBrokerStream();
        this._jid = this._broker.createClient(this._toClient, jid, resource);
        return this._jid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String findId(long bamId) {
        HashMap<Long, String> hashMap = this._idMap;
        synchronized (hashMap) {
            return this._idMap.remove(bamId);
        }
    }

    void writeValue(Serializable value) throws IOException, XMLStreamException {
        if (value == null) {
            return;
        }
        XmppMarshalFactory marshalFactory = this._protocol.getMarshalFactory();
        XmppMarshal marshal = marshalFactory.getSerialize(value.getClass().getName());
        if (marshal != null) {
            marshal.toXml(this._out, value);
        }
    }

    public void message(String to, String from, Serializable value) {
        this._toBroker.message(to, this._jid, value);
    }

    public void messageError(String to, String from, Serializable value, ActorError error) {
        this._toBroker.messageError(to, this._jid, value, error);
    }

    public void queryGet(long id, String to, String from, Serializable value) {
        this._toBroker.queryGet(id, to, this._jid, value);
    }

    public void querySet(long id, String to, String from, Serializable value) {
        this._toBroker.querySet(id, to, this._jid, value);
    }

    public void queryResult(long id, String to, String from, Serializable value) {
        this._toBroker.queryResult(id, to, this._jid, value);
    }

    public void queryError(long id, String to, String from, Serializable value, ActorError error) {
        this._toBroker.queryError(id, to, this._jid, value, error);
    }

    public boolean isClosed() {
        return this._in == null;
    }

    public void close() {
        XmppStreamReader in = this._in;
        this._in = null;
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._conn + "]";
    }

    public void onStart(SocketLinkDuplexController context) throws IOException {
    }
}

