/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp;

import com.caucho.bam.ActorError;
import com.caucho.xmpp.XmppContext;
import com.caucho.xmpp.XmppStreamWriterImpl;
import com.caucho.xmpp.im.ImMessage;
import com.caucho.xmpp.im.ImPresence;
import com.caucho.xmpp.im.Text;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

class XmppWriterImpl {
    private static final Logger log = Logger.getLogger(XmppWriterImpl.class.getName());
    private static final String JABBERC_NS = "jabber:client";
    private XmppContext _xmppContext;
    private XmppStreamWriterImpl _out;

    XmppWriterImpl(XmppContext xmppContext, XmppStreamWriterImpl out) {
        this._xmppContext = xmppContext;
        this._out = out;
    }

    public void message(String to, String from, Serializable value) {
        this.sendMessage(to, from, null, value, null);
    }

    public void messageError(String to, String from, Serializable value, ActorError error) {
        this.sendMessage(to, from, "error", value, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(String to, String from, String type, Serializable value, ActorError error) {
        try {
            XmppStreamWriterImpl out = this._out;
            Text[] subjects = null;
            Text[] bodys = null;
            String thread = null;
            Serializable extra = null;
            Serializable[] extras = null;
            if (value instanceof ImMessage) {
                ImMessage msg = (ImMessage)value;
                if (msg.getTo() != null) {
                    to = msg.getTo();
                }
                if (msg.getFrom() != null) {
                    from = msg.getFrom();
                }
                if (msg.getType() != null) {
                    type = msg.getType();
                }
                subjects = msg.getSubjects();
                bodys = msg.getBodys();
                thread = msg.getThread();
                extras = msg.getExtra();
            } else if (value instanceof Serializable[]) {
                extras = (Serializable[])value;
            } else {
                extra = value;
            }
            XmppStreamWriterImpl xmppStreamWriterImpl = out;
            synchronized (xmppStreamWriterImpl) {
                out.writeStartElement("", "message", JABBERC_NS);
                out.writeDefaultNamespace(JABBERC_NS);
                if (to != null) {
                    out.writeAttribute("to", to);
                }
                if (from != null) {
                    out.writeAttribute("from", from);
                }
                if (type != null) {
                    out.writeAttribute("type", type);
                }
                if (subjects != null) {
                    for (Serializable serializable : subjects) {
                        out.writeStartElement("subject");
                        if (((Text)serializable).getLang() != null) {
                            out.writeAttribute("xml", "http://xml.org", "lang", ((Text)serializable).getLang());
                        }
                        out.writeCharacters(((Text)serializable).getValue());
                        out.writeEndElement();
                    }
                }
                if (bodys != null) {
                    for (Serializable serializable : bodys) {
                        out.writeStartElement("body");
                        if (((Text)serializable).getLang() != null) {
                            out.writeAttribute("xml", "http://xml.org", "lang", ((Text)serializable).getLang());
                        }
                        out.writeCharacters(((Text)serializable).getValue());
                        out.writeEndElement();
                    }
                }
                if (thread != null) {
                    out.writeStartElement("thread");
                    out.writeCharacters(thread);
                    out.writeEndElement();
                }
                if (extra != null) {
                    out.writeValue(extra);
                }
                if (extras != null) {
                    for (Serializable serializable : extras) {
                        out.writeValue(serializable);
                    }
                }
                out.writeEndElement();
                out.flush();
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " sendMessage to=" + to + " from=" + from + " msg=" + value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQuery(String id, String to, String from, Serializable value, String type, ActorError error) {
        try {
            XmppStreamWriterImpl out;
            XmppStreamWriterImpl xmppStreamWriterImpl = out = this._out;
            synchronized (xmppStreamWriterImpl) {
                out.writeStartElement("iq");
                out.writeDefaultNamespace(JABBERC_NS);
                out.writeAttribute("id", id);
                out.writeAttribute("type", type);
                if (to != null) {
                    out.writeAttribute("to", to);
                }
                if (from != null) {
                    out.writeAttribute("from", from);
                }
                out.writeValue(value);
                out.writeEndElement();
                out.flush();
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " sendQuery type=" + type + " id=" + id + " to=" + to + " from=" + from + " query=" + value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPresence(String to, String from, Serializable value, String type, ActorError error) {
        try {
            XmppStreamWriterImpl out;
            XmppStreamWriterImpl xmppStreamWriterImpl = out = this._out;
            synchronized (xmppStreamWriterImpl) {
                out.writeStartElement("presence");
                out.writeDefaultNamespace(JABBERC_NS);
                ImPresence imPresence = null;
                Text status = null;
                if (value instanceof ImPresence) {
                    imPresence = (ImPresence)value;
                    if (to == null) {
                        to = imPresence.getTo();
                    }
                    if (from == null) {
                        from = imPresence.getFrom();
                    }
                    status = imPresence.getStatus();
                }
                if (to != null) {
                    out.writeAttribute("to", to);
                }
                if (from != null) {
                    out.writeAttribute("from", from);
                }
                if (type != null) {
                    out.writeAttribute("type", type);
                }
                if (status != null) {
                    out.writeStartElement("status");
                    if (status.getLang() != null) {
                        out.writeAttribute("xml", "http://xml.org", "lang", status.getLang());
                    }
                    out.writeCharacters(status.getValue());
                    out.writeEndElement();
                }
                if (imPresence == null) {
                    out.writeValue(value);
                }
                out.writeEndElement();
                out.flush();
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " sendPresence type=" + type + " to=" + to + " from=" + from + " value=" + value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "]";
    }
}

