/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.data;

import com.caucho.xmpp.data.DataOption;
import com.caucho.xmpp.data.DataValue;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataField
implements Serializable {
    private String _label;
    private String _type = "text-single";
    private String _var;
    private String _desc;
    private boolean _isRequired;
    private DataValue[] _value;
    private DataOption[] _option;

    private DataField() {
    }

    public DataField(String type) {
        this._type = type;
    }

    public DataField(String type, String var) {
        this._type = type;
        this._var = var;
    }

    public DataField(String type, String var, String label) {
        this._type = type;
        this._var = var;
        this._label = label;
    }

    public String getType() {
        return this._type;
    }

    public String getVar() {
        return this._var;
    }

    public String getLabel() {
        return this._label;
    }

    public String getDesc() {
        return this._desc;
    }

    public void setDesc(String desc) {
        this._desc = desc;
    }

    public boolean isRequired() {
        return this._isRequired;
    }

    public void setRequired(boolean isRequired) {
        this._isRequired = isRequired;
    }

    public DataOption[] getOption() {
        return this._option;
    }

    public void setOption(DataOption[] option) {
        this._option = option;
    }

    public void setOptionList(ArrayList<DataOption> optionList) {
        if (optionList != null && optionList.size() > 0) {
            this._option = new DataOption[optionList.size()];
            optionList.toArray(this._option);
        } else {
            this._option = null;
        }
    }

    public DataValue[] getValue() {
        return this._value;
    }

    public void setValue(DataValue[] value) {
        this._value = value;
    }

    public void setValueList(ArrayList<DataValue> valueList) {
        if (valueList != null && valueList.size() > 0) {
            this._value = new DataValue[valueList.size()];
            valueList.toArray(this._value);
        } else {
            this._value = null;
        }
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[type=").append(this._type);
        if (this._isRequired) {
            sb.append(",required");
        }
        if (this._var != null) {
            sb.append(",var=").append(this._var);
        }
        if (this._label != null) {
            sb.append(",label='").append(this._label).append("'");
        }
        if (this._desc != null) {
            sb.append(",desc='").append(this._desc).append("'");
        }
        if (this._value != null) {
            for (i = 0; i < this._value.length; ++i) {
                sb.append(",value=").append(this._value[i]);
            }
        }
        if (this._option != null) {
            for (i = 0; i < this._option.length; ++i) {
                sb.append(",option=").append(this._option[i]);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

