/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.pubsub;

import com.caucho.xmpp.AbstractXmppMarshal;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamWriter;
import com.caucho.xmpp.pubsub.PubSubItem;
import com.caucho.xmpp.pubsub.PubSubItemsQuery;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;

public class XmppPubSubItemsQueryMarshal
extends AbstractXmppMarshal {
    private static final Logger log = Logger.getLogger(XmppPubSubItemsQueryMarshal.class.getName());
    private static final boolean _isFinest = log.isLoggable(Level.FINEST);

    public String getNamespaceURI() {
        return "http://jabber.org/protocol/pubsub";
    }

    public String getLocalName() {
        return null;
    }

    public String getClassName() {
        return PubSubItemsQuery.class.getName();
    }

    public void toXml(XmppStreamWriter out, Serializable object) throws IOException, XMLStreamException {
        PubSubItem[] itemList;
        PubSubItemsQuery items = (PubSubItemsQuery)object;
        out.writeStartElement("", "pubsub", this.getNamespaceURI());
        out.writeNamespace("", this.getNamespaceURI());
        out.writeStartElement("items");
        out.writeAttribute("node", items.getNode());
        if (items.getSubid() != null) {
            out.writeAttribute("subid", items.getSubid());
        }
        if (items.getMaxItems() > 0) {
            out.writeAttribute("max-items", String.valueOf(items.getMaxItems()));
        }
        if ((itemList = items.getItems()) != null) {
            for (PubSubItem item : itemList) {
                out.writeStartElement("item");
                if (item.getId() != null) {
                    out.writeAttribute("id", item.getId());
                }
                out.writeValue(item.getValue());
                out.writeEndElement();
            }
        }
        out.writeEndElement();
        out.writeEndElement();
    }

    public Serializable fromXml(XmppStreamReader in) throws IOException, XMLStreamException {
        throw new UnsupportedOperationException();
    }
}

