/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FromAttributes;
import com.caucho.xpath.pattern.FromChildren;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.UnionIterator;
import org.w3c.dom.Node;

public class UnionPattern
extends AbstractPattern {
    private AbstractPattern _left;
    private AbstractPattern _right;

    public UnionPattern(AbstractPattern left, AbstractPattern right) {
        super(null);
        if (right.getParent() instanceof FromAttributes && left.getParent() instanceof FromChildren) {
            this._left = right;
            this._right = left;
        } else {
            this._left = left;
            this._right = right;
        }
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        return this._left.match(node, env) || this._right.match(node, env);
    }

    public boolean isStrictlyAscending() {
        return this._left.getParent() instanceof FromAttributes && this._right.getParent() instanceof FromChildren;
    }

    public NodeIterator createNodeIterator(Node node, ExprEnvironment env, AbstractPattern match) throws XPathException {
        NodeIterator leftIter = this._left.createNodeIterator(node, env, this._left.copyPosition());
        NodeIterator rightIter = this._right.createNodeIterator(node, env, this._right.copyPosition());
        return new UnionIterator(env, leftIter, rightIter);
    }

    public int position(Node node, Env env, AbstractPattern pattern) throws XPathException {
        NodeIterator iter = this.select(node, env);
        int i = 1;
        while (iter.hasNext()) {
            if (iter.next() == node) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int count(Node node, Env env, AbstractPattern pattern) throws XPathException {
        NodeIterator iter = this.select(node, env);
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    public AbstractPattern getLeft() {
        return this._left;
    }

    public AbstractPattern getRight() {
        return this._right;
    }

    public String toString() {
        return this._left.toString() + "|" + this._right.toString();
    }
}

