/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.xml.QElement;
import com.caucho.xml.XMLWriter;
import com.caucho.xsl.OutputFormat;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.TransformerImpl;
import com.caucho.xsl.XslWriter;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IdentityStylesheet
extends StylesheetImpl {
    public void transform(Node xml, XMLWriter writer, TransformerImpl transformer) throws SAXException, IOException, TransformerException {
        XslWriter out = new XslWriter(null, this, transformer);
        out.init(writer);
        this.applyNode(out, xml);
        out.close();
    }

    protected void applyNode(XslWriter out, Node node) throws SAXException, IOException, TransformerException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.applyNode(out, child);
                }
                break;
            }
            case 1: {
                Node child;
                out.pushCopy(node);
                if (node instanceof QElement) {
                    for (child = ((QElement)node).getFirstAttribute(); child != null; child = child.getNextSibling()) {
                        this.applyNode(out, child);
                    }
                } else {
                    NamedNodeMap attributes = ((Element)node).getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node child2 = attributes.item(i);
                        this.applyNode(out, child2);
                    }
                }
                for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.applyNode(out, child);
                }
                out.popCopy(node);
                break;
            }
            case 3: 
            case 4: {
                String value = node.getNodeValue();
                out.print(value);
                return;
            }
            case 2: 
            case 5: {
                out.pushCopy(node);
                out.popCopy(node);
            }
        }
    }

    public OutputFormat getOutputFormat() {
        return new OutputFormat();
    }
}

