/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.VersionFactory;
import com.caucho.java.JavaCompiler;
import com.caucho.java.JavaWriter;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.util.IntMap;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttr;
import com.caucho.xml.QElement;
import com.caucho.xml.QName;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.expr.NumericExpr;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FilterPattern;
import com.caucho.xpath.pattern.FromChildren;
import com.caucho.xpath.pattern.FromContext;
import com.caucho.xpath.pattern.FromNextSibling;
import com.caucho.xpath.pattern.FromRoot;
import com.caucho.xpath.pattern.NodePattern;
import com.caucho.xpath.pattern.NodeTypePattern;
import com.caucho.xsl.AbstractStylesheetFactory;
import com.caucho.xsl.Generator;
import com.caucho.xsl.Sort;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.Template;
import com.caucho.xsl.XslNumberFormat;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.fun.KeyFun;
import com.caucho.xsl.java.TextNode;
import com.caucho.xsl.java.XslApplyImports;
import com.caucho.xsl.java.XslApplyTemplates;
import com.caucho.xsl.java.XslAttribute;
import com.caucho.xsl.java.XslAttributeSet;
import com.caucho.xsl.java.XslCallTemplate;
import com.caucho.xsl.java.XslChoose;
import com.caucho.xsl.java.XslComment;
import com.caucho.xsl.java.XslCopy;
import com.caucho.xsl.java.XslCopyOf;
import com.caucho.xsl.java.XslDecimalFormat;
import com.caucho.xsl.java.XslElement;
import com.caucho.xsl.java.XslElementNode;
import com.caucho.xsl.java.XslForEach;
import com.caucho.xsl.java.XslIf;
import com.caucho.xsl.java.XslImport;
import com.caucho.xsl.java.XslInclude;
import com.caucho.xsl.java.XslKey;
import com.caucho.xsl.java.XslMessage;
import com.caucho.xsl.java.XslNamespaceAlias;
import com.caucho.xsl.java.XslNode;
import com.caucho.xsl.java.XslNumber;
import com.caucho.xsl.java.XslOtherwise;
import com.caucho.xsl.java.XslOutput;
import com.caucho.xsl.java.XslParam;
import com.caucho.xsl.java.XslPreserveSpace;
import com.caucho.xsl.java.XslProcessingInstruction;
import com.caucho.xsl.java.XslResultDocument;
import com.caucho.xsl.java.XslSort;
import com.caucho.xsl.java.XslStripSpace;
import com.caucho.xsl.java.XslStylesheet;
import com.caucho.xsl.java.XslTemplate;
import com.caucho.xsl.java.XslText;
import com.caucho.xsl.java.XslTransform;
import com.caucho.xsl.java.XslValueOf;
import com.caucho.xsl.java.XslVariable;
import com.caucho.xsl.java.XslWhen;
import com.caucho.xsl.java.XslWithParam;
import com.caucho.xsl.java.XtpDeclaration;
import com.caucho.xsl.java.XtpDirectiveCache;
import com.caucho.xsl.java.XtpDirectivePage;
import com.caucho.xsl.java.XtpExpression;
import com.caucho.xsl.java.XtpScriptlet;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaGenerator
extends Generator {
    private static final Logger log = Logger.getLogger(JavaGenerator.class.getName());
    private static HashMap<QName, Class> _tagMap = new HashMap();
    private static HashMap<QName, Class> _topTagMap;
    private static int _count;
    Path _path;
    WriteStream _s;
    JavaWriter _out;
    ArrayList<AbstractPattern> _matchPatterns = new ArrayList();
    IntMap _matchMap = new IntMap();
    ArrayList<AbstractPattern> _selectPatterns = new ArrayList();
    IntMap _selectMap = new IntMap();
    ArrayList<Expr> _exprs = new ArrayList();
    IntMap _exprMap = new IntMap();
    ArrayList<Sort[]> _sorts = new ArrayList();
    ArrayList<NamespaceContext> _namespaces = new ArrayList();
    ArrayList<XslNumberFormat> _formats = new ArrayList();
    ArrayList<String> _functions = new ArrayList();
    ArrayList<Template> _templateList = new ArrayList();
    ArrayList<String> _stylesheets = new ArrayList();
    int _templateCount = 0;
    int _unique;
    HashMap<String, String> _macros = new HashMap();
    ArrayList<Object> _fragments = new ArrayList();
    ArrayList<String> _strings = new ArrayList();
    IntMap _stringMap = new IntMap();
    IntArray _envDepth = new IntArray();
    ArrayList<String> _modes = new ArrayList();
    private XslNode _xslNode;
    private boolean _isLineBegin;
    private int _depth;
    private int _callDepth;
    private int _selectDepth;
    private int _selectLoopDepth;
    private int _flagCount;
    private String _className;
    private String _pkg;
    private String _currentPos;
    private ClassLoader _parentLoader;
    private JavaCompiler _compiler;
    private boolean _disableEscaping;
    private boolean _printLocation = true;
    private String _oldFilename = null;
    private int _oldLine = -1;
    private boolean _hasHeader;

    JavaGenerator(AbstractStylesheetFactory xslGenerator, String className, String encoding) throws IOException {
        super(xslGenerator);
        int p;
        this._parentLoader = xslGenerator.getClassLoader();
        ArrayList pathDepends = new ArrayList();
        this._compiler = JavaCompiler.create(this._parentLoader);
        this._compiler.setClassDir(this._workPath);
        if (encoding != null) {
            if (encoding.equalsIgnoreCase("UTF-16")) {
                encoding = "UTF-8";
                this._compiler.setEncoding(encoding);
            } else {
                this._compiler.setEncoding(encoding);
            }
        }
        if ((p = className.lastIndexOf(46)) >= 0) {
            this._pkg = className.substring(0, p);
            className = className.substring(p + 1);
        } else {
            this._pkg = "_xsl";
        }
        this._className = className;
        this.init((this._pkg + "." + className).replace('.', '/') + ".java");
        String fileName = (this._pkg + "." + className).replace('.', '/') + ".java";
        this._path = this._workPath.lookup(fileName);
        this._path.getParent().mkdirs();
        this._s = this._path.openWrite();
        if (encoding != null) {
            this._s.setEncoding(encoding);
        }
        if (this._s.getEncoding() == null || this._s.getEncoding().equals("ISO-8859-1")) {
            this._s.setEncoding("JAVA");
        }
        this._out = new JavaWriter(this._s);
        this._out.setLineMap(this._lineMap);
        this._matchPatterns = new ArrayList();
        this._selectPatterns = new ArrayList();
        this._modes = new ArrayList();
        this._modes.add("");
    }

    @Override
    protected JavaWriter getOut() {
        return this._out;
    }

    public int getSelectDepth() {
        return this._selectDepth;
    }

    public void setSelectDepth(int depth) {
        this._selectDepth = depth;
    }

    public int pushSelectDepth() {
        return ++this._selectDepth;
    }

    public int popSelectDepth() {
        return this._selectDepth--;
    }

    public int getSelectLoopDepth() {
        return this._selectLoopDepth;
    }

    public int pushSelectLoopDepth() {
        return ++this._selectLoopDepth;
    }

    public int popSelectLoopDepth() {
        return this._selectLoopDepth--;
    }

    public void setSelectLoopDepth(int depth) {
        this._selectLoopDepth = depth;
    }

    public int generateId() {
        return this._unique++;
    }

    public void clearUnique() {
        this._unique = 0;
    }

    @Override
    protected void printHeader() throws IOException {
        if (this._hasHeader) {
            return;
        }
        this._hasHeader = true;
        this.println("/*");
        this.println(" * Generated by " + VersionFactory.getFullVersion());
        this.println(" */");
        this.println();
        this.println("package " + this._pkg + ";");
        this.println();
        this.println("import java.io.*;");
        this.println("import java.util.*;");
        this.println("import org.w3c.dom.*;");
        this.println("import org.xml.sax.*;");
        this.println("import com.caucho.util.*;");
        this.println("import com.caucho.xml.*;");
        this.println("import com.caucho.xpath.*;");
        this.println("import com.caucho.xpath.expr.*;");
        this.println("import com.caucho.xpath.pattern.*;");
        this.println("import com.caucho.xsl.*;");
        try {
            Class.forName("javax.servlet.Servlet");
            this.println("import javax.servlet.*;");
            this.println("import javax.servlet.jsp.*;");
            this.println("import javax.servlet.http.*;");
        }
        catch (Throwable e) {
            // empty catch block
        }
        for (int i = 0; i < this._imports.size(); ++i) {
            this.println("import " + (String)this._imports.get(i) + ";");
        }
        this.println();
        this.println("public class " + this._className + " extends JavaStylesheet {");
        this.pushDepth();
        this.println("private StylesheetEnv stylesheets[];");
    }

    @Override
    protected void generateChild(Node child) throws Exception {
        XslNode node = this.createChild(child);
        if (node != null) {
            node.generate(this._out);
        }
    }

    @Override
    protected XslNode createChild(XslNode parent, Node childNode) throws Exception {
        XslNode xslNode = this._xslNode;
        this._xslNode = parent;
        XslNode child = this.createChild(childNode);
        this._xslNode = xslNode;
        return child;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected XslNode createChild(Node child) throws Exception {
        XslNode xslNode = null;
        if (child instanceof QElement) {
            QElement elt = (QElement)child;
            Class cl = _tagMap.get(elt.getQName());
            if (cl != null) {
                xslNode = (XslNode)cl.newInstance();
                xslNode.setGenerator(this);
                xslNode.setParent(this._xslNode);
                xslNode.setStartLocation(((QAbstractNode)child).getBaseURI(), ((QAbstractNode)child).getFilename(), ((QAbstractNode)child).getLine());
                for (QAttr attr = (QAttr)elt.getFirstAttribute(); attr != null; attr = (QAttr)attr.getNextSibling()) {
                    xslNode.addAttribute(attr.getQName(), attr.getNodeValue());
                }
                xslNode.endAttributes();
                XslNode oldNode = this._xslNode;
                this._xslNode = xslNode;
                for (Node node = elt.getFirstChild(); node != null; node = node.getNextSibling()) {
                    XslNode xslChild = this.createChild(node);
                    if (xslChild == null) continue;
                    xslNode.addChild(xslChild);
                }
                xslNode.endElement();
                this._xslNode = oldNode;
            } else {
                if (child.getNodeName().startsWith("xsl:") && !"http://www.w3.org/1999/XSL/Transform".equals(child.getNamespaceURI())) {
                    throw this.error(child, L.l("<{0}> has an xsl: prefix, but is not in the {1} namespace.  XSL requires an xmlns:xsl=\"{1}\" namespace attribute.", (Object)child.getNodeName(), "http://www.w3.org/1999/XSL/Transform"));
                }
                if ("http://www.w3.org/1999/XSL/Transform".equals(child.getNamespaceURI()) || "http://www.caucho.com/XTP/1.0".equals(child.getNamespaceURI())) throw this.error(child, L.l("<{0}> is an unknown XSL tag.", child.getNodeName()));
                xslNode = new XslElementNode(elt.getQName());
                xslNode.setGenerator(this);
                xslNode.setParent(this._xslNode);
                xslNode.setStartLocation(((QAbstractNode)child).getBaseURI(), ((QAbstractNode)child).getFilename(), ((QAbstractNode)child).getLine());
                for (QAttr attr = (QAttr)elt.getFirstAttribute(); attr != null; attr = (QAttr)attr.getNextSibling()) {
                    xslNode.addAttribute(attr.getQName(), attr.getNodeValue());
                }
                xslNode.endAttributes();
                XslNode oldNode = this._xslNode;
                this._xslNode = xslNode;
                for (Node node = elt.getFirstChild(); node != null; node = node.getNextSibling()) {
                    XslNode xslChild = this.createChild(node);
                    xslNode.addChild(xslChild);
                }
                xslNode.endElement();
                this._xslNode = oldNode;
            }
        } else if (child instanceof Text) {
            xslNode = new TextNode(((Text)child).getData());
            xslNode.setGenerator(this);
            xslNode.setParent(this._xslNode);
        } else if (!(child instanceof Comment) && !(child instanceof ProcessingInstruction)) {
            throw new UnsupportedOperationException(String.valueOf(child));
        }
        if (xslNode == null) return xslNode;
        xslNode.setStartLocation(((QAbstractNode)child).getBaseURI(), ((QAbstractNode)child).getFilename(), ((QAbstractNode)child).getLine());
        return xslNode;
    }

    @Override
    protected void printTemplate(Element absNode, String name, String pattern, String mode, double priority) throws Exception {
        throw new RuntimeException();
    }

    public void addMacro(String name, String functionName) {
        this._macros.put(name, functionName);
    }

    public boolean hasMacro(String name) {
        return this._macros.keySet().contains(name);
    }

    public String createTemplatePattern(String name, AbstractPattern match, String mode, double priority) throws Exception {
        String tagName = name != null ? this.getName(name) : this.getName(match.toString());
        String function = "_xsl_template_" + tagName;
        this._functions.add(function);
        if (match != null) {
            Template template = this.addPattern(match, mode, priority, function, this._functions.size());
            this._templateList.add(template);
        } else {
            this._templateList.add(null);
        }
        return function;
    }

    @Override
    protected void startDisableEscaping() throws IOException {
        if (!this._isRawText) {
            this.println("out.disableEscaping(true);");
        }
    }

    @Override
    protected void endDisableEscaping() throws IOException {
        if (!this._isRawText) {
            this.println("out.disableEscaping(false);");
        }
    }

    @Override
    protected void writeText(String text) throws Exception {
        if (text == null || text.length() == 0) {
            return;
        }
        int index = this._stringMap.get(text);
        if (index < 0) {
            index = this._strings.size();
            this._stringMap.put(text, index);
            this._strings.add(text);
        }
        this.printLocation(this._systemId, this._filename, this._line);
        this.println("out.write(_xsl_string" + index + ", 0, " + text.length() + ");");
    }

    @Override
    protected void printElement(Node node) throws Exception {
        QElement elt = (QElement)node;
        String name = node.getNodeName();
        if (name.equals("jsp:decl") || name.equals("jsp:declaration")) {
            this.println("if (out.isFlagFirst(" + this._flagCount++ + ")) {");
            this.pushDepth();
        }
        String prefix = elt.getPrefix();
        String local = elt.getLocalName();
        String namespace = elt.getNamespaceURI();
        String[] postPrefix = (String[])this._namespaceAliases.get(namespace);
        if (postPrefix != null) {
            prefix = postPrefix[0];
            namespace = postPrefix[1];
            name = prefix == null || prefix.equals("") ? local : prefix + ":" + local;
        }
        if (this._excludedNamespaces.get(namespace) != null) {
            namespace = null;
        }
        this.printLocation(this._systemId, this._filename, this._line);
        if (namespace == null || namespace.equals("")) {
            this.print("out.pushElement(");
            this.print(name == null ? "null" : "\"" + name + "\"");
            this.println(");");
        } else {
            this.print("out.pushElement(");
            this.print(namespace == null ? "null" : "\"" + namespace + "\"");
            this.print(prefix == null ? ", null" : ", \"" + prefix + "\"");
            this.print(local == null ? ", null" : ", \"" + local + "\"");
            this.print(name == null ? ", null" : ", \"" + name + "\"");
            this.println(");");
        }
        this.printUseAttributeSet((QElement)node, false);
        NamedNodeMap list = node.getAttributes();
        for (int i = 0; i < list.getLength(); ++i) {
            QAbstractNode attr = (QAbstractNode)list.item(i);
            this.printAttribute(attr, elt);
        }
        this.generateChildren(node);
        this.println("out.popElement();");
        if (node.getNodeName().equals("jsp:decl") || node.getNodeName().equals("jsp:declaration")) {
            this.popDepth();
            this.println("}");
        }
    }

    @Override
    public void printLocation(String systemId, String filename, int line) throws Exception {
        if (this._printLocation && filename != null && !this._isSpecial) {
            this.print("out.setLocation(");
            if (systemId != null) {
                this.print("\"");
                this.printString(systemId);
                this.print("\"");
            } else {
                this.print("null");
            }
            this.print(", \"");
            this.printString(filename);
            this.println("\", " + line + ");");
            this._oldFilename = filename;
            this._oldLine = line;
        }
    }

    private void printAttribute(QAbstractNode attr, QElement elt) throws Exception {
        if (!(attr.getNodeName().equals("xsl:use-attribute-sets") || "http://www.w3.org/1999/XSL/Transform".equals(elt.getNamespace(attr.getPrefix())) || "http://www.caucho.com/XTP/1.0".equals(elt.getNamespace(attr.getPrefix())))) {
            QAbstractNode qnode = attr;
            String prefix = qnode.getPrefix();
            String local = qnode.getLocalName();
            String namespace = qnode.getNamespaceURI();
            String value = attr.getNodeValue();
            String[] postSuffix = (String[])this._namespaceAliases.get(namespace);
            if (postSuffix != null) {
                prefix = postSuffix[0];
                namespace = postSuffix[1];
            } else {
                if (value.equals("http://www.w3.org/1999/XSL/Transform") && prefix.equals("xmlns")) {
                    return;
                }
                if (value.equals("http://www.caucho.com/XTP/1.0") && prefix.equals("xmlns")) {
                    return;
                }
            }
            if (this._excludedNamespaces.get(namespace) != null) {
                namespace = null;
            }
            if ("".equals(prefix) && ("".equals(namespace) || namespace == null)) {
                String var = this.generateStringVar(value, elt);
                this.println("out.setAttribute(\"" + local + "\", " + var + ");");
            } else {
                this.print("out.pushAttribute(");
                this.print(prefix == null ? "null" : "\"" + prefix + "\"");
                this.print(local == null ? ", null" : ", \"" + local + "\"");
                this.print(namespace == null ? ", null" : ", \"" + namespace + "\"");
                this.println(");");
                this.generateString(value, 44, elt);
                this.println("out.popAttribute();");
            }
        }
    }

    @Override
    protected void pushCall() throws IOException {
        this.println("{");
        this.pushDepth();
        ++this._callDepth;
        this.println("Env _xsl_arg" + this._callDepth + " = XPath.createCall(env);");
    }

    public int pushCallDepth() {
        return ++this._callDepth;
    }

    public int popCallDepth() {
        return this._callDepth--;
    }

    public int getCallDepth() {
        return this._callDepth;
    }

    @Override
    protected void popCall() throws IOException {
        --this._callDepth;
        this.popDepth();
        this.println("}");
    }

    @Override
    protected void printApplyTemplates(AbstractPattern select, String mode, Sort[] sort) throws Exception {
        int min = 0;
        int max = Integer.MAX_VALUE;
        String applyName = "applyNode" + this.getModeName(mode);
        String env = "_xsl_arg" + this._callDepth;
        if (select == null && sort == null) {
            this.println("for (Node _xsl_node = node.getFirstChild();");
            this.println("     _xsl_node != null;");
            this.println("     _xsl_node = _xsl_node.getNextSibling()) {");
            this.println("  " + env + ".setSelect(node, null);");
            this.println("  " + env + ".setCurrentNode(_xsl_node);");
            this.println("  " + applyName + "(out, _xsl_node, " + env + ", " + min + ", " + max + ");");
            this.println("}");
        } else if (sort == null) {
            int oldSelectDepth = this._selectDepth;
            this.println(env + ".setSelect(node, _select_patterns[" + this.addSelect(select) + "]);");
            String name = this.printSelectBegin(select, false, null);
            this.println(env + ".setCurrentNode(" + name + ");");
            this.println(applyName + "(out, " + name + ", " + env + ", " + min + ", " + max + ");");
            while (this._selectDepth > oldSelectDepth) {
                this.popDepth();
                this.println("}");
                --this._selectDepth;
            }
        } else {
            this.println("{");
            this.pushDepth();
            this.println("ArrayList _xsl_list = xslSort(node, env, _select_patterns[" + this.addSelect(select) + "]" + ", _xsl_sorts[" + this._sorts.size() + "]);");
            this.println(env + ".setContextSize(_xsl_list.size());");
            this.println("for (int _xsl_i = 0; _xsl_i < _xsl_list.size(); _xsl_i++) {");
            this.println("  " + env + ".setContextPosition(_xsl_i + 1);");
            this.println("  " + applyName + "(out, (Node) _xsl_list.get(_xsl_i)" + ", " + env + ", " + min + ", " + max + ");");
            this.println("}");
            this.popDepth();
            this.println("}");
            this._sorts.add(sort);
        }
    }

    public int addSort(Sort[] sort) {
        int index = this._sorts.size();
        this._sorts.add(sort);
        return index;
    }

    @Override
    protected void printApplyImports(String mode, int min, int max) throws Exception {
    }

    @Override
    protected void printCallTemplate(String name, String mode) throws Exception {
        this.println(this.getMacroName(name) + "(out, node, _xsl_arg" + this._callDepth + ");");
    }

    public String getMacroName(String name) {
        return this._macros.get(name);
    }

    @Override
    protected void printParam(String name, String value, Element elt) throws Exception {
        this.print("_xsl_arg" + this._callDepth + ".addVar(\"" + name + "\", ");
        this.generateString(value, 43, elt);
        this.println(");");
    }

    @Override
    protected void printParam(String name, Object value) throws Exception {
        if (value instanceof Expr) {
            this.print("_exprs[" + this.addExpr((Expr)value) + "]");
            this.println(".addVar(_xsl_arg" + this._callDepth + ", \"" + name + "\", " + "node, env);");
        } else {
            this.print("_xsl_arg" + this._callDepth + ".addVar(\"");
            this.print(name);
            this.print("\", ");
            this.printVariableValue(value);
            this.println(");");
        }
    }

    @Override
    protected void printParamVariable(String name, Expr value) throws Exception {
        this.print("_exprs[" + this.addExpr(value) + "]");
        this.println(".addParam(env, \"" + name + "\", " + "node, env);");
    }

    @Override
    protected void printParamVariable(String name, Element value) throws Exception {
        if (value.getFirstChild() != null) {
            this.println("_xsl_tmp = env.getVar(\"" + name + "\");");
            this.println("if (_xsl_tmp == null)");
            this.print("  _xsl_tmp = ");
            this.printVariableValue(value);
            this.println(";");
            this.println("env.addVar(\"" + name + "\", _xsl_tmp);");
        }
    }

    @Override
    protected void printVariable(String name, Object value) throws Exception {
        if (value instanceof Expr) {
            this.print("_exprs[" + this.addExpr((Expr)value) + "]");
            this.println(".addVar(env, \"" + name + "\", node, env);");
        } else {
            this.print("env.addVar(\"");
            this.print(name);
            this.print("\", ");
            this.printVariableValue(value);
            this.println(");");
        }
    }

    @Override
    protected void printAssign(String name, Object value) throws Exception {
        if (value instanceof Expr) {
            this.print("_exprs[" + this.addExpr((Expr)value) + "]");
            this.println(".setVar(\"" + name + "\", node, env, node);");
        } else {
            this.print("env.setVar(\"");
            this.print(name);
            this.print("\", ");
            this.printVariableValue(value);
            this.println(");");
        }
    }

    private void printVariableValue(Object value) throws Exception {
        if (value instanceof Expr) {
            this.print("_exprs[" + this.addExpr((Expr)value) + "].evalObject(node, env)");
        } else if (value instanceof Node) {
            this.print("_xsl_fragment" + this._fragments.size() + "(out, node, env)");
            this._fragments.add(value);
        } else {
            throw new RuntimeException();
        }
    }

    @Override
    protected void printPopScope(int count) throws Exception {
        if (count > 0) {
            this.println("env.popVars(" + count + ");");
        }
    }

    @Override
    protected void printCopyOf(String select, Element elt) throws Exception {
        this.println("out.copyOf(_exprs[ " + this.addExpr(select) + "].evalObject(node, env));");
    }

    @Override
    protected void printSelectValue(String select, Element elt) throws Exception {
        this.printStringExpr(select, elt);
    }

    @Override
    protected void printForEach(Element element, String select) throws Exception {
        this.println("{");
        this.pushDepth();
        AbstractPattern selectPattern = null;
        try {
            selectPattern = this.parseSelect(select);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean hasExprEnv = !this.allowJavaSelect(selectPattern);
        int id = this._unique++;
        String sel = "_xsl_sel" + id;
        String oldCxt = "_xsl_cxt" + id;
        String oldCur = "_xsl_cur" + id;
        String oldSel = "_xsl_old_sel" + id;
        String oldEnv = "_xsl_env" + id;
        this.println("com.caucho.xpath.pattern.AbstractPattern " + sel + ";");
        this.print(sel + " = _select_patterns[");
        this.print(this.createNodeSet(select, element));
        this.println("];");
        this.println("Node " + oldCxt + " = env.getContextNode();");
        this.println("Node " + oldCur + " = env.getCurrentNode();");
        if (!hasExprEnv) {
            this.println("AbstractPattern " + oldSel + " = env.setSelect(node, " + sel + ");");
        }
        String iter = "_xsl_iter" + this._unique++;
        int oldSelectDepth = this._selectDepth++;
        boolean hasEnv = false;
        if (this.allowJavaSelect(selectPattern)) {
            this.println("ExprEnvironment " + oldEnv + " = env.setExprEnv(null);");
            String ptr = this.printSelectBegin(selectPattern, true, null);
            this.pushLoop();
            this.println("Node " + this.getElement() + " = node;");
            this.println("node = " + ptr + ";");
        } else {
            this.print("NodeIterator " + iter + " = " + sel);
            this.println(".select(node, " + this.getEnv() + ");");
            this.println("ExprEnvironment " + oldEnv + " = env.setExprEnv(" + iter + ");");
            this.println("while (" + iter + ".hasNext()) {");
            this.pushDepth();
            this.pushLoop();
            this.println("Node " + this.getElement() + " = node;");
            this.println("node = " + iter + ".nextNode();");
        }
        this.println("env.setCurrentNode(node);");
        AbstractPattern oldNodeListContext = this._nodeListContext;
        this._nodeListContext = this.parseMatch(select);
        this.generateChildren(element);
        this._nodeListContext = oldNodeListContext;
        this.println("node = " + this.getElement() + ";");
        this.println("env.setCurrentNode(" + oldCur + ");");
        while (this._selectDepth > oldSelectDepth) {
            this.popDepth();
            this.println("}");
            --this._selectDepth;
        }
        this.println("env.setExprEnv(" + oldEnv + ");");
        if (!hasExprEnv) {
            this.println("env.setSelect(" + oldCxt + ", " + oldSel + ");");
        }
        this.popDepth();
        this.println("}");
        this.popLoop();
    }

    @Override
    protected void printForEach(Element element, String select, Sort[] sort) throws Exception {
        this.println("{");
        this.pushDepth();
        this.println("env.setCurrentNode(node);");
        String pos = "_xsl_pos" + this._unique++;
        String list = "_xsl_list" + this._unique++;
        this.println("ArrayList " + list + " = xslSort(node, env" + ", _select_patterns[" + this.addSelect(select) + "]" + ", _xsl_sorts[" + this._sorts.size() + "]);");
        this.println("env.setContextSize(" + list + ".size());");
        this.println("for (int " + pos + " = 1; " + pos + " <= " + list + ".size(); " + pos + "++) {");
        this.pushLoop();
        this.pushDepth();
        this.println("Node " + this.getElement() + " = node;");
        this.println("node = (Node) " + list + ".get(" + pos + " - 1);");
        String oldPos = this._currentPos;
        this._currentPos = pos;
        this.println("env.setPosition(" + this._currentPos + ");");
        this._sorts.add(sort);
        AbstractPattern oldNodeListContext = this._nodeListContext;
        this._nodeListContext = this.parseMatch(select);
        this.generateChildren(element);
        this._currentPos = oldPos;
        this._nodeListContext = oldNodeListContext;
        this.println("node = " + this.getElement() + ";");
        this.popDepth();
        this.println("}");
        this.popLoop();
        this.popDepth();
        this.println("}");
    }

    public String getCurrentPosition() {
        return this._currentPos;
    }

    public void setCurrentPosition(String pos) {
        this._currentPos = pos;
    }

    @Override
    public AbstractPattern getNodeListContext() {
        return this._nodeListContext;
    }

    public void setNodeListContext(AbstractPattern context) {
        this._nodeListContext = context;
    }

    @Override
    protected void printIf(Element element, Expr test) throws Exception {
        this.print("if (");
        this.printExprTest(test, "node");
        this.println(") {");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    @Override
    protected void printChoose(Element element, Expr expr, boolean first) throws Exception {
        if (!first) {
            this.print("else if (");
        } else {
            this.print("if (");
        }
        this.printExprTest(expr, "node");
        this.println(") {");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    @Override
    protected void printOtherwise(Element element, boolean first) throws Exception {
        if (!first) {
            this.print("else ");
        }
        this.println("{");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    @Override
    void printNumber(Expr expr, XslNumberFormat format) throws Exception {
        this.print("exprNumber(out, node, env, _exprs[" + this.addExpr(expr) + "]");
        this.print(", _xsl_formats[" + this._formats.size() + "]");
        this.println(");");
        this._formats.add(format);
    }

    @Override
    void printNumber(String level, AbstractPattern countPattern, AbstractPattern fromPattern, XslNumberFormat format) throws Exception {
        if (level.equals("single")) {
            this.print("singleNumber(out, ");
        } else if (level.equals("multiple")) {
            this.print("multiNumber(out, ");
        } else if (level.equals("any")) {
            this.print("anyNumber(out, ");
        } else {
            throw this.error("xsl:number cannot understand level=`" + level + "'");
        }
        this.print("node, env, ");
        this.printPattern(countPattern);
        this.print(", ");
        this.printPattern(fromPattern);
        this.print(", _xsl_formats[" + this._formats.size() + "]");
        this.println(");");
        this._formats.add(format);
    }

    public int addFormat(XslNumberFormat format) {
        int index = this._formats.size();
        this._formats.add(format);
        return index;
    }

    @Override
    protected void printCopy(Element element) throws Exception {
        this.println("out.pushCopy(node);");
        this.printUseAttributeSet(element, true);
        this.generateChildren(element);
        this.println("out.popCopy(node);");
    }

    @Override
    protected void printResultDocument(Element element, String href, String format) throws Exception {
        this.println("XslWriter oldOut = out;");
        this.println("OutputStream os = null;");
        this.println("try {");
        this.pushDepth();
        this.print("os = out.openWrite(env, ");
        this.generateString(href, 43, element);
        this.println(");");
        this.println("out = out.openResultDocument(os);");
        this.generateChildren(element);
        this.println("out.close();");
        this.popDepth();
        this.println("} finally {");
        this.println("  if (os != null)");
        this.println("    os.close();");
        this.println("  out = oldOut;");
        this.println("}");
    }

    @Override
    protected void printElement(Element element, String name) throws Exception {
        this.print("out.pushElement(");
        this.generateString(name, 43, element);
        if (this._namespace != null) {
            this.print(", ");
            this.printNamespace(this._namespace);
        }
        this.println(");");
        this.printUseAttributeSet(element, true);
        this.generateChildren(element);
        this.println("out.popElement();");
    }

    @Override
    protected void printElement(Element element, String name, String namespace) throws Exception {
        this.print("out.pushElementNs(");
        this.generateString(name, 43, element);
        this.print(", ");
        this.generateString(namespace, 43, element);
        this.println(");");
        this.printUseAttributeSet(element, true);
        this.generateChildren(element);
        this.print("out.popElement();");
    }

    private void printUseAttributeSet(Element element, boolean isXSL) throws Exception {
        for (Attr attr = ((QElement)element).getFirstAttribute(); attr != null; attr = (Attr)attr.getNextSibling()) {
            HashMap<String, String> set;
            if ((!isXSL || !attr.getNodeName().equals("use-attribute-sets")) && (isXSL || !attr.getNodeName().equals("xsl:use-attribute-sets")) || (set = this.getAttributeSet(attr.getNodeValue())) == null) continue;
            for (String key : set.keySet()) {
                String value = set.get(key);
                this.printAttributeValue(key, value, element);
            }
        }
    }

    public HashMap<String, String> getAttributeSet(String name) {
        CharBuffer cb = CharBuffer.allocate();
        int i = 0;
        int len = name.length();
        HashMap<String, String> map = new HashMap<String, String>();
        while (i < len) {
            XslAttributeSet newSet;
            while (i < len && name.charAt(i) == ' ') {
                ++i;
            }
            cb.clear();
            while (i < len && name.charAt(i) != ' ') {
                cb.append(name.charAt(i));
                ++i;
            }
            if (cb.length() <= 0 || (newSet = (XslAttributeSet)this._attributeSets.get(cb.toString())) == null) continue;
            ArrayList<XslAttribute> attrList = newSet.getAttributes();
            for (int j = 0; j < attrList.size(); ++j) {
                XslAttribute attr = attrList.get(j);
                map.put(attr.getName(), attr.getValue());
            }
        }
        return map;
    }

    public ArrayList<XslAttribute> getAttributeSetList(String name) {
        CharBuffer cb = CharBuffer.allocate();
        int i = 0;
        int len = name.length();
        ArrayList<XslAttribute> set = new ArrayList<XslAttribute>();
        while (i < len) {
            XslAttributeSet newSet;
            while (i < len && name.charAt(i) == ' ') {
                ++i;
            }
            cb.clear();
            while (i < len && name.charAt(i) != ' ') {
                cb.append(name.charAt(i));
                ++i;
            }
            if (cb.length() <= 0 || (newSet = (XslAttributeSet)this._attributeSets.get(cb.toString())) == null) continue;
            set.addAll(newSet.getAttributes());
        }
        return set;
    }

    @Override
    protected void printAttribute(Element element, String name) throws Exception {
        this.print("out.pushAttribute(");
        this.generateString(name, 43, element);
        if (this._namespace != null) {
            this.print(", ");
            this.printNamespace(this._namespace);
        }
        this.println(");");
        this.generateChildren(element);
        this.println("out.popAttribute();");
    }

    private void printAttributeValue(String key, String value, Element elt) throws Exception {
        if (this._namespace == null && !this.attributeHasSpecial(key) && !this.attributeHasSpecial(value)) {
            this.print("out.setAttribute(");
            this.generateString(key, 43, elt);
            this.print(", ");
            this.generateString(value, 43, elt);
            this.println(");");
        } else {
            this.print("out.pushAttribute(");
            this.generateString(key, 43, elt);
            if (this._namespace != null) {
                this.print(", ");
                this.printNamespace(this._namespace);
            }
            this.println(");");
            this.generateString(value, 44, elt);
            this.println("out.popAttribute();");
        }
    }

    public void printNamespace(NamespaceContext namespace) throws Exception {
        for (int i = 0; i < this._namespaces.size(); ++i) {
            if (!this._namespaces.get(i).equals(namespace)) continue;
            this.print("_namespaces[" + i + "]");
            return;
        }
        this.print("_namespaces[" + this._namespaces.size() + "]");
        this._namespaces.add(namespace);
    }

    public int addNamespace(NamespaceContext namespace) throws Exception {
        for (int i = 0; i < this._namespaces.size(); ++i) {
            if (!this._namespaces.get(i).equals(namespace)) continue;
            return i;
        }
        this._namespaces.add(namespace);
        return this._namespaces.size() - 1;
    }

    @Override
    protected void printAttribute(Element element, String name, String namespace) throws Exception {
        this.print("out.pushAttributeNs(");
        this.generateString(name, 43, element);
        this.print(", ");
        this.generateString(namespace, 43, element);
        this.println(");");
        this.generateChildren(element);
        this.println("out.popAttribute();");
    }

    @Override
    protected void printPi(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name.equals("")) {
            throw this.error("xsl:pi expected `name' attribute.");
        }
        this.print("out.pushPi();");
        this.generateChildren(element);
        this.println("out.popPi(");
        this.generateString(name, 43, element);
        this.println(");");
    }

    @Override
    protected void printComment(Element element) throws Exception {
        this.println("out.pushComment();");
        this.generateChildren(element);
        this.println("out.popComment();");
    }

    @Override
    protected void printError(String msg) throws Exception {
        this.println("if (true) throw new javax.xml.transform.TransformerException(\"" + msg + "\");");
    }

    @Override
    protected void printMessage(Element msg) throws Exception {
        int unique = this._unique++;
        this.println("XMLWriter frag" + unique + " = out.pushFragment();");
        this.generateChildren(msg);
        String terminate = msg.getAttribute("terminate");
        if (terminate.equals("yes")) {
            this.println("if (true) throw new javax.xml.transform.TransformerException(((QAbstractNode) out.popFragment(frag" + unique + ")).getTextValue());");
        } else {
            this.println("System.err.println(((QAbstractNode) out.popFragment(frag" + unique + ")).getTextValue());");
        }
    }

    @Override
    protected void printExpression(Element element) throws Exception {
        String expr = element.getAttribute("expr");
        if (!expr.equals("")) {
            this.print("out.print(");
            this.print(expr);
            this.println(");");
        } else {
            this.print("out.print(");
            this.print(((QAbstractNode)((Object)element)).getTextValue());
            this.println(");");
        }
    }

    @Override
    protected void printScriptlet(Element element) throws Exception {
        this.println(((QAbstractNode)((Object)element)).getTextValue());
    }

    @Override
    protected void printWhile(Element element, Expr test) throws Exception {
        this.print("while (");
        this.printExprTest(test, "node");
        this.println(") {");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    @Override
    protected void printDeclaration(Element element) throws Exception {
        this.println(((QAbstractNode)((Object)element)).getTextValue());
    }

    @Override
    protected void printCacheDepends(String name) throws Exception {
        this.print("out.addCacheDepend(((com.caucho.vfs.Path) out.getProperty(\"caucho.pwd\")).lookup(\"");
        this.printString(name);
        this.println("\"));");
    }

    public String getElement() {
        return "node" + this._loopDepth;
    }

    public void pushLoop() {
        ++this._loopDepth;
    }

    public void popLoop() {
        --this._loopDepth;
    }

    public String getEnv() {
        return "env";
    }

    void pushEnv() {
        this._envDepth.add(0);
    }

    void popEnv() {
        this._envDepth.pop();
    }

    void printPattern(AbstractPattern pattern) throws Exception {
        if (pattern == null) {
            this.print("null");
        } else {
            this.print("_match_patterns[" + this._matchPatterns.size() + "]");
            this._matchPatterns.add(pattern);
        }
    }

    private int createNodeSet(String select, Element element) throws Exception {
        return this.addSelect(select);
    }

    int createSelectPattern(AbstractPattern pattern) throws Exception {
        return this.addSelect(pattern);
    }

    int createMatchPattern(String select, Element element) throws Exception {
        AbstractPattern pattern = this.parseMatch(select);
        this._matchPatterns.add(pattern);
        return this._matchPatterns.size() - 1;
    }

    String getName(String tag) {
        int i;
        CharBuffer newTag = new CharBuffer();
        block4: for (i = 0; i < tag.length(); ++i) {
            char ch = tag.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '(': 
                case ')': {
                    continue block4;
                }
                case '.': 
                case ':': 
                case '|': {
                    newTag.append('_');
                    continue block4;
                }
                default: {
                    if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && (ch < '0' || ch > '9')) continue block4;
                    newTag.append(ch);
                }
            }
        }
        tag = newTag.toString();
        if (this._names.get(tag) == null) {
            this._names.put(tag, tag);
            return tag;
        }
        i = 0;
        while (true) {
            String subname;
            if (this._names.get(subname = tag + i) == null) {
                this._names.put(subname, subname);
                return subname;
            }
            ++i;
        }
    }

    void printExprTest(Expr expr, String element) throws Exception {
        this.print("_exprs[" + this.addExpr(expr) + "].evalBoolean(" + element + ", " + this.getEnv() + ")");
    }

    public void printExprTest(int exprId, String element) throws Exception {
        this.print("_exprs[" + exprId + "].evalBoolean(" + element + ", " + this.getEnv() + ")");
    }

    private boolean attributeHasSpecial(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch == '{' && i + 1 < length) {
                if (string.charAt(i + 1) == '{') {
                    ++i;
                    continue;
                }
                return true;
            }
            if (i + 2 >= length || ch != '<' || string.charAt(i + 1) != '#' || string.charAt(i + 2) != '=') continue;
            return true;
        }
        return false;
    }

    void generateString(String string, int mode, Element elt) throws Exception {
        CharBuffer cb = new CharBuffer();
        boolean first = true;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch == '\n') {
                cb.append("\\n");
                continue;
            }
            if (ch == '\"') {
                cb.append("\\\"");
                continue;
            }
            if (ch == '{' && i + 1 < length) {
                if (string.charAt(i + 1) == '{') {
                    cb.append('{');
                    ++i;
                    continue;
                }
                if (mode == 44) {
                    if (cb.length() > 0) {
                        this.println("out.print(\"" + cb.toString() + "\");");
                    }
                } else {
                    if (!first) {
                        this.print((char)mode);
                    }
                    if (cb.length() > 0) {
                        this.print("\"");
                        this.print(cb.toString());
                        this.print("\"");
                        this.print((char)mode);
                    }
                }
                cb.clear();
                ++i;
                while (i < length && string.charAt(i) != '}') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                if (mode == 44) {
                    this.printStringExpr(cb.toString(), elt);
                } else {
                    this.stringExpr(cb.toString(), elt);
                }
                cb.clear();
                first = false;
                continue;
            }
            if (ch == '}' && i + 1 < length) {
                if (string.charAt(i + 1) == '}') {
                    cb.append('}');
                    ++i;
                    continue;
                }
                cb.append('}');
                continue;
            }
            if (i + 2 < length && ch == '<' && string.charAt(i + 1) == '#' && string.charAt(i + 2) == '=') {
                if (mode == 44) {
                    if (cb.length() > 0) {
                        this.println("out.print(\"" + cb.toString() + "\");");
                    }
                } else {
                    if (!first) {
                        this.print((char)mode);
                    }
                    if (cb.length() > 0) {
                        this.print("\"");
                        this.print(cb.toString());
                        this.print("\"");
                        this.print((char)mode);
                    }
                }
                cb.clear();
                i += 3;
                while (i + 1 < length && string.charAt(i) != '#' && string.charAt(i + 1) != '>') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                ++i;
                if (mode == 44) {
                    this.println("out.print(" + cb + ");");
                } else {
                    this.print("(" + cb + ")");
                }
                cb.clear();
                first = false;
                continue;
            }
            cb.append(ch);
        }
        if (cb.length() > 0) {
            if (mode == 44) {
                this.println("out.print(\"" + cb + "\");");
            } else {
                if (!first) {
                    this.print((char)mode);
                }
                this.print("\"" + cb + "\"");
            }
        } else if (first && mode == 43) {
            this.print("\"\"");
        }
    }

    String generateStringVar(String string, Element elt) throws Exception {
        CharBuffer cb = new CharBuffer();
        boolean first = true;
        int length = string.length();
        String strVar = "_xsl_str" + this._unique++;
        if (string.indexOf(123) < 0 && string.indexOf(125) < 0) {
            this.print("String " + strVar + " = \"");
            this.printString(string);
            this.println("\";");
            return strVar;
        }
        if (string.lastIndexOf(123) == 0 && string.indexOf(125) == string.length() - 1) {
            this.println("String " + strVar + " = \"\";");
            string = string.substring(1, string.length() - 1);
            this.addStringExpr(strVar, string, elt, true);
            return strVar;
        }
        String cbVar = "_xsl_cb" + this._unique++;
        this.println("com.caucho.util.CharBuffer " + cbVar + " = com.caucho.util.CharBuffer.allocate();");
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch == '\n') {
                cb.append("\\n");
                continue;
            }
            if (ch == '\"') {
                cb.append("\\\"");
                continue;
            }
            if (ch == '{' && i + 1 < length) {
                if (string.charAt(i + 1) == '{') {
                    cb.append('{');
                    ++i;
                    continue;
                }
                if (cb.length() > 0) {
                    this.println(cbVar + ".append(\"" + cb.toString() + "\");");
                }
                cb.clear();
                ++i;
                while (i < length && string.charAt(i) != '}') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                this.addStringExpr(cbVar, cb.toString(), elt, false);
                cb.clear();
                first = false;
                continue;
            }
            if (ch == '}' && i + 1 < length) {
                if (string.charAt(i + 1) == '}') {
                    cb.append('}');
                    ++i;
                    continue;
                }
                cb.append('}');
                continue;
            }
            if (i + 2 < length && ch == '<' && string.charAt(i + 1) == '#' && string.charAt(i + 2) == '=') {
                if (cb.length() > 0) {
                    this.println(cbVar + ".append(\"" + cb.toString() + "\");");
                }
                cb.clear();
                i += 3;
                while (i + 1 < length && string.charAt(i) != '#' && string.charAt(i + 1) != '>') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                ++i;
                this.println(cbVar + ".append(" + cb + ");");
                cb.clear();
                first = false;
                continue;
            }
            cb.append(ch);
        }
        if (cb.length() > 0) {
            this.println(cbVar + ".append(\"" + cb + "\");");
        }
        this.println("String " + strVar + " = " + cbVar + ".close();");
        return strVar;
    }

    private void printStringExpr(String exprString, Element elt) throws Exception {
        int length = exprString.length();
        if (length == 0) {
            return;
        }
        AbstractPattern select = null;
        try {
            select = this.parseSelect(exprString);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (exprString.equals(".")) {
            this.println("out.valueOf(node);");
            return;
        }
        if (exprString.charAt(0) == '@') {
            boolean isSimple = true;
            for (int i = 1; i < length; ++i) {
                char ch = exprString.charAt(i);
                if (XmlChar.isNameChar(ch) && ch != ':') continue;
                isSimple = false;
            }
            if (isSimple) {
                this.println("if (node instanceof Element)");
                this.print("  out.print(((Element) node).getAttribute(\"");
                this.print(exprString.substring(1));
                this.println("\"));");
                return;
            }
        } else if (this.allowJavaSelect(select)) {
            int oldSelectDepth = this._selectDepth;
            String loop = "_xsl_loop" + this._unique++;
            this._selectLoopDepth = 0;
            String ptr = this.printSelectBegin(select, true, loop);
            this.println("out.valueOf(" + ptr + ");");
            this.println("break " + loop + ";");
            while (this._selectDepth > oldSelectDepth) {
                this.popDepth();
                this.println("}");
                --this._selectDepth;
            }
            return;
        }
        this.println("out.valueOf(_exprs[" + this.addExpr(exprString) + "].evalObject(node, " + this.getEnv() + "));");
    }

    private void addStringExpr(String var, String exprString, Element elt, boolean isSingleString) throws Exception {
        int length = exprString.length();
        if (length == 0) {
            return;
        }
        AbstractPattern select = null;
        try {
            select = this.parseSelect(exprString);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (exprString.equals(".")) {
            if (isSingleString) {
                this.println(var + " = XmlUtil.textValue(node);");
            } else {
                this.println("XmlUtil.textValue(" + var + ", node);");
            }
            return;
        }
        if (exprString.charAt(0) == '@') {
            boolean isSimple = true;
            for (int i = 1; i < length; ++i) {
                char ch = exprString.charAt(i);
                if (XmlChar.isNameChar(ch) && ch != ':') continue;
                isSimple = false;
            }
            if (isSimple) {
                this.println("if (node instanceof Element)");
                if (isSingleString) {
                    this.print("  " + var + " = ((Element) node).getAttribute(\"");
                    this.print(exprString.substring(1));
                    this.println("\");");
                } else {
                    this.print("  " + var + ".append(((Element) node).getAttribute(\"");
                    this.print(exprString.substring(1));
                    this.println("\"));");
                }
                return;
            }
        } else if (this.allowJavaSelect(select)) {
            int oldSelectDepth = this._selectDepth;
            String loopVar = "_xsl_loop" + this._unique++;
            this._selectLoopDepth = 0;
            String ptr = this.printSelectBegin(select, true, loopVar);
            if (isSingleString) {
                this.println(var + " = XmlUtil.textValue(" + ptr + ");");
            } else {
                this.println("XmlUtil.textValue(" + var + ", " + ptr + ");");
            }
            this.println("break " + loopVar + ";");
            while (this._selectDepth > oldSelectDepth) {
                this.popDepth();
                this.println("}");
                --this._selectDepth;
            }
            return;
        }
        if (isSingleString) {
            this.println(var + " = _exprs[" + this.addExpr(exprString) + "].evalString(node, " + this.getEnv() + ");");
        } else {
            this.println("_exprs[" + this.addExpr(exprString) + "].evalString(" + var + ", node, " + this.getEnv() + ");");
        }
    }

    private String printSelectBegin(AbstractPattern select, boolean isForEach, String loopVar) throws IOException, XslParseException {
        if (select == null) {
            throw new NullPointerException();
        }
        if (select instanceof FromContext && ((FromContext)select).getCount() == 0) {
            return "node";
        }
        if (select instanceof FromRoot) {
            return "ownerDocument(node)";
        }
        boolean useXPath = this.allowJavaSelect(select);
        String name = "node";
        if (!useXPath) {
            String iterName = "_xsl_iter" + this._unique++;
            String ptrName = "_xsl_ptr" + this._unique++;
            if (isForEach) {
                this.println("env.setCurrentNode(node);");
            }
            this.println("Iterator " + iterName + " = _select_patterns[" + this.addSelect(select) + "].select(" + name + ", env);");
            if (loopVar != null && this._selectLoopDepth == 0) {
                this.println(loopVar + ":");
            }
            this.println("while (" + iterName + ".hasNext()) {");
            this.pushDepth();
            ++this._selectDepth;
            ++this._selectLoopDepth;
            this.println("Node " + ptrName + " = (Node) " + iterName + ".next();");
            return ptrName;
        }
        if (select instanceof FromChildren) {
            name = this.printSelectBegin(select.getParent(), isForEach, loopVar);
            String ptrName = "_xsl_ptr" + this._unique++;
            if (loopVar != null && this._selectLoopDepth == 0) {
                this.println(loopVar + ":");
            }
            this.println("for (Node " + ptrName + " = " + name + ".getFirstChild();");
            this.println("     " + ptrName + " != null;");
            this.println("     " + ptrName + " = " + ptrName + ".getNextSibling()) {");
            this.pushDepth();
            ++this._selectDepth;
            ++this._selectLoopDepth;
            return ptrName;
        }
        if (select instanceof FromNextSibling) {
            name = this.printSelectBegin(select.getParent(), isForEach, loopVar);
            String ptrName = "_xsl_ptr" + this._unique++;
            if (loopVar != null && this._selectLoopDepth == 0) {
                this.println(loopVar + ":");
            }
            this.println("for (Node " + ptrName + " = " + name + ".getNextSibling();");
            this.println("     " + ptrName + " != null;");
            this.println("     " + ptrName + " = " + ptrName + ".getNextSibling()) {");
            this.pushDepth();
            ++this._selectDepth;
            ++this._selectLoopDepth;
            return ptrName;
        }
        if (select instanceof NodePattern) {
            name = this.printSelectBegin(select.getParent(), isForEach, loopVar);
            NodePattern pat = (NodePattern)select;
            this.println("if (" + name + ".getNodeName() == \"" + pat.getNodeName() + "\" &&");
            this.println("    " + name + " instanceof Element) {");
            this.pushDepth();
            ++this._selectDepth;
            return name;
        }
        if (select instanceof NodeTypePattern) {
            name = this.printSelectBegin(select.getParent(), isForEach, loopVar);
            NodeTypePattern pat = (NodeTypePattern)select;
            if (pat.getNodeType() >= 0) {
                this.println("if (" + name + ".getNodeType() == " + pat.getNodeType() + ") {");
                this.pushDepth();
                ++this._selectDepth;
            }
            return name;
        }
        if (select instanceof FilterPattern) {
            NumericExpr num;
            String posId = "_xsl_pos" + this._unique++;
            this.println("int " + posId + " = 0;");
            name = this.printSelectBegin(select.getParent(), isForEach, loopVar);
            this.println(posId + "++;");
            FilterPattern pat = (FilterPattern)select;
            Expr expr = pat.getExpr();
            if (expr instanceof NumericExpr && (num = (NumericExpr)expr).isConstant()) {
                this.println("if (" + posId + " > " + (int)num.getValue() + ")");
                this.println("  break;");
                this.println("else if (" + posId + " == " + (int)num.getValue() + ") {");
                this.pushDepth();
                ++this._selectDepth;
                return name;
            }
            throw new RuntimeException();
        }
        throw new RuntimeException(String.valueOf(select));
    }

    private boolean allowJavaSelect(AbstractPattern select) {
        if (select == null) {
            return false;
        }
        if (!select.isStrictlyAscending()) {
            return false;
        }
        if (select instanceof FromContext) {
            return ((FromContext)select).getCount() == 0;
        }
        if (select instanceof FromRoot) {
            return true;
        }
        if (select instanceof NodePattern) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof NodeTypePattern) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof FromChildren) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof FromNextSibling) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof FilterPattern) {
            if (!this.allowJavaSelect(select.getParent())) {
                return false;
            }
            Expr expr = ((FilterPattern)select).getExpr();
            return expr instanceof NumericExpr && ((NumericExpr)expr).isConstant();
        }
        return false;
    }

    private void stringExpr(String exprString, Element element) throws Exception, XslParseException {
        this.print("_exprs[" + this.addExpr(exprString) + "].evalString(node, " + this.getEnv() + ")");
    }

    public int addExpr(Expr expr) throws XslParseException {
        String exprStr = expr.toString();
        int i = this._exprMap.get(exprStr);
        if (i >= 0) {
            return i;
        }
        i = this._exprs.size();
        this._exprMap.put(exprStr, i);
        this._exprs.add(expr);
        return i;
    }

    public int addExpr(String exprString) throws XslParseException {
        int i = this._exprMap.get(exprString);
        if (i >= 0) {
            return i;
        }
        Expr expr = this.parseExpr(exprString);
        i = this._exprs.size();
        this._exprs.add(expr);
        this._exprMap.put(exprString, i);
        return i;
    }

    public int addSelect(AbstractPattern select) throws IOException, XslParseException {
        String selectStr = select.toString();
        int i = this._selectMap.get(selectStr);
        if (i >= 0) {
            return i;
        }
        i = this._selectPatterns.size();
        this._selectMap.put(selectStr, i);
        this._selectPatterns.add(select);
        return i;
    }

    public int addSelect(String selectString) throws IOException, XslParseException {
        int i = this._selectMap.get(selectString);
        if (i >= 0) {
            return i;
        }
        AbstractPattern select = this.parseSelect(selectString);
        i = this._selectPatterns.size();
        this._selectPatterns.add(select);
        this._selectMap.put(selectString, i);
        return i;
    }

    public int addMatch(AbstractPattern pattern) throws XslParseException {
        int index = this._matchPatterns.size();
        this._matchPatterns.add(pattern);
        return index;
    }

    @Override
    protected StylesheetImpl completeGenerate(ArrayList<XslNode> inits, ArrayList globals) throws Exception {
        this.printTemplates();
        this.printMacros();
        this.printInitVars(inits);
        this.printFragments();
        this.printInit();
        this.printStrings();
        this.printExpressions();
        this.printPatterns();
        this.popDepth();
        this.println("}");
        this._s.close();
        this._s = null;
        if (this._parentLoader instanceof DynamicClassLoader) {
            ((DynamicClassLoader)this._parentLoader).make();
        }
        this._compiler.compile(this._path.getPath(), this._lineMap);
        StylesheetImpl stylesheet = this._xslGenerator.loadStylesheet(this._path.getFullPath(), this._pkg + "." + this._className);
        return stylesheet;
    }

    private long getLastModified() {
        long lastModified = 0L;
        for (int i = 0; i < this._depends.size(); ++i) {
            Path path = (Path)this._depends.get(i);
            if (path.getLastModified() <= lastModified) continue;
            lastModified = path.getLastModified();
        }
        return lastModified;
    }

    protected void printInitVars(ArrayList<XslNode> inits) throws Exception {
        int i;
        this.println("private void _xsl_init_vars(XslWriter out, Node node, Env env)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        HashMap namespaces = this._qDoc.getNamespaces();
        if (namespaces != null) {
            for (String prefix : namespaces.keySet()) {
                String url = (String)namespaces.get(prefix);
                if (url.startsWith("http://www.w3.org/XSL/Transform/") || url.startsWith("http://www.w3.org/1999/XSL/Transform") || url.startsWith("http://www.w3.org/XML/2000/xmlns") || url.startsWith("http://www.w3.org/2000/xmlns") || url.equals("http://www.caucho.com/XTP/1.0") || this._excludedNamespaces.get(url) != null || this._namespaceAliases.get(url) != null) continue;
                if (prefix == null) {
                    this.println("out.addNamespace(\"\", \"" + url + "\");");
                    continue;
                }
                this.println("out.addNamespace(\"" + prefix + "\", \"" + url + "\");");
            }
        }
        this.println("Object _xsl_tmp;");
        for (i = 0; i < inits.size(); ++i) {
            XslNode node = inits.get(i);
            node.generate(this.getOut());
        }
        this.println("com.caucho.vfs.Path pwd;");
        this.println("pwd = (com.caucho.vfs.Path) out.getProperty(\"caucho.pwd\");");
        for (i = 0; i < this._cacheDepends.size(); ++i) {
            String depend = (String)this._cacheDepends.get(i);
            this.print("out.addCacheDepend(pwd.lookup(\"");
            this.printString(depend);
            this.println("\"));");
        }
        this.popDepth();
        this.println("}");
    }

    protected void printInit() throws Exception {
        int i;
        this.println("protected void _xsl_init(XslWriter out, Node node, Env env)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("Object _xsl_tmp;");
        this.println("_xsl_init_vars(out, node, env);");
        for (i = 0; this._globalActions != null && i < this._globalActions.size(); ++i) {
            QAbstractNode node = (QAbstractNode)this._globalActions.get(i);
            this.generateChild(node);
        }
        this.popDepth();
        this.println("}");
        this.println("public boolean isModified()");
        this.println("{");
        this.pushDepth();
        this.println("return com.caucho.server.util.CauchoSystem.getVersionId() != " + CauchoSystem.getVersionId() + "L ||");
        this.println("       super.isModified();");
        this.popDepth();
        this.println("}");
        this.println("public void init(com.caucho.vfs.Path path)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("super.init(path);");
        this.println("com.caucho.vfs.Path pwd = path.getParent();");
        for (i = 0; i < this._depends.size(); ++i) {
            Path path = (Path)this._depends.get(i);
            if (!path.canRead() || path.isDirectory()) continue;
            Depend depend = new Depend(path);
            this.print("addDepend(new com.caucho.vfs.Depend(pwd.lookup(\"");
            this.printString(path.getRelativePath());
            this.println("\"), " + depend.getDigest() + "L));");
        }
        this.println("stylesheets = new StylesheetEnv[" + this._stylesheets.size() + "];");
        this.println("StylesheetEnv env;");
        for (i = 0; i < this._stylesheets.size(); ++i) {
            String ss = this._stylesheets.get(i);
            this.println("env = new StylesheetEnv();");
            this.println("stylesheets[" + i + "] = env;");
            this.print("env.setPath(pwd.lookup(\"");
            this.printString(ss);
            this.println("\"));");
        }
        if (!this._strip.isEmpty()) {
            String prefix;
            this.println("HashMap preserve = new HashMap();");
            this.println("HashMap preservePrefix = new HashMap();");
            for (String key : this._preserve.keySet()) {
                if (key.endsWith(":*")) {
                    prefix = key.substring(0, key.length() - 2);
                    this.println("preservePrefix.put(\"" + prefix + "\", \"true\");");
                    continue;
                }
                this.println("preserve.put(\"" + key + "\", \"true\");");
            }
            this.println("HashMap strip = new HashMap();");
            this.println("HashMap stripPrefix = new HashMap();");
            for (String key : this._strip.keySet()) {
                if (key.endsWith(":*")) {
                    prefix = key.substring(0, key.length() - 2);
                    this.println("stripPrefix.put(\"" + prefix + "\", \"true\");");
                    continue;
                }
                this.println("strip.put(\"" + key + "\", \"true\");");
            }
            this.println("setSpaces(preserve, preservePrefix, strip, stripPrefix);");
        }
        this.printOutput();
        if (this._errorPage != null) {
            this.print("setProperty(\"caucho.error.page\", \"");
            this.printString(this._errorPage);
            this.println("\");");
        }
        if (this._globalParameters != null && this._globalParameters.size() > 0) {
            this.println("ArrayList params = new ArrayList();");
            for (int i2 = 0; i2 < this._globalParameters.size(); ++i2) {
                String param = (String)this._globalParameters.get(i2);
                this.println("params.add(\"" + param + "\");");
            }
            this.print("setProperty(\"caucho.global.param\", params);");
        }
        Object disable = null;
        if (this._isRawText) {
            this.println("_defaultDisableEscaping = true;");
        }
        this.printNamespaces();
        this.printFunctions();
        this.printSorts();
        this.printFormats();
        this.popDepth();
        this.println("}");
    }

    private void printOutput() throws Exception {
        Iterator iter = this._outputAttributes.keySet().iterator();
        if (this._outputAttributes.get("encoding") == null) {
            this.println("_output.put(\"encoding\", \"utf-8\");");
        }
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)this._outputAttributes.get(key);
            this.println("_output.put(\"" + key + "\", \"" + value + "\");");
        }
    }

    private void printSorts() throws Exception {
        if (this._sorts.size() == 0) {
            return;
        }
        this.println();
        this.println("_xsl_sorts = new com.caucho.xsl.Sort[][] { ");
        this.pushDepth();
        for (int i = 0; i < this._sorts.size(); ++i) {
            Sort[] sorts = this._sorts.get(i);
            this.print("new com.caucho.xsl.Sort[] {");
            for (int j = 0; j < sorts.length; ++j) {
                Sort sort = sorts[j];
                Expr lang = sort.getLang();
                Expr caseOrder = sort.getCaseOrder();
                if (lang != null || caseOrder != null) {
                    this.print("new com.caucho.xsl.Sort(\"" + sort.getExpr() + "\", " + "\"" + sort.getAscending() + "\", " + (lang == null ? "null, " : "\"" + lang + "\", ") + (caseOrder == null ? "null), " : "\"" + caseOrder + "\"), "));
                    continue;
                }
                this.print("new com.caucho.xsl.Sort(\"" + sort.getExpr() + "\", " + "\"" + sort.getAscending() + "\", " + sort.isText() + "), ");
            }
            this.println("},");
        }
        this.popDepth();
        this.println("};");
    }

    private void printLocale(Locale locale) throws Exception {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (variant != null && country != null) {
            this.print("new java.util.Locale(\"" + language + "\", " + "\"" + country + "\", \"" + variant + "\")");
        } else if (country != null) {
            this.print("new java.util.Locale(\"" + language + "\", " + "\"" + country + "\")");
        } else {
            this.print("new java.util.Locale(\"" + language + "\")");
        }
    }

    private void printFormats() throws Exception {
        if (this._formats.size() == 0) {
            return;
        }
        this.println();
        this.println("_xsl_formats = new XslNumberFormat[] { ");
        this.pushDepth();
        for (int i = 0; i < this._formats.size(); ++i) {
            XslNumberFormat format = this._formats.get(i);
            this.println("new XslNumberFormat(\"" + format.getFormat() + "\", \"" + format.getLang() + "\", " + format.isAlphabetic() + ", \"" + format.getGroupSeparator() + "\", " + format.getGroupSize() + "),");
        }
        this.popDepth();
        this.println("};");
    }

    private void printNamespaces() throws Exception {
        if (this._namespaces.size() == 0) {
            return;
        }
        this.println();
        this.println("_namespaces = new NamespaceContext[] { ");
        this.pushDepth();
        for (int i = 0; i < this._namespaces.size(); ++i) {
            NamespaceContext ns = this._namespaces.get(i);
            this.printNamespaceDef(ns);
            this.println(",");
        }
        this.popDepth();
        this.println("};");
    }

    private void printNamespaceDef(NamespaceContext ns) throws Exception {
        if (ns == null) {
            this.print("null");
            return;
        }
        this.print("new NamespaceContext(");
        this.printNamespaceDef(ns.getPrev());
        this.print(", \"" + ns.getPrefix() + "\", \"" + ns.getUrl() + "\")");
    }

    private void printFunctions() throws Exception {
        this.println();
        this.println("com.caucho.xsl.fun.KeyFun keyFun = new com.caucho.xsl.fun.KeyFun();");
        HashMap<String, KeyFun.Key> keys = this._keyFun.getKeys();
        for (String name : keys.keySet()) {
            KeyFun.Key key = keys.get(name);
            this.println("keyFun.add(\"" + name + "\", XPath.parseMatch(\"" + key.getMatch() + "\").getPattern(), XPath.parseExpr(\"" + key.getUse() + "\"));");
        }
        this.println("addFunction(\"key\", keyFun);");
        this.println();
        this.println("com.caucho.xsl.fun.FormatNumberFun formatFun = new com.caucho.xsl.fun.FormatNumberFun();");
        this.println("java.text.DecimalFormatSymbols symbols;");
        JavaWriter out = this._out;
        HashMap locales = this._formatNumberFun.getLocales();
        for (String name : locales.keySet()) {
            DecimalFormatSymbols symbols = (DecimalFormatSymbols)locales.get(name);
            out.println("symbols = new java.text.DecimalFormatSymbols();");
            out.print("symbols.setDecimalSeparator('");
            out.printJavaChar(symbols.getDecimalSeparator());
            out.println("');");
            out.print("symbols.setGroupingSeparator('");
            out.printJavaChar(symbols.getGroupingSeparator());
            out.println("');");
            out.print("symbols.setInfinity(\"");
            out.printJavaString(symbols.getInfinity());
            out.println("\");");
            out.print("symbols.setMinusSign('");
            out.printJavaChar(symbols.getMinusSign());
            out.println("');");
            out.print("symbols.setNaN(\"");
            out.printJavaString(symbols.getNaN());
            out.println("\");");
            out.print("symbols.setPercent('");
            out.printJavaChar(symbols.getPercent());
            out.println("');");
            out.print("symbols.setPerMill('");
            out.printJavaChar(symbols.getPerMill());
            out.println("');");
            out.print("symbols.setZeroDigit('");
            out.printJavaChar(symbols.getZeroDigit());
            out.println("');");
            out.print("symbols.setDigit('");
            out.printJavaChar(symbols.getDigit());
            out.println("');");
            out.print("symbols.setPatternSeparator('");
            out.printJavaChar(symbols.getPatternSeparator());
            out.println("');");
            this.println("formatFun.addLocale(\"" + name + "\", symbols);");
        }
        this.println("addFunction(\"format-number\", formatFun);");
    }

    private void printMacros() throws Exception {
    }

    private void printFragments() throws Exception {
        for (int i = 0; i < this._fragments.size(); ++i) {
            Element elt = (Element)this._fragments.get(i);
            this.println("Object _xsl_fragment" + i + "(XslWriter out, Node inputNode, Env env )");
            this.println("  throws Exception");
            this.println("{");
            this.pushDepth();
            this.println("Object _xsl_tmp;");
            this.println("Node node = inputNode;");
            this.println("XMLWriter _xsl_frag = out.pushFragment();");
            this.generateChildren(elt);
            this.println("return out.popFragment(_xsl_frag);");
            this.popDepth();
            this.println("}");
        }
    }

    private void printTemplates() throws Exception {
        for (int j = 0; j < this._modes.size(); ++j) {
            int i;
            String mode = this._modes.get(j);
            String modeName = this.getModeName(mode);
            this.printApplyNode(mode);
            this.println();
            this.println("static HashMap _static_templates" + modeName + ";");
            this.println();
            this.println("static {");
            this.pushDepth();
            this.println("_static_templates" + modeName + " = new HashMap();");
            this.println("Template []values;");
            this.println("try {");
            this.pushDepth();
            ArrayList defaultTemplateList = (ArrayList)this._templates.get("*");
            if (defaultTemplateList == null) {
                defaultTemplateList = new ArrayList();
            }
            this.println("Template []star = new Template[] {");
            this.pushDepth();
            for (int i2 = 0; i2 < defaultTemplateList.size(); ++i2) {
                Template template = (Template)defaultTemplateList.get(i2);
                if (!template.getMode().equals(mode)) continue;
                this.printTemplate(template);
                this.println(",");
            }
            this.popDepth();
            this.println("};");
            this.println();
            this.println("_static_templates" + modeName + ".put(\"*\", star);");
            int count = this._templates.size();
            for (i = 0; i < count; i += 64) {
                this.println("_init_templates" + modeName + "_" + i + "(star);");
            }
            this.popDepth();
            this.println("} catch (Exception e) {");
            this.println("  e.printStackTrace();");
            this.println("}");
            this.popDepth();
            this.println("}");
            for (i = 0; i < count; i += 64) {
                this.printTemplateInitFun(mode, i, 64, defaultTemplateList);
            }
        }
    }

    private void printApplyNode(String mode) throws Exception {
        String modeName = this.getModeName(mode);
        this.print("protected void applyNode" + modeName);
        this.println("(XslWriter out, Node node, Env env, int _xsl_min, int _xsl_max)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        this.println("Object _xsl_tmp;");
        this.println();
        this.println("switch (getTemplateId(_static_templates" + modeName + ", " + "node, env, _xsl_min, _xsl_max)) {");
        for (int i = 0; i < this._functions.size(); ++i) {
            Template template = this._templateList.get(i);
            if (template == null || !template.getMode().equals(mode)) continue;
            this.println("case " + (i + 1) + ":");
            this.println("  " + this._functions.get(i) + "(out, node, env);");
            this.println("  break;");
        }
        this.println("default:");
        this.println("  switch (node.getNodeType()) {");
        this.println("  case Node.ELEMENT_NODE:");
        this.println("  case Node.DOCUMENT_NODE:");
        this.println("  case Node.DOCUMENT_FRAGMENT_NODE:");
        this.println("    env.setSelect(node, null);");
        this.println("    for (Node child = node.getFirstChild();");
        this.println("         child != null;");
        this.println("         child = child.getNextSibling()) {");
        this.println("      env.setCurrentNode(child);");
        this.println("      applyNode" + modeName + "(out, child, env, 0, " + Integer.MAX_VALUE + ");");
        this.println("    }");
        this.println("    break;");
        this.println("  default:");
        this.println("    applyNodeDefault(out, node, env);");
        this.println("    break;");
        this.println("  }");
        this.println("  break;");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private void printTemplateInitFun(String mode, int offset, int length, ArrayList defaultTemplateList) throws Exception {
        String modeName = this.getModeName(mode);
        this.println("private static void _init_templates" + modeName + "_" + offset + "(Template []star)");
        this.println("  throws Exception");
        this.println("{");
        this.pushDepth();
        Iterator iter = this._templates.keySet().iterator();
        while (iter.hasNext() && length > 0) {
            ArrayList templateList;
            String name = (String)iter.next();
            if (name.equals("*") || this.modeTemplateCount(mode, templateList = (ArrayList)this._templates.get(name)) == 0) continue;
            if (offset > 0) {
                --offset;
                continue;
            }
            this.println("_static_templates" + modeName + ".put(\"" + name + "\", ");
            this.println("  mergeTemplates(star, new Template[] {");
            this.pushDepth();
            this.pushDepth();
            for (int i = 0; i < templateList.size(); ++i) {
                Template template = (Template)templateList.get(i);
                if (!template.getMode().equals(mode)) continue;
                this.printTemplate(template);
                this.println(",");
            }
            this.popDepth();
            this.popDepth();
            this.println("}));");
            --length;
        }
        this.popDepth();
        this.println("}");
    }

    private int modeTemplateCount(String mode, ArrayList templateList) {
        int count = 0;
        for (int i = 0; i < templateList.size(); ++i) {
            Template template = (Template)templateList.get(i);
            if (!template.getMode().equals(mode)) continue;
            ++count;
        }
        return count;
    }

    private void printTemplate(Template template) throws IOException {
        this.print("new Template(");
        AbstractPattern pattern = template.getPattern();
        this.print("XPath.parseMatch(\"" + template.getPattern().toPatternString() + "\").getPattern(), ");
        this.print("\"" + template.getMode() + "\", ");
        this.print(template.getMin() + ", ");
        this.print(template.getMax() + ", ");
        this.print(template.getPriority() + ", ");
        this.print(template.getCount() + ", ");
        this.print("\"" + template.getFunction() + "\", ");
        this.print("" + template.getId() + ")");
    }

    private void printStrings() throws Exception {
        for (int j = 0; j < this._strings.size(); ++j) {
            String text = this._strings.get(j);
            this.print("static char[] _xsl_string" + j + " = \"");
            this.printString(text);
            this.println("\".toCharArray();");
        }
    }

    private void printExpressions() throws Exception {
        if (this._exprs.size() == 0) {
            return;
        }
        this.println("private static Expr []_exprs;");
        this.println("static {");
        this.pushDepth();
        this.println("try {");
        this.pushDepth();
        this.println("_exprs = new Expr[] { ");
        this.pushDepth();
        for (int i = 0; i < this._exprs.size(); ++i) {
            Expr expr = this._exprs.get(i);
            this.println("XPath.parseExpr(\"" + expr + "\"),");
        }
        this.popDepth();
        this.println("};");
        this.popDepth();
        this.println("} catch (Exception e) {");
        this.println("  e.printStackTrace();");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private void printPatterns() throws Exception {
        AbstractPattern pattern;
        int i;
        if (this._selectPatterns.size() == 0 && this._matchPatterns.size() == 0) {
            return;
        }
        this.println("private static com.caucho.xpath.pattern.AbstractPattern []_select_patterns;");
        this.println("private static com.caucho.xpath.pattern.AbstractPattern []_match_patterns;");
        this.println("static {");
        this.pushDepth();
        this.println("try {");
        this.pushDepth();
        this.println("_select_patterns = new com.caucho.xpath.pattern.AbstractPattern[] { ");
        this.pushDepth();
        for (i = 0; i < this._selectPatterns.size(); ++i) {
            pattern = this._selectPatterns.get(i);
            this.println("XPath.parseSelect(\"" + pattern + "\").getPattern(),");
        }
        this.popDepth();
        this.println("};");
        this.println("_match_patterns = new com.caucho.xpath.pattern.AbstractPattern[] { ");
        this.pushDepth();
        for (i = 0; i < this._matchPatterns.size(); ++i) {
            pattern = this._matchPatterns.get(i);
            this.println("XPath.parseMatch(\"" + pattern + "\").getPattern(),");
        }
        this.popDepth();
        this.println("};");
        this.popDepth();
        this.println("} catch (Exception e) {");
        this.println("  e.printStackTrace();");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private boolean isSingleStylesheet() {
        return false;
    }

    private void print(char ch) throws IOException {
        this._out.print(ch);
    }

    private void print(String string) throws IOException {
        this._out.print(string);
    }

    private void print(int i) throws IOException {
        this._out.print(i);
    }

    private void println() throws IOException {
        this._out.println();
    }

    private void println(char ch) throws IOException {
        this._out.println(ch);
    }

    private void println(String s) throws IOException {
        this._out.println(s);
    }

    private void pushDepth() throws IOException {
        this._out.pushDepth();
    }

    private void popDepth() throws IOException {
        this._out.popDepth();
    }

    protected void printString(String str) throws IOException {
        this._out.printJavaString(str);
    }

    public String getModeName(String mode) {
        if (mode != null && !this._modes.contains(mode)) {
            this._modes.add(mode);
        }
        if (mode == null || mode.equals("")) {
            return "";
        }
        return "_" + this.toJavaIdentifier(mode);
    }

    public void addMode(String mode) {
        if (!this._modes.contains(mode)) {
            this._modes.add(mode);
        }
    }

    public int addStylesheet(String filename) {
        int pos = this._stylesheets.indexOf(filename);
        if (pos < 0) {
            pos = this._stylesheets.size();
            this._stylesheets.add(filename);
        }
        return pos;
    }

    public String toJavaIdentifier(String name) {
        CharBuffer cb = new CharBuffer();
        char ch = name.charAt(0);
        if (Character.isJavaIdentifierStart(ch)) {
            cb.append(ch);
        } else {
            cb.append("_");
        }
        for (int i = 1; i < name.length(); ++i) {
            ch = name.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                cb.append(ch);
                continue;
            }
            cb.append("_");
            cb.append((char)((ch & 0xF) + 97));
            cb.append((char)((ch / 16 & 0xF) + 97));
        }
        return cb.toString();
    }

    @Override
    public void close() throws IOException {
        if (this._s != null) {
            this._s.close();
        }
    }

    static {
        _tagMap.put(new QName("xsl", "attribute", "http://www.w3.org/1999/XSL/Transform"), XslAttribute.class);
        _tagMap.put(new QName("xsl", "attribute-set", "http://www.w3.org/1999/XSL/Transform"), XslAttributeSet.class);
        _tagMap.put(new QName("xsl", "apply-imports", "http://www.w3.org/1999/XSL/Transform"), XslApplyImports.class);
        _tagMap.put(new QName("xsl", "apply-templates", "http://www.w3.org/1999/XSL/Transform"), XslApplyTemplates.class);
        _tagMap.put(new QName("xsl", "call-template", "http://www.w3.org/1999/XSL/Transform"), XslCallTemplate.class);
        _tagMap.put(new QName("xsl", "choose", "http://www.w3.org/1999/XSL/Transform"), XslChoose.class);
        _tagMap.put(new QName("xsl", "comment", "http://www.w3.org/1999/XSL/Transform"), XslComment.class);
        _tagMap.put(new QName("xsl", "copy", "http://www.w3.org/1999/XSL/Transform"), XslCopy.class);
        _tagMap.put(new QName("xsl", "copy-of", "http://www.w3.org/1999/XSL/Transform"), XslCopyOf.class);
        _tagMap.put(new QName("xsl", "decimal-format", "http://www.w3.org/1999/XSL/Transform"), XslDecimalFormat.class);
        _tagMap.put(new QName("xsl", "element", "http://www.w3.org/1999/XSL/Transform"), XslElement.class);
        _tagMap.put(new QName("xsl", "for-each", "http://www.w3.org/1999/XSL/Transform"), XslForEach.class);
        _tagMap.put(new QName("xsl", "if", "http://www.w3.org/1999/XSL/Transform"), XslIf.class);
        _tagMap.put(new QName("xsl", "import", "http://www.w3.org/1999/XSL/Transform"), XslImport.class);
        _tagMap.put(new QName("xsl", "include", "http://www.w3.org/1999/XSL/Transform"), XslInclude.class);
        _tagMap.put(new QName("xsl", "key", "http://www.w3.org/1999/XSL/Transform"), XslKey.class);
        _tagMap.put(new QName("xsl", "message", "http://www.w3.org/1999/XSL/Transform"), XslMessage.class);
        _tagMap.put(new QName("xsl", "namespace-alias", "http://www.w3.org/1999/XSL/Transform"), XslNamespaceAlias.class);
        _tagMap.put(new QName("xsl", "number", "http://www.w3.org/1999/XSL/Transform"), XslNumber.class);
        _tagMap.put(new QName("xsl", "otherwise", "http://www.w3.org/1999/XSL/Transform"), XslOtherwise.class);
        _tagMap.put(new QName("xsl", "output", "http://www.w3.org/1999/XSL/Transform"), XslOutput.class);
        _tagMap.put(new QName("xsl", "param", "http://www.w3.org/1999/XSL/Transform"), XslParam.class);
        _tagMap.put(new QName("xsl", "processing-instruction", "http://www.w3.org/1999/XSL/Transform"), XslProcessingInstruction.class);
        _tagMap.put(new QName("xsl", "sort", "http://www.w3.org/1999/XSL/Transform"), XslSort.class);
        _tagMap.put(new QName("xsl", "stylesheet", "http://www.w3.org/1999/XSL/Transform"), XslStylesheet.class);
        _tagMap.put(new QName("xsl", "text", "http://www.w3.org/1999/XSL/Transform"), XslText.class);
        _tagMap.put(new QName("xsl", "transform", "http://www.w3.org/1999/XSL/Transform"), XslTransform.class);
        _tagMap.put(new QName("xsl", "value-of", "http://www.w3.org/1999/XSL/Transform"), XslValueOf.class);
        _tagMap.put(new QName("xsl", "variable", "http://www.w3.org/1999/XSL/Transform"), XslVariable.class);
        _tagMap.put(new QName("xsl", "when", "http://www.w3.org/1999/XSL/Transform"), XslWhen.class);
        _tagMap.put(new QName("xsl", "with-param", "http://www.w3.org/1999/XSL/Transform"), XslWithParam.class);
        _tagMap.put(new QName("xsl", "template", "http://www.w3.org/1999/XSL/Transform"), XslTemplate.class);
        _tagMap.put(new QName("xsl", "strip-space", "http://www.w3.org/1999/XSL/Transform"), XslStripSpace.class);
        _tagMap.put(new QName("xsl", "preserve-space", "http://www.w3.org/1999/XSL/Transform"), XslPreserveSpace.class);
        _tagMap.put(new QName("xsl", "result-document", "http://www.w3.org/1999/XSL/Transform"), XslResultDocument.class);
        _tagMap.put(new QName("xtp", "expression", "http://www.caucho.com/XTP/1.0"), XtpExpression.class);
        _tagMap.put(new QName("xtp:expression", null), XtpExpression.class);
        _tagMap.put(new QName("xtp", "eval", "http://www.caucho.com/XTP/1.0"), XtpExpression.class);
        _tagMap.put(new QName("xtp:eval", null), XtpExpression.class);
        _tagMap.put(new QName("xtp", "expr", "http://www.caucho.com/XTP/1.0"), XtpExpression.class);
        _tagMap.put(new QName("xtp:expr", null), XtpExpression.class);
        _tagMap.put(new QName("xtp", "scriptlet", "http://www.caucho.com/XTP/1.0"), XtpScriptlet.class);
        _tagMap.put(new QName("xtp:scriptlet", null), XtpScriptlet.class);
        _tagMap.put(new QName("xtp", "declaration", "http://www.caucho.com/XTP/1.0"), XtpDeclaration.class);
        _tagMap.put(new QName("xtp", "decl", "http://www.caucho.com/XTP/1.0"), XtpDeclaration.class);
        _tagMap.put(new QName("xtp:declaration", null), XtpDeclaration.class);
        _tagMap.put(new QName("xtp:decl", null), XtpDeclaration.class);
        _tagMap.put(new QName("xtp:directive.page", null), XtpDirectivePage.class);
        _tagMap.put(new QName("xtp", "directive.page", "http://www.caucho.com/XTP/1.0"), XtpDirectivePage.class);
        _tagMap.put(new QName("xtp:directive.cache", null), XtpDirectiveCache.class);
        _tagMap.put(new QName("xtp", "directive.cache", "http://www.caucho.com/XTP/1.0"), XtpDirectiveCache.class);
        _tagMap.put(new QName("xtp:assign", null), XslVariable.class);
        _tagMap.put(new QName("xtp", "assign", "http://www.caucho.com/XTP/1.0"), XslVariable.class);
    }

    static class Macro {
        String _name;
        Element _elt;

        Macro(String name, Element elt) {
            this._name = name;
            this._elt = elt;
        }

        public Element getElement() {
            return this._elt;
        }

        public String getName() {
            return this._name;
        }
    }
}

