/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.CompileException;
import com.caucho.util.L10N;
import com.caucho.util.LineCompileException;
import com.caucho.xml.QName;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.XPath;
import com.caucho.xpath.expr.NumericExpr;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FilterPattern;
import com.caucho.xpath.pattern.FromChildren;
import com.caucho.xpath.pattern.FromContext;
import com.caucho.xpath.pattern.FromNextSibling;
import com.caucho.xpath.pattern.FromRoot;
import com.caucho.xpath.pattern.NodePattern;
import com.caucho.xpath.pattern.NodeTypePattern;
import com.caucho.xsl.JavaGenerator;
import com.caucho.xsl.XslParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XslNode {
    static final L10N L = new L10N(XslNode.class);
    private static final Logger log = Logger.getLogger(XslNode.class.getName());
    protected String _systemId;
    protected String _filename;
    protected int _startLine;
    protected int _endLine;
    protected JavaGenerator _gen;
    protected QName _name;
    protected XslNode _parent;
    protected ArrayList<XslNode> _children;
    protected NamespaceContext _matchNamespace;
    protected NamespaceContext _outputNamespace;
    private int _varCount;

    protected XslNode() {
    }

    public void setGenerator(JavaGenerator gen) {
        this._gen = gen;
    }

    public QName getQName() {
        return this._name;
    }

    public void setQName(QName name) {
        this._name = name;
    }

    public String getTagName() {
        if (this._name != null) {
            return this._name.getName();
        }
        return this.getClass().getName();
    }

    public XslNode getParent() {
        return this._parent;
    }

    public void setParent(XslNode parent) {
        this._parent = parent;
        if (parent != null) {
            this._matchNamespace = parent.getMatchNamespace();
            this._outputNamespace = parent.getOutputNamespace();
        }
    }

    public void addVariableCount() {
        if (this._parent != null) {
            ++this._parent._varCount;
        }
    }

    public void setStartLocation(String systemId, String filename, int line) {
        this._systemId = systemId;
        this._filename = filename;
        this._startLine = line;
    }

    public void setEndLocation(String filename, int line) {
        if (this._filename != null && this._filename.equals(filename)) {
            this._endLine = line;
        }
    }

    public String getSystemId() {
        return this._systemId;
    }

    public String getFilename() {
        return this._filename;
    }

    public int getStartLine() {
        return this._startLine;
    }

    public int getEndLine() {
        return this._endLine;
    }

    public String getBaseURI() {
        return this._filename;
    }

    public NamespaceContext getMatchNamespace() {
        return this._matchNamespace;
    }

    public NamespaceContext getOutputNamespace() {
        return this._outputNamespace;
    }

    public String getNamespace(String prefix) {
        return NamespaceContext.find(this.getOutputNamespace(), prefix);
    }

    public void addAttribute(QName name, String value) throws XslParseException {
        if (name.getName().startsWith("xmlns")) {
            this.addNamespaceAttribute(name, value);
            return;
        }
        if (name.getName().startsWith("xml")) {
            return;
        }
        throw this.error(L.l("attribute `{0}' is not allowed in <{1}>.", (Object)name.getName(), this.getTagName()));
    }

    protected void addNamespaceAttribute(QName name, String url) throws XslParseException {
        String localName = name.getLocalName();
        this._outputNamespace = new NamespaceContext(this._outputNamespace, localName, url);
        if (!localName.equals("xmlns")) {
            this._matchNamespace = new NamespaceContext(this._matchNamespace, localName, url);
        }
    }

    public void endAttributes() throws XslParseException {
    }

    public void addText(String text) throws XslParseException {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (XmlChar.isWhitespace(ch)) continue;
            throw this.error(L.l("Text is not allowed in <{0}> at `{1}'.", (Object)this._name.getName(), text));
        }
    }

    public void addChild(XslNode node) throws XslParseException {
        if (node == null) {
            return;
        }
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(node);
    }

    public void endElement() throws Exception {
    }

    public ArrayList<XslNode> getChildren() {
        return this._children;
    }

    public boolean hasChildren() {
        return this._children != null && this._children.size() > 0;
    }

    public abstract void generate(JavaWriter var1) throws Exception;

    public void generateChildren(JavaWriter out) throws Exception {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            XslNode child = this._children.get(i);
            out.setLocation(child.getFilename(), child.getStartLine());
            child.generate(out);
        }
        this.popScope(out);
    }

    public void generateDeclaration(JavaWriter out) throws Exception {
        this.generateDeclarationChildren(out);
    }

    public void generateDeclarationChildren(JavaWriter out) throws Exception {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            XslNode child = this._children.get(i);
            child.generateDeclaration(out);
        }
    }

    protected void printAttributeValue(JavaWriter out, String name, String value) throws Exception {
        out.print("out.attribute(");
        out.print(name == null ? "null" : "\"" + name + "\"");
        out.print(", ");
        if (value == null) {
            out.print("null");
        } else {
            out.print("\"");
            out.printJavaString(value);
            out.print("\"");
        }
        out.println(");");
    }

    protected void printAttributeValue(JavaWriter out, String value) throws Exception {
        if (value == null) {
            out.print("null");
            return;
        }
        if (value.indexOf("{") < 0) {
            out.print("\"");
            out.printJavaString(value);
            out.print("\"");
        } else {
            this.generateString(out, value);
        }
    }

    void generateString(JavaWriter out, String string) throws Exception {
        boolean first = true;
        int length = string.length();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch == '\n') {
                cb.append("\\n");
                continue;
            }
            if (ch == '\"') {
                cb.append("\\\"");
                continue;
            }
            if (ch == '{' && i + 1 < length) {
                if (string.charAt(i + 1) == '{') {
                    cb.append('{');
                    ++i;
                    continue;
                }
                if (cb.length() > 0) {
                    out.print("out.print(\"");
                    out.printJavaString(cb.toString());
                    out.println("\");");
                }
                cb.clear();
                ++i;
                while (i < length && string.charAt(i) != '}') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                this.printStringExpr(out, cb.toString());
                cb.clear();
                first = false;
                continue;
            }
            if (ch == '}' && i + 1 < length) {
                if (string.charAt(i + 1) == '}') {
                    cb.append('}');
                    ++i;
                    continue;
                }
                cb.append('}');
                continue;
            }
            if (i + 2 < length && ch == '<' && string.charAt(i + 1) == '#' && string.charAt(i + 2) == '=') {
                if (cb.length() > 0) {
                    out.print("out.print(\"");
                    out.printJavaString(cb.toString());
                    out.println("\");");
                }
                cb.clear();
                i += 3;
                while (i + 1 < length && string.charAt(i) != '#' && string.charAt(i + 1) != '>') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                ++i;
                out.println("out.print(" + cb + ");");
                cb.clear();
                first = false;
                continue;
            }
            cb.append(ch);
        }
        if (cb.length() > 0) {
            out.println("out.print(\"" + cb + "\");");
        }
    }

    void generateString(JavaWriter out, String string, int mode) throws Exception {
        CharBuffer cb = new CharBuffer();
        boolean first = true;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch == '\n') {
                cb.append("\\n");
                continue;
            }
            if (ch == '\"') {
                cb.append("\\\"");
                continue;
            }
            if (ch == '{' && i + 1 < length) {
                if (string.charAt(i + 1) == '{') {
                    cb.append('{');
                    ++i;
                    continue;
                }
                if (mode == 44) {
                    if (cb.length() > 0) {
                        out.println("out.print(\"" + cb.toString() + "\");");
                    }
                } else {
                    if (!first) {
                        out.print((char)mode);
                    }
                    if (cb.length() > 0) {
                        out.print("\"");
                        out.print(cb.toString());
                        out.print("\"");
                        out.print((char)mode);
                    }
                }
                cb.clear();
                ++i;
                while (i < length && string.charAt(i) != '}') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                if (mode == 44) {
                    this.printStringExpr(out, cb.toString());
                } else {
                    this.stringExpr(out, cb.toString());
                }
                cb.clear();
                first = false;
                continue;
            }
            if (ch == '}' && i + 1 < length) {
                if (string.charAt(i + 1) == '}') {
                    cb.append('}');
                    ++i;
                    continue;
                }
                cb.append('}');
                continue;
            }
            if (i + 2 < length && ch == '<' && string.charAt(i + 1) == '#' && string.charAt(i + 2) == '=') {
                if (mode == 44) {
                    if (cb.length() > 0) {
                        out.println("out.print(\"" + cb.toString() + "\");");
                    }
                } else {
                    if (!first) {
                        out.print((char)mode);
                    }
                    if (cb.length() > 0) {
                        out.print("\"");
                        out.print(cb.toString());
                        out.print("\"");
                        out.print((char)mode);
                    }
                }
                cb.clear();
                i += 3;
                while (i + 1 < length && string.charAt(i) != '#' && string.charAt(i + 1) != '>') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                ++i;
                if (mode == 44) {
                    out.println("out.print(" + cb + ");");
                } else {
                    out.print("(" + cb + ")");
                }
                cb.clear();
                first = false;
                continue;
            }
            cb.append(ch);
        }
        if (cb.length() > 0) {
            if (mode == 44) {
                out.println("out.print(\"" + cb + "\");");
            } else {
                if (!first) {
                    out.print((char)mode);
                }
                out.print("\"" + cb + "\"");
            }
        } else if (first && mode == 43) {
            out.print("\"\"");
        }
    }

    protected void printStringExpr(JavaWriter out, String exprString) throws Exception {
        if (exprString == null) {
            return;
        }
        int length = exprString.length();
        if (length == 0) {
            return;
        }
        AbstractPattern select = null;
        try {
            select = this.parseSelect(exprString);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (exprString.equals(".")) {
            out.println("out.valueOf(node);");
            return;
        }
        if (exprString.charAt(0) == '@') {
            boolean isSimple = true;
            for (int i = 1; i < length; ++i) {
                char ch = exprString.charAt(i);
                if (XmlChar.isNameChar(ch) && ch != ':') continue;
                isSimple = false;
            }
            if (isSimple) {
                out.println("if (node instanceof Element)");
                out.print("  out.print(((Element) node).getAttribute(\"");
                out.print(exprString.substring(1));
                out.println("\"));");
                return;
            }
        } else if (this.allowJavaSelect(select)) {
            int oldSelectDepth = this._gen.getSelectDepth();
            String loop = "_xsl_loop" + this._gen.generateId();
            this._gen.setSelectLoopDepth(0);
            String ptr = this.printSelectBegin(out, select, true, loop);
            out.println("out.valueOf(" + ptr + ");");
            out.println("break " + loop + ";");
            for (int selectDepth = this._gen.getSelectDepth(); oldSelectDepth < selectDepth; --selectDepth) {
                out.popDepth();
                out.println("}");
            }
            this._gen.setSelectDepth(oldSelectDepth);
            return;
        }
        out.println("out.valueOf(_exprs[" + this.addExpr(exprString) + "].evalObject(node, " + this._gen.getEnv() + "));");
    }

    protected void stringExpr(JavaWriter out, String exprString) throws Exception, XslParseException {
        out.print("_exprs[" + this._gen.addExpr(this.parseExpr(exprString)) + "].evalString(node, " + this.getEnv() + ")");
    }

    protected void pushCall(JavaWriter out) throws IOException {
        out.println("{");
        out.pushDepth();
        int callDepth = this._gen.pushCallDepth();
        out.println("Env _xsl_arg" + callDepth + " = XPath.createCall(env);");
    }

    protected void popCall(JavaWriter out) throws IOException {
        int callDepth = this._gen.popCallDepth();
        out.println("_xsl_arg" + callDepth + ".free();");
        out.popDepth();
        out.println("}");
    }

    protected String printSelectBegin(JavaWriter out, AbstractPattern select, boolean isForEach, String loopVar) throws IOException, XslParseException {
        if (select == null) {
            throw new NullPointerException();
        }
        if (select instanceof FromContext && ((FromContext)select).getCount() == 0) {
            return "node";
        }
        if (select instanceof FromRoot) {
            return "ownerDocument(node)";
        }
        boolean useXPath = this.allowJavaSelect(select);
        String name = "node";
        if (!useXPath) {
            String iterName = "_xsl_iter" + this._gen.generateId();
            String ptrName = "_xsl_ptr" + this._gen.generateId();
            if (isForEach) {
                out.println("env.setCurrentNode(node);");
            }
            out.println("Iterator " + iterName + " = _select_patterns[" + this._gen.addSelect(select) + "].select(" + name + ", env);");
            if (loopVar != null && this._gen.getSelectLoopDepth() == 0) {
                out.println(loopVar + ":");
            }
            out.println("while (" + iterName + ".hasNext()) {");
            out.pushDepth();
            this._gen.pushSelectDepth();
            this._gen.pushSelectLoopDepth();
            out.println("Node " + ptrName + " = (Node) " + iterName + ".next();");
            return ptrName;
        }
        if (select instanceof FromChildren) {
            name = this.printSelectBegin(out, select.getParent(), isForEach, loopVar);
            String ptrName = "_xsl_ptr" + this._gen.generateId();
            if (loopVar != null && this._gen.getSelectLoopDepth() == 0) {
                out.println(loopVar + ":");
            }
            out.println("for (Node " + ptrName + " = " + name + ".getFirstChild();");
            out.println("     " + ptrName + " != null;");
            out.println("     " + ptrName + " = " + ptrName + ".getNextSibling()) {");
            out.pushDepth();
            this._gen.pushSelectDepth();
            this._gen.pushSelectLoopDepth();
            return ptrName;
        }
        if (select instanceof FromNextSibling) {
            name = this.printSelectBegin(out, select.getParent(), isForEach, loopVar);
            String ptrName = "_xsl_ptr" + this._gen.generateId();
            if (loopVar != null && this._gen.getSelectLoopDepth() == 0) {
                out.println(loopVar + ":");
            }
            out.println("for (Node " + ptrName + " = " + name + ".getNextSibling();");
            out.println("     " + ptrName + " != null;");
            out.println("     " + ptrName + " = " + ptrName + ".getNextSibling()) {");
            out.pushDepth();
            this._gen.pushSelectDepth();
            this._gen.pushSelectLoopDepth();
            return ptrName;
        }
        if (select instanceof NodePattern) {
            name = this.printSelectBegin(out, select.getParent(), isForEach, loopVar);
            NodePattern pat = (NodePattern)select;
            out.println("if (" + name + ".getNodeName().equals(\"" + pat.getNodeName() + "\") &&");
            out.println("    " + name + " instanceof Element) {");
            out.pushDepth();
            this._gen.pushSelectDepth();
            return name;
        }
        if (select instanceof NodeTypePattern) {
            name = this.printSelectBegin(out, select.getParent(), isForEach, loopVar);
            NodeTypePattern pat = (NodeTypePattern)select;
            if (pat.getNodeType() >= 0) {
                out.println("if (" + name + ".getNodeType() == " + pat.getNodeType() + ") {");
                out.pushDepth();
                this._gen.pushSelectDepth();
            }
            return name;
        }
        if (select instanceof FilterPattern) {
            NumericExpr num;
            String posId = "_xsl_pos" + this._gen.generateId();
            out.println("int " + posId + " = 0;");
            name = this.printSelectBegin(out, select.getParent(), isForEach, loopVar);
            out.println(posId + "++;");
            FilterPattern pat = (FilterPattern)select;
            Expr expr = pat.getExpr();
            if (expr instanceof NumericExpr && (num = (NumericExpr)expr).isConstant()) {
                out.println("if (" + posId + " > " + (int)num.getValue() + ")");
                out.println("  break;");
                out.println("else if (" + posId + " == " + (int)num.getValue() + ") {");
                out.pushDepth();
                this._gen.pushSelectDepth();
                return name;
            }
            throw new RuntimeException();
        }
        throw new RuntimeException(String.valueOf(select));
    }

    protected boolean allowJavaSelect(AbstractPattern select) {
        if (select == null) {
            return false;
        }
        if (!select.isStrictlyAscending()) {
            return false;
        }
        if (select instanceof FromContext) {
            return ((FromContext)select).getCount() == 0;
        }
        if (select instanceof FromRoot) {
            return true;
        }
        if (select instanceof NodePattern) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof NodeTypePattern) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof FromChildren) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof FromNextSibling) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof FilterPattern) {
            if (!this.allowJavaSelect(select.getParent())) {
                return false;
            }
            Expr expr = ((FilterPattern)select).getExpr();
            return expr instanceof NumericExpr && ((NumericExpr)expr).isConstant();
        }
        return false;
    }

    protected void printNamespace(JavaWriter out, NamespaceContext namespace) throws Exception {
        int index = this._gen.addNamespace(namespace);
        out.print("_namespaces[" + index + "]");
    }

    protected void printFragmentString(JavaWriter out, String id) throws Exception {
        String fragId = "_frag_" + this._gen.generateId();
        out.println("XMLWriter " + fragId + " = out.pushFragment();");
        this.generateChildren(out);
        out.println(id + " = com.caucho.xml.XmlUtil.textValue(out.popFragment(" + fragId + "));");
    }

    protected void printFragmentValue(JavaWriter out, String id) throws Exception {
        String fragId = "_frag_" + this._gen.generateId();
        out.println("XMLWriter " + fragId + " = out.pushFragment();");
        this.generateChildren(out);
        out.println(id + " = out.popFragment(" + fragId + ");");
    }

    protected void popScope(JavaWriter out) throws Exception {
        this.printPopScope(out);
    }

    protected void printPopScope(JavaWriter out) throws Exception {
        if (this._varCount > 0) {
            out.println("env.popVars(" + this._varCount + ");");
        }
    }

    protected void printExprTest(JavaWriter out, int id, String node) throws IOException {
        out.print("_exprs[" + id + "].evalBoolean(" + node + ", " + this.getEnv() + ")");
    }

    public AbstractPattern parseMatch(String pattern) throws XslParseException, IOException {
        try {
            return XPath.parseMatch(pattern, this.getMatchNamespace()).getPattern();
        }
        catch (Exception e) {
            throw this.error(L.l("{0} in pattern `{1}'", (Object)e.toString(), pattern));
        }
    }

    protected AbstractPattern parseSelect(String pattern) throws XslParseException {
        try {
            return XPath.parseSelect(pattern, this.getMatchNamespace()).getPattern();
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    protected int addExpr(String pattern) throws XslParseException {
        return this._gen.addExpr(this.parseExpr(pattern));
    }

    protected Expr parseExpr(String pattern) throws XslParseException {
        try {
            return XPath.parseExpr(pattern, this.getMatchNamespace(), this._gen.getNodeListContext());
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    protected int generateId() {
        return this._gen.generateId();
    }

    protected String getEnv() {
        return this._gen.getEnv();
    }

    public String escapeJavaString(String s) {
        if (s == null) {
            return "";
        }
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\\') {
                cb.append("\\\\");
                continue;
            }
            if (s.charAt(i) == '\"') {
                cb.append("\\\"");
                continue;
            }
            if (s.charAt(i) == '\n') {
                cb.append("\\n");
                continue;
            }
            if (s.charAt(i) == '\r') {
                cb.append("\\r");
                continue;
            }
            cb.append(s.charAt(i));
        }
        return cb.close();
    }

    protected XslParseException error(String msg) {
        String filename = this._filename;
        if (filename == null) {
            filename = this._systemId;
        }
        if (filename != null) {
            return new XslParseException(filename + ":" + this._startLine + ": " + msg);
        }
        return new XslParseException(msg);
    }

    protected XslParseException error(Throwable e) {
        String filename = this._filename;
        if (filename == null) {
            filename = this._systemId;
        }
        if (filename == null || e instanceof LineCompileException) {
            return new XslParseException(e);
        }
        if (e instanceof CompileException) {
            return new XslParseException(filename + ":" + this._startLine + ": " + e.getMessage(), e);
        }
        return new XslParseException(this._filename + ":" + this._startLine + ": " + String.valueOf(e), e);
    }

    public String toString() {
        if (this._name == null) {
            return "<" + this.getClass().getName() + ">";
        }
        return "<" + this._name.getName() + ">";
    }
}

