/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlBreak;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.ArrayUtils;

@JsxClass(domClasses={HtmlBreak.class})
public class HTMLBRElement
extends HTMLElement {
    private static final String[] VALID_CLEAR_VALUES = new String[]{"left", "right", "all", "none"};

    @JsxGetter
    public String getClear() {
        String clear = this.getDomNodeOrDie().getAttribute("clear");
        if (!ArrayUtils.contains(VALID_CLEAR_VALUES, clear) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_42)) {
            return "";
        }
        return clear;
    }

    @JsxSetter
    public void setClear(String clear) {
        if (!ArrayUtils.contains(VALID_CLEAR_VALUES, clear) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_43)) {
            throw Context.reportRuntimeError("Invalid clear property value: '" + clear + "'.");
        }
        this.getDomNodeOrDie().setAttribute("clear", clear);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }
}

