/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.opera.core.systems.common.collect.CaseInsensitiveStringSet;
import com.opera.core.systems.internal.OperaColors;
import com.opera.core.systems.internal.VersionUtil;
import com.opera.core.systems.model.Canvas;
import com.opera.core.systems.model.ColorResult;
import com.opera.core.systems.model.OperaColor;
import com.opera.core.systems.model.ScreenCaptureReply;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.exceptions.ScopeException;
import com.opera.core.systems.scope.exceptions.WindowNotFoundException;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.internal.OperaMouseKeys;
import com.opera.core.systems.scope.protos.ExecProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.Exec;
import com.opera.core.systems.scope.stp.services.messages.ExecMessage;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class ScopeExec
extends AbstractService
implements Exec {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final List<String> excludedActions = Lists.newArrayList("Select all", "Delete");
    private Set<String> actions = ImmutableSet.of();

    public ScopeExec(ScopeServices services) {
        super(services, "exec");
        if (VersionUtil.compare(this.getServiceVersion(), "2.0.1") == -1) {
            this.excludedActions.add("Close page");
        }
        services.setExec(this);
    }

    @Override
    public void init() {
        this.actions = this.initActionList();
    }

    private Set<String> initActionList() {
        UmsProtos.Response response = this.executeMessage(ExecMessage.GET_ACTION_LIST, null);
        ExecProtos.ActionInfoList.Builder builder = ExecProtos.ActionInfoList.newBuilder();
        ScopeExec.buildPayload(response, builder);
        ExecProtos.ActionInfoList infoList = builder.build();
        CaseInsensitiveStringSet actions = new CaseInsensitiveStringSet();
        for (ExecProtos.ActionInfoList.ActionInfo info : infoList.getActionInfoListList()) {
            actions.add(info.getName());
        }
        return actions;
    }

    @Override
    public void mouseAction(int x, int y, OperaMouseKeys ... keys) {
        this.mouseAction(x, y, 1, keys);
    }

    @Override
    public void mouseAction(int x, int y, int count, OperaMouseKeys ... keys) {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException(String.format("Element is located outside viewport (%s,%s)", x, y));
        }
        int keyValue = 0;
        for (OperaMouseKeys operaMouseKeys : keys) {
            keyValue |= operaMouseKeys.getValue().intValue();
        }
        ExecProtos.MouseAction.Builder actionBuilder = ExecProtos.MouseAction.newBuilder();
        actionBuilder.setWindowID(this.services.getWindowManager().getActiveWindowId());
        actionBuilder.setX(x);
        actionBuilder.setY(y);
        actionBuilder.setButtonAction(keyValue);
        if (VersionUtil.compare(this.getServiceVersion(), "2.2") >= 0) {
            actionBuilder.setRepeatCount(count);
            this.executeMessage(ExecMessage.SEND_MOUSE_ACTION, actionBuilder);
        } else {
            for (int i = 0; i < count; ++i) {
                this.executeMessage(ExecMessage.SEND_MOUSE_ACTION, actionBuilder.clone());
            }
            if (count > 1) {
                try {
                    Thread.sleep(OperaIntervals.MULTIPLE_CLICK_SLEEP.getMs());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Set<String> getActionList() {
        return this.actions;
    }

    @Override
    public void action(String using, String ... params) {
        this.action(using, this.services.getWindowManager().getActiveWindowId(), params);
    }

    @Override
    public void action(String using, int windowID, String ... params) {
        if (!this.actions.contains(using)) {
            throw new UnsupportedOperationException("The requested action is not supported: " + using);
        }
        ExecProtos.ActionList.Builder builder = ExecProtos.ActionList.newBuilder();
        ExecProtos.ActionList.Action.Builder actionBuilder = ExecProtos.ActionList.Action.newBuilder();
        actionBuilder.setName(using);
        if (params != null && params.length > 0) {
            actionBuilder.setValue(params[0]);
        }
        if (!this.excludedActions.contains(using)) {
            try {
                actionBuilder.setWindowID(windowID);
            }
            catch (WindowNotFoundException e) {
                this.logger.warning("Exception from setWindowID: " + e);
                e.printStackTrace();
            }
        }
        builder.addActionList(actionBuilder);
        if (this.executeMessage(ExecMessage.EXEC, builder) == null) {
            throw new ScopeException("Unexpected error while calling action: " + using);
        }
    }

    @Override
    public void action(String using, int data, String dataString, String dataStringParam) {
        if (!this.actions.contains(using)) {
            throw new UnsupportedOperationException("The requested action is not supported: " + using);
        }
        ExecProtos.ActionList.Builder builder = ExecProtos.ActionList.newBuilder();
        ExecProtos.ActionList.Action.Builder actionBuilder = ExecProtos.ActionList.Action.newBuilder();
        actionBuilder.setName(using);
        actionBuilder.setValue(dataString);
        actionBuilder.setData(data);
        actionBuilder.setStringParam(dataStringParam);
        builder.addActionList(actionBuilder);
        if (this.executeMessage(ExecMessage.EXEC, builder) == null) {
            throw new ScopeException("Unexpected error while calling action: " + using);
        }
    }

    @Override
    public void key(String key) {
        this.key(key, false);
        this.key(key, true);
    }

    @Override
    public void key(String key, boolean up) {
        if (key == null) {
            return;
        }
        if (up) {
            this.action("_keyup", key);
        } else {
            this.action("_keydown", key);
        }
    }

    @Override
    public ScreenCaptureReply containsColor(Canvas canvas, long timeout, OperaColors ... colors) {
        ExecProtos.ScreenWatcher.Builder builder = ExecProtos.ScreenWatcher.newBuilder();
        ExecProtos.Area.Builder areaBuilder = ExecProtos.Area.newBuilder();
        areaBuilder.setX(canvas.getX());
        areaBuilder.setY(canvas.getY());
        areaBuilder.setH(canvas.getHeight());
        areaBuilder.setW(canvas.getWidth());
        builder.setArea(areaBuilder);
        int i = 0;
        for (OperaColors color : colors) {
            ExecProtos.ScreenWatcher.ColorSpec.Builder colorSpec = this.convertColor(color.getColour());
            colorSpec.setId(++i);
            builder.addColorSpecList(colorSpec);
        }
        ExecProtos.ScreenWatcherResult result = this.executeScreenWatcher(builder, timeout);
        ImmutableList.Builder matches = ImmutableList.builder();
        for (ExecProtos.ScreenWatcherResult.ColorMatch match : result.getColorMatchListList()) {
            matches.add(new ColorResult(match.getId(), match.getCount()));
        }
        return new ScreenCaptureReply(result.getMd5(), (List<ColorResult>)((Object)matches.build()));
    }

    private ExecProtos.ScreenWatcherResult executeScreenWatcher(ExecProtos.ScreenWatcher.Builder builder, long timeout) {
        if (timeout <= 0L) {
            timeout = 1L;
        }
        builder.setTimeOut((int)timeout);
        builder.setWindowID(this.services.getWindowManager().getActiveWindowId());
        UmsProtos.Response response = this.executeMessage(ExecMessage.SETUP_SCREEN_WATCHER, builder, OperaIntervals.RESPONSE_TIMEOUT.getMs() + timeout);
        ExecProtos.ScreenWatcherResult.Builder watcherBuilder = ExecProtos.ScreenWatcherResult.newBuilder();
        ScopeExec.buildPayload(response, watcherBuilder);
        return watcherBuilder.build();
    }

    private ExecProtos.ScreenWatcher.ColorSpec.Builder convertColor(OperaColor color) {
        ExecProtos.ScreenWatcher.ColorSpec.Builder builder = ExecProtos.ScreenWatcher.ColorSpec.newBuilder();
        builder.setBlueHigh(color.getHighBlue());
        builder.setGreenHigh(color.getHighGreen());
        builder.setRedHigh(color.getHighRed());
        builder.setBlueLow(color.getLowBlue());
        builder.setGreenLow(color.getLowGreen());
        builder.setRedLow(color.getLowRed());
        return builder;
    }

    @Override
    public ScreenCaptureReply screenWatcher(Canvas canvas, long timeout, boolean includeImage, List<String> hashes) {
        ExecProtos.ScreenWatcher.Builder builder = ExecProtos.ScreenWatcher.newBuilder();
        ExecProtos.Area.Builder areaBuilder = ExecProtos.Area.newBuilder();
        areaBuilder.setX(canvas.getX());
        areaBuilder.setY(canvas.getY());
        areaBuilder.setH(canvas.getHeight());
        areaBuilder.setW(canvas.getWidth());
        builder.setArea(areaBuilder);
        builder.addAllMd5List(hashes);
        if (!includeImage) {
            builder.setIncludeImage(false);
        }
        ExecProtos.ScreenWatcherResult result = this.executeScreenWatcher(builder, (int)timeout);
        return new ScreenCaptureReply(result.getMd5(), result.getPng().toByteArray());
    }
}

