/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.google.common.base.Preconditions;
import com.thoughtworks.selenium.SeleniumException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class AlertOverride {
    private final boolean enableOverrides;

    public AlertOverride(boolean enableOverrides) {
        this.enableOverrides = enableOverrides;
    }

    public void replaceAlertMethod(WebDriver driver) {
        if (!this.enableOverrides) {
            return;
        }
        ((JavascriptExecutor)((Object)driver)).executeScript("if (window.__webdriverAlerts) { return; } window.__webdriverAlerts = []; window.alert = function(msg) { window.__webdriverAlerts.push(msg); }; window.__webdriverConfirms = []; window.__webdriverNextConfirm = true; window.confirm = function(msg) {   window.__webdriverConfirms.push(msg);   var res = window.__webdriverNextConfirm;   window.__webdriverNextConfirm = true;   return res; };", new Object[0]);
    }

    private void checkOverridesEnabled() {
        Preconditions.checkState(this.enableOverrides, "Selenium alert overrides have been disabled; please use the underlying WebDriver API");
    }

    public String getNextAlert(WebDriver driver) {
        this.checkOverridesEnabled();
        String result = (String)((JavascriptExecutor)((Object)driver)).executeScript("if (!window.__webdriverAlerts) { return null }; var t = window.__webdriverAlerts.shift();if (t) { t = t.replace(/\\n/g, ' '); } return t;", new Object[0]);
        if (result == null) {
            throw new SeleniumException("There were no alerts");
        }
        return result;
    }

    public boolean isAlertPresent(WebDriver driver) {
        this.checkOverridesEnabled();
        return Boolean.TRUE.equals(((JavascriptExecutor)((Object)driver)).executeScript("return window.__webdriverAlerts && window.__webdriverAlerts.length > 0;", new Object[0]));
    }

    public String getNextConfirmation(WebDriver driver) {
        this.checkOverridesEnabled();
        String result = (String)((JavascriptExecutor)((Object)driver)).executeScript("if (!window.__webdriverConfirms) { return null; } return window.__webdriverConfirms.shift();", new Object[0]);
        if (result == null) {
            throw new SeleniumException("There were no confirmations");
        }
        return result;
    }

    public boolean isConfirmationPresent(WebDriver driver) {
        this.checkOverridesEnabled();
        return Boolean.TRUE.equals(((JavascriptExecutor)((Object)driver)).executeScript("return window.__webdriverConfirms && window.__webdriverConfirms.length > 0;", new Object[0]));
    }
}

