/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.logging.LoggingHandler;
import org.openqa.selenium.remote.SessionNotFoundException;
import org.openqa.selenium.remote.server.DefaultDriverSessions;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JeeServletHttpRequest;
import org.openqa.selenium.remote.server.JeeServletHttpResponse;
import org.openqa.selenium.remote.server.JsonHttpRemoteConfig;
import org.openqa.selenium.remote.server.SessionCleaner;
import org.openqa.selenium.remote.server.rest.RestishHandler;
import org.openqa.selenium.remote.server.rest.ResultConfig;
import org.openqa.selenium.remote.server.xdrpc.CrossDomainRpc;
import org.openqa.selenium.remote.server.xdrpc.CrossDomainRpcLoader;
import org.openqa.selenium.remote.server.xdrpc.HttpServletRequestProxy;

public class DriverServlet
extends HttpServlet {
    public static final String SESSIONS_KEY = String.valueOf(DriverServlet.class.getName()) + ".sessions";
    private static final String CROSS_DOMAIN_RPC_PATH = "/xdrpc";
    private final Supplier<DriverSessions> sessionsSupplier;
    private SessionCleaner sessionCleaner;
    private JsonHttpRemoteConfig mappings;

    public DriverServlet() {
        this.sessionsSupplier = new DriverSessionsSupplier();
    }

    @VisibleForTesting
    DriverServlet(Supplier<DriverSessions> sessionsSupplier) {
        this.sessionsSupplier = sessionsSupplier;
    }

    public void init() throws ServletException {
        super.init();
        Logger logger = this.getLogger();
        logger.addHandler(LoggingHandler.getInstance());
        DriverSessions driverSessions = this.sessionsSupplier.get();
        this.mappings = new JsonHttpRemoteConfig(driverSessions, logger);
        long sessionTimeOutInMs = this.getValueToUseInMs("webdriver.server.session.timeout", 1800L);
        long browserTimeoutInMs = this.getValueToUseInMs("webdriver.server.browser.timeout", 0L);
        if (sessionTimeOutInMs > 0L || browserTimeoutInMs > 0L) {
            this.createSessionCleaner(logger, driverSessions, sessionTimeOutInMs, browserTimeoutInMs);
        }
    }

    @VisibleForTesting
    protected void createSessionCleaner(Logger logger, DriverSessions driverSessions, long sessionTimeOutInMs, long browserTimeoutInMs) {
        this.sessionCleaner = new SessionCleaner(driverSessions, logger, sessionTimeOutInMs, browserTimeoutInMs);
        this.sessionCleaner.start();
    }

    private long getValueToUseInMs(String propertyName, long defaultValue) {
        long time = defaultValue;
        String property = this.getServletContext().getInitParameter(propertyName);
        if (property != null) {
            time = Long.parseLong(property);
        }
        return TimeUnit.SECONDS.toMillis(time);
    }

    public void destroy() {
        this.getLogger().removeHandler(LoggingHandler.getInstance());
        if (this.sessionCleaner != null) {
            this.sessionCleaner.stopCleaner();
        }
    }

    protected Logger getLogger() {
        return Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    @Deprecated
    protected ResultConfig addNewGetMapping(String path, Class<? extends RestishHandler> implementationClass) {
        return this.mappings.addNewGetMapping(path, implementationClass);
    }

    @Deprecated
    protected ResultConfig addNewPostMapping(String path, Class<? extends RestishHandler> implementationClass) {
        return this.mappings.addNewPostMapping(path, implementationClass);
    }

    @Deprecated
    protected ResultConfig addNewDeleteMapping(String path, Class<? extends RestishHandler> implementationClass) {
        return this.mappings.addNewDeleteMapping(path, implementationClass);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getHeader("Origin") != null) {
            this.setAccessControlHeaders(response);
        }
        response.setHeader("Expires", "Thu, 01 Jan 1970 00:00:00 GMT");
        response.setHeader("Cache-Control", "no-cache");
        super.service(request, response);
    }

    private void setAccessControlHeaders(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "DELETE,GET,HEAD,POST");
        response.setHeader("Access-Control-Allow-Headers", "Accept,Content-Type");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (CROSS_DOMAIN_RPC_PATH.equalsIgnoreCase(request.getPathInfo())) {
            this.handleCrossDomainRpc(request, response);
        } else {
            this.handleRequest(request, response);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    private void handleCrossDomainRpc(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        CrossDomainRpc rpc;
        try {
            rpc = new CrossDomainRpcLoader().loadRpc(request);
        }
        catch (IllegalArgumentException e) {
            response.setStatus(400);
            response.getOutputStream().println(e.getMessage());
            response.getOutputStream().flush();
            return;
        }
        request = HttpServletRequestProxy.createProxy(request, rpc, CROSS_DOMAIN_RPC_PATH, "application/xdrpc");
        this.handleRequest(request, response);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            JeeServletHttpRequest req = new JeeServletHttpRequest(request);
            JeeServletHttpResponse res = new JeeServletHttpResponse(response);
            this.mappings.handleRequest(req, res);
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            response.setStatus(404);
        }
        catch (Exception e) {
            this.log("Fatal, unhandled exception: " + request.getPathInfo() + ": " + e);
            throw new ServletException((Throwable)e);
        }
    }

    private class DriverSessionsSupplier
    implements Supplier<DriverSessions> {
        private DriverSessionsSupplier() {
        }

        @Override
        public DriverSessions get() {
            Object attribute = DriverServlet.this.getServletContext().getAttribute(SESSIONS_KEY);
            if (attribute == null) {
                attribute = new DefaultDriverSessions();
            }
            return (DriverSessions)attribute;
        }
    }
}

