/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Reader;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.HttpRequest;
import org.openqa.selenium.remote.server.HttpResponse;
import org.openqa.selenium.remote.server.JeeServletHttpResponse;

public class JeeServletHttpRequest
implements HttpRequest {
    private final HttpServletRequest request;

    public JeeServletHttpRequest(HttpServletRequest request) {
        this.request = Preconditions.checkNotNull(request);
    }

    @Override
    public String getAppUri() {
        return String.valueOf(this.request.getContextPath()) + this.request.getServletPath();
    }

    @Override
    public String getUri() {
        return this.request.getRequestURI();
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getHeader(String header) {
        return this.request.getHeader(header);
    }

    @Override
    public String getPath() {
        return this.request.getPathInfo();
    }

    @Override
    public Reader getReader() {
        try {
            return this.request.getReader();
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    @Override
    public void forward(HttpResponse response, String to) {
        Preconditions.checkArgument(response instanceof JeeServletHttpResponse);
        RequestDispatcher dispatcher = this.request.getRequestDispatcher(to);
        try {
            dispatcher.forward((ServletRequest)this.request, (ServletResponse)((JeeServletHttpResponse)response).getServletResponse());
        }
        catch (ServletException e) {
            throw new WebDriverException(e);
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    @Override
    public Object getAttribute(String attributeName) {
        return this.request.getAttribute(attributeName);
    }

    @Override
    public void setAttribute(String attributeName, Object value) {
        this.request.setAttribute(attributeName, value);
    }
}

