/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriverCommandExecutor;
import org.openqa.selenium.safari.SafariDriverExtension;

public class SafariDriver
extends RemoteWebDriver
implements TakesScreenshot {
    public static final String CLEAN_SESSION_CAPABILITY = "safari.cleanSession";
    public static final String DATA_DIR_CAPABILITY = "safari.dataDir";
    public static final String NO_INSTALL_EXTENSION_CAPABILITY = "safari.extension.noInstall";

    public SafariDriver() {
        this(DesiredCapabilities.safari());
    }

    public SafariDriver(Capabilities desiredCapabilities) {
        super(new SafariDriverCommandExecutor(0, desiredCapabilities.is(CLEAN_SESSION_CAPABILITY), new SafariDriverExtension(SafariDriver.dataDir(desiredCapabilities), SafariDriver.installExtension(desiredCapabilities))), desiredCapabilities);
    }

    private static boolean installExtension(Capabilities capabilities) {
        return !capabilities.is(NO_INSTALL_EXTENSION_CAPABILITY);
    }

    private static Optional<File> dataDir(Capabilities capabilities) {
        Object cap = capabilities.getCapability(DATA_DIR_CAPABILITY);
        File dir = null;
        if (cap instanceof String) {
            dir = new File((String)cap);
        } else if (cap instanceof File) {
            dir = (File)cap;
        }
        return Optional.fromNullable(dir);
    }

    @Override
    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    @Override
    protected void startClient() {
        SafariDriverCommandExecutor executor = (SafariDriverCommandExecutor)this.getCommandExecutor();
        try {
            executor.start();
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    @Override
    protected void stopClient() {
        SafariDriverCommandExecutor executor = (SafariDriverCommandExecutor)this.getCommandExecutor();
        executor.stop();
    }

    @Override
    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        String base64 = (String)this.execute("screenshot").getValue();
        return target.convertFromBase64Png(base64);
    }
}

