/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class ExpectedConditions {
    private static final Logger log = Logger.getLogger(ExpectedConditions.class.getName());

    private ExpectedConditions() {
    }

    public static ExpectedCondition<Boolean> titleIs(final String title) {
        return new ExpectedCondition<Boolean>(){
            private String currentTitle = "";

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentTitle = driver.getTitle();
                return title.equals(this.currentTitle);
            }

            public String toString() {
                return String.format("title to be \"%s\". Current title: \"%s\"", title, this.currentTitle);
            }
        };
    }

    public static ExpectedCondition<Boolean> titleContains(final String title) {
        return new ExpectedCondition<Boolean>(){
            private String currentTitle = "";

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentTitle = driver.getTitle();
                if (this.currentTitle != null && this.currentTitle.contains(title)) {
                    return true;
                }
                return false;
            }

            public String toString() {
                return String.format("title to contain \"%s\". Current title: \"%s\"", title, this.currentTitle);
            }
        };
    }

    public static ExpectedCondition<WebElement> presenceOfElementLocated(final By locator) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public WebElement apply(WebDriver driver) {
                return ExpectedConditions.findElement(locator, driver);
            }

            public String toString() {
                return "presence of element located by: " + locator;
            }
        };
    }

    public static ExpectedCondition<WebElement> visibilityOfElementLocated(final By locator) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public WebElement apply(WebDriver driver) {
                try {
                    return ExpectedConditions.elementIfVisible(ExpectedConditions.findElement(locator, driver));
                }
                catch (StaleElementReferenceException staleElementReferenceException) {
                    return null;
                }
            }

            public String toString() {
                return "visibility of element located by " + locator;
            }
        };
    }

    public static ExpectedCondition<WebElement> visibilityOf(final WebElement element) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public WebElement apply(WebDriver driver) {
                return ExpectedConditions.elementIfVisible(element);
            }

            public String toString() {
                return "visibility of " + element;
            }
        };
    }

    private static WebElement elementIfVisible(WebElement element) {
        return element.isDisplayed() ? element : null;
    }

    public static ExpectedCondition<List<WebElement>> presenceOfAllElementsLocatedBy(final By locator) {
        return new ExpectedCondition<List<WebElement>>(){

            @Override
            public List<WebElement> apply(WebDriver driver) {
                List elements = ExpectedConditions.findElements(locator, driver);
                return elements.size() > 0 ? elements : null;
            }

            public String toString() {
                return "presence of any elements located by " + locator;
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElement(final By locator, final String text) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    String elementText = ExpectedConditions.findElement(locator, driver).getText();
                    return elementText.contains(text);
                }
                catch (StaleElementReferenceException staleElementReferenceException) {
                    return null;
                }
            }

            public String toString() {
                return String.format("text ('%s') to be present in element found by %s", text, locator);
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElementValue(final By locator, final String text) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    String elementText = ExpectedConditions.findElement(locator, driver).getAttribute("value");
                    if (elementText != null) {
                        return elementText.contains(text);
                    }
                    return false;
                }
                catch (StaleElementReferenceException staleElementReferenceException) {
                    return null;
                }
            }

            public String toString() {
                return String.format("text ('%s') to be the value of element located by %s", text, locator);
            }
        };
    }

    public static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt(final String frameLocator) {
        return new ExpectedCondition<WebDriver>(){

            @Override
            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().frame(frameLocator);
                }
                catch (NoSuchFrameException noSuchFrameException) {
                    return null;
                }
            }

            public String toString() {
                return "frame to be available: " + frameLocator;
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOfElementLocated(final By locator) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    return !ExpectedConditions.findElement(locator, driver).isDisplayed();
                }
                catch (NoSuchElementException noSuchElementException) {
                    return true;
                }
                catch (StaleElementReferenceException staleElementReferenceException) {
                    return true;
                }
            }

            public String toString() {
                return "element to no longer be visible: " + locator;
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOfElementWithText(final By locator, final String text) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    return !ExpectedConditions.findElement(locator, driver).getText().equals(text);
                }
                catch (NoSuchElementException noSuchElementException) {
                    return true;
                }
                catch (StaleElementReferenceException staleElementReferenceException) {
                    return true;
                }
            }

            public String toString() {
                return String.format("element containing '%s' to no longer be visible: %s", text, locator);
            }
        };
    }

    public static ExpectedCondition<WebElement> elementToBeClickable(final By locator) {
        return new ExpectedCondition<WebElement>(){
            public ExpectedCondition<WebElement> visibilityOfElementLocated;
            {
                this.visibilityOfElementLocated = ExpectedConditions.visibilityOfElementLocated(by);
            }

            @Override
            public WebElement apply(WebDriver driver) {
                WebElement element = (WebElement)this.visibilityOfElementLocated.apply(driver);
                try {
                    if (element != null && element.isEnabled()) {
                        return element;
                    }
                    return null;
                }
                catch (StaleElementReferenceException staleElementReferenceException) {
                    return null;
                }
            }

            public String toString() {
                return "element to be clickable: " + locator;
            }
        };
    }

    public static ExpectedCondition<Boolean> stalenessOf(final WebElement element) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver ignored) {
                try {
                    element.isEnabled();
                    return false;
                }
                catch (StaleElementReferenceException staleElementReferenceException) {
                    return true;
                }
            }

            public String toString() {
                return String.format("element (%s) to become stale", element);
            }
        };
    }

    public static <T> ExpectedCondition<T> refreshed(final ExpectedCondition<T> condition) {
        return new ExpectedCondition<T>(){

            @Override
            public T apply(WebDriver driver) {
                try {
                    return condition.apply(driver);
                }
                catch (StaleElementReferenceException staleElementReferenceException) {
                    return null;
                }
            }

            public String toString() {
                return String.format("condition (%s) to be refreshed", condition);
            }
        };
    }

    public static ExpectedCondition<Boolean> elementToBeSelected(WebElement element) {
        return ExpectedConditions.elementSelectionStateToBe(element, true);
    }

    public static ExpectedCondition<Boolean> elementSelectionStateToBe(final WebElement element, final boolean selected) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                if (element.isSelected() == selected) {
                    return true;
                }
                return false;
            }

            public String toString() {
                return String.format("element (%s) to %sbe selected", element, selected ? "" : "not ");
            }
        };
    }

    public static ExpectedCondition<Boolean> elementToBeSelected(By locator) {
        return ExpectedConditions.elementSelectionStateToBe(locator, true);
    }

    public static ExpectedCondition<Boolean> elementSelectionStateToBe(final By locator, final boolean selected) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    WebElement element = driver.findElement(locator);
                    if (element.isSelected() == selected) {
                        return true;
                    }
                    return false;
                }
                catch (StaleElementReferenceException staleElementReferenceException) {
                    return null;
                }
            }

            public String toString() {
                return String.format("element found by %s to %sbe selected", locator, selected ? "" : "not ");
            }
        };
    }

    public static ExpectedCondition<Alert> alertIsPresent() {
        return new ExpectedCondition<Alert>(){

            @Override
            public Alert apply(WebDriver driver) {
                try {
                    return driver.switchTo().alert();
                }
                catch (NoAlertPresentException noAlertPresentException) {
                    return null;
                }
            }

            public String toString() {
                return "alert to be present";
            }
        };
    }

    public static ExpectedCondition<Boolean> not(final ExpectedCondition<?> condition) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                Object result = condition.apply(driver);
                if (result != null && result != Boolean.FALSE) {
                    return false;
                }
                return true;
            }

            public String toString() {
                return "condition to not be valid: " + condition;
            }
        };
    }

    private static WebElement findElement(By by, WebDriver driver) {
        try {
            return driver.findElement(by);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (WebDriverException e) {
            log.log(Level.WARNING, String.format("WebDriverException thrown by findElement(%s)", by), e);
            throw e;
        }
    }

    private static List<WebElement> findElements(By by, WebDriver driver) {
        try {
            return driver.findElements(by);
        }
        catch (WebDriverException e) {
            log.log(Level.WARNING, String.format("WebDriverException thrown by findElement(%s)", by), e);
            throw e;
        }
    }
}

