/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptEngineManager {
    private static final Logger log = Logger.getLogger(ScriptEngineManager.class.getName());
    private ArrayList _engineFactories = new ArrayList();
    protected HashSet engineSpis = new HashSet();
    protected HashMap extensionAssociations = new HashMap();
    protected Bindings globalScope = new SimpleBindings();
    protected HashMap mimeTypeAssociations = new HashMap();
    protected HashMap nameAssociations = new HashMap();

    public ScriptEngineManager() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ScriptEngineManager(ClassLoader loader) {
        this.initEngines(loader);
    }

    public void setBindings(Bindings globalScope) {
        this.globalScope = globalScope;
    }

    public Bindings getBindings() {
        return this.globalScope;
    }

    public void put(String key, Object value) {
        this.getBindings().put(key, value);
    }

    public Object get(String key) {
        return this.getBindings().get(key);
    }

    public ScriptEngine getEngineByName(String shortName) {
        Class fClass = (Class)this.nameAssociations.get(shortName);
        if (fClass != null) {
            return this.getEngineByClass(fClass);
        }
        return null;
    }

    public ScriptEngine getEngineByExtension(String ext) {
        Class fClass = (Class)this.extensionAssociations.get(ext);
        if (fClass != null) {
            return this.getEngineByClass(fClass);
        }
        return null;
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        Class fClass = (Class)this.mimeTypeAssociations.get(mimeType);
        if (fClass != null) {
            return this.getEngineByClass(fClass);
        }
        return null;
    }

    public List<ScriptEngineFactory> getEngineFactories() {
        return new ArrayList<ScriptEngineFactory>(this._engineFactories);
    }

    public void registerEngineName(String name, Class factory) {
        this.nameAssociations.put(name, factory);
    }

    public void registerEngineMimeType(String mimeType, Class factory) {
        this.mimeTypeAssociations.put(mimeType, factory);
    }

    public void registerEngineExtension(String ext, Class factory) {
        this.extensionAssociations.put(ext, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEngines(ClassLoader loader) {
        try {
            Enumeration<URL> resources = loader.getResources("META-INF/services/javax.script.ScriptEngineFactory");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream is = url.openStream();
                try {
                    this.readFactoryFile(is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void readFactoryFile(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            int p = line.indexOf(35);
            if (p >= 0) {
                line = line.substring(0, p);
            }
            if ((line = line.trim()).length() <= 0) continue;
            this.addFactoryClass(line);
        }
    }

    private void addFactoryClass(String className) {
        try {
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            Class<?> cl = Class.forName(className, false, loader);
            ScriptEngineFactory factory = (ScriptEngineFactory)cl.newInstance();
            if (this.engineSpis.contains(cl)) {
                return;
            }
            this._engineFactories.add(factory);
            this.engineSpis.add(cl);
            for (String name : factory.getNames()) {
                this.registerEngineName(name, cl);
            }
            for (String mimeType : factory.getMimeTypes()) {
                this.registerEngineMimeType(mimeType, cl);
            }
            for (String ext : factory.getExtensions()) {
                this.registerEngineExtension(ext, cl);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ScriptEngine getEngineByClass(Class cl) {
        ScriptEngineFactory factory = this.getFactoryByClass(cl);
        if (factory != null) {
            ScriptEngine engine = factory.getScriptEngine();
            ScriptContext cxt = engine.getContext();
            cxt.setBindings(this.globalScope, 200);
            return engine;
        }
        return null;
    }

    private ScriptEngineFactory getFactoryByClass(Class cl) {
        for (int i = 0; i < this._engineFactories.size(); ++i) {
            ScriptEngineFactory factory = (ScriptEngineFactory)this._engineFactories.get(i);
            if (!factory.getClass().equals(cl)) continue;
            return factory;
        }
        return null;
    }
}

