/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.formats.html;

import com.liferay.tools.doclets.formats.html.ConfigurationImpl;
import com.liferay.tools.doclets.formats.html.ConstructorWriterImpl;
import com.liferay.tools.doclets.formats.html.FieldWriterImpl;
import com.liferay.tools.doclets.formats.html.LinkInfoImpl;
import com.liferay.tools.doclets.formats.html.MethodWriterImpl;
import com.liferay.tools.doclets.formats.html.NestedClassWriterImpl;
import com.liferay.tools.doclets.formats.html.PackageUseWriter;
import com.liferay.tools.doclets.formats.html.SubWriterHolderWriter;
import com.liferay.tools.doclets.internal.toolkit.util.ClassTree;
import com.liferay.tools.doclets.internal.toolkit.util.ClassUseMapper;
import com.liferay.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.liferay.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ClassUseWriter
extends SubWriterHolderWriter {
    final ClassDoc classdoc;
    Set pkgToPackageAnnotations = null;
    final Map pkgToClassTypeParameter;
    final Map pkgToClassAnnotations;
    final Map pkgToMethodTypeParameter;
    final Map pkgToMethodArgTypeParameter;
    final Map pkgToMethodReturnTypeParameter;
    final Map pkgToMethodAnnotations;
    final Map pkgToMethodParameterAnnotations;
    final Map pkgToFieldTypeParameter;
    final Map pkgToFieldAnnotations;
    final Map pkgToSubclass;
    final Map pkgToSubinterface;
    final Map pkgToImplementingClass;
    final Map pkgToField;
    final Map pkgToMethodReturn;
    final Map pkgToMethodArgs;
    final Map pkgToMethodThrows;
    final Map pkgToConstructorAnnotations;
    final Map pkgToConstructorParameterAnnotations;
    final Map pkgToConstructorArgs;
    final Map pkgToConstructorArgTypeParameter;
    final Map pkgToConstructorThrows;
    final SortedSet pkgSet;
    final MethodWriterImpl methodSubWriter;
    final ConstructorWriterImpl constrSubWriter;
    final FieldWriterImpl fieldSubWriter;
    final NestedClassWriterImpl classSubWriter;

    public ClassUseWriter(ConfigurationImpl configuration, ClassUseMapper mapper, String path, String filename, String relpath, ClassDoc classdoc) throws IOException {
        super(configuration, path, filename, relpath);
        this.classdoc = classdoc;
        if (mapper.classToPackageAnnotations.containsKey(classdoc.qualifiedName())) {
            this.pkgToPackageAnnotations = new HashSet((List)mapper.classToPackageAnnotations.get(classdoc.qualifiedName()));
        }
        configuration.currentcd = classdoc;
        this.pkgSet = new TreeSet();
        this.pkgToClassTypeParameter = this.pkgDivide(mapper.classToClassTypeParam);
        this.pkgToClassAnnotations = this.pkgDivide(mapper.classToClassAnnotations);
        this.pkgToMethodTypeParameter = this.pkgDivide(mapper.classToExecMemberDocTypeParam);
        this.pkgToMethodArgTypeParameter = this.pkgDivide(mapper.classToExecMemberDocArgTypeParam);
        this.pkgToFieldTypeParameter = this.pkgDivide(mapper.classToFieldDocTypeParam);
        this.pkgToFieldAnnotations = this.pkgDivide(mapper.annotationToFieldDoc);
        this.pkgToMethodReturnTypeParameter = this.pkgDivide(mapper.classToExecMemberDocReturnTypeParam);
        this.pkgToMethodAnnotations = this.pkgDivide(mapper.classToExecMemberDocAnnotations);
        this.pkgToMethodParameterAnnotations = this.pkgDivide(mapper.classToExecMemberDocParamAnnotation);
        this.pkgToSubclass = this.pkgDivide(mapper.classToSubclass);
        this.pkgToSubinterface = this.pkgDivide(mapper.classToSubinterface);
        this.pkgToImplementingClass = this.pkgDivide(mapper.classToImplementingClass);
        this.pkgToField = this.pkgDivide(mapper.classToField);
        this.pkgToMethodReturn = this.pkgDivide(mapper.classToMethodReturn);
        this.pkgToMethodArgs = this.pkgDivide(mapper.classToMethodArgs);
        this.pkgToMethodThrows = this.pkgDivide(mapper.classToMethodThrows);
        this.pkgToConstructorAnnotations = this.pkgDivide(mapper.classToConstructorAnnotations);
        this.pkgToConstructorParameterAnnotations = this.pkgDivide(mapper.classToConstructorParamAnnotation);
        this.pkgToConstructorArgs = this.pkgDivide(mapper.classToConstructorArgs);
        this.pkgToConstructorArgTypeParameter = this.pkgDivide(mapper.classToConstructorDocArgTypeParam);
        this.pkgToConstructorThrows = this.pkgDivide(mapper.classToConstructorThrows);
        if (this.pkgSet.size() > 0 && mapper.classToPackage.containsKey(classdoc.qualifiedName()) && !this.pkgSet.equals(mapper.classToPackage.get(classdoc.qualifiedName()))) {
            configuration.root.printWarning("Internal error: package sets don't match: " + this.pkgSet + " with: " + mapper.classToPackage.get(classdoc.qualifiedName()));
        }
        this.methodSubWriter = new MethodWriterImpl(this);
        this.constrSubWriter = new ConstructorWriterImpl(this);
        this.fieldSubWriter = new FieldWriterImpl(this);
        this.classSubWriter = new NestedClassWriterImpl(this);
    }

    public static void generate(ConfigurationImpl configuration, ClassTree classtree) {
        ClassUseMapper mapper = new ClassUseMapper(configuration.root, classtree);
        ClassDoc[] classes = configuration.root.classes();
        for (int i = 0; i < classes.length; ++i) {
            ClassUseWriter.generate(configuration, mapper, classes[i]);
        }
        PackageDoc[] pkgs = configuration.packages;
        for (int i = 0; i < pkgs.length; ++i) {
            PackageUseWriter.generate(configuration, mapper, pkgs[i]);
        }
    }

    private Map pkgDivide(Map classMap) {
        HashMap<String, ArrayList<ProgramElementDoc>> map = new HashMap<String, ArrayList<ProgramElementDoc>>();
        List list = (List)classMap.get(this.classdoc.qualifiedName());
        if (list != null) {
            Collections.sort(list);
            for (ProgramElementDoc doc : list) {
                PackageDoc pkg = doc.containingPackage();
                this.pkgSet.add(pkg);
                ArrayList<ProgramElementDoc> inPkg = (ArrayList<ProgramElementDoc>)map.get(pkg.name());
                if (inPkg == null) {
                    inPkg = new ArrayList<ProgramElementDoc>();
                    map.put(pkg.name(), inPkg);
                }
                inPkg.add(doc);
            }
        }
        return map;
    }

    public static void generate(ConfigurationImpl configuration, ClassUseMapper mapper, ClassDoc classdoc) {
        String path = DirectoryManager.getDirectoryPath(classdoc.containingPackage());
        if (path.length() > 0) {
            path = path + File.separator;
        }
        path = path + "class-use";
        String filename = classdoc.name() + ".html";
        String pkgname = classdoc.containingPackage().name();
        pkgname = pkgname + (pkgname.length() > 0 ? ".class-use" : "class-use");
        String relpath = DirectoryManager.getRelativePath(pkgname);
        try {
            ClassUseWriter clsgen = new ClassUseWriter(configuration, mapper, path, filename, relpath, classdoc);
            clsgen.generateClassUseFile();
            clsgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateClassUseFile() throws IOException {
        this.printClassUseHeader();
        if (this.pkgSet.size() > 0) {
            this.generateClassUse();
        } else {
            this.printText("doclet.ClassUse_No.usage.of.0", this.classdoc.qualifiedName());
            this.p();
        }
        this.printClassUseFooter();
    }

    protected void generateClassUse() throws IOException {
        if (this.configuration.packages.length > 1) {
            this.generatePackageList();
            this.generatePackageAnnotationList();
        }
        this.generateClassList();
    }

    protected void generatePackageList() throws IOException {
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.printText("doclet.ClassUse_Packages.that.use.0", this.getLink(new LinkInfoImpl(33, this.classdoc, false)));
        this.tableHeaderEnd();
        for (PackageDoc pkg : this.pkgSet) {
            this.generatePackageUse(pkg);
        }
        this.tableEnd();
        this.space();
        this.p();
    }

    protected void generatePackageAnnotationList() throws IOException {
        if (!this.classdoc.isAnnotationType() || this.pkgToPackageAnnotations == null || this.pkgToPackageAnnotations.size() == 0) {
            return;
        }
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.printText("doclet.ClassUse_PackageAnnotation", this.getLink(new LinkInfoImpl(33, this.classdoc, false)));
        this.tableHeaderEnd();
        for (PackageDoc pkg : this.pkgToPackageAnnotations) {
            this.trBgcolorStyle("white", "TableRowColor");
            this.summaryRow(0);
            this.printPackageLink(pkg, pkg.name(), true);
            this.summaryRowEnd();
            this.summaryRow(0);
            this.printSummaryComment((Doc)pkg);
            this.space();
            this.summaryRowEnd();
            this.trEnd();
        }
        this.tableEnd();
        this.space();
        this.p();
    }

    protected void generateClassList() throws IOException {
        for (PackageDoc pkg : this.pkgSet) {
            this.anchor(pkg.name());
            this.tableIndexSummary();
            this.tableHeaderStart("#CCCCFF");
            this.printText("doclet.ClassUse_Uses.of.0.in.1", this.getLink(new LinkInfoImpl(33, this.classdoc, false)), this.getPackageLink(pkg, Util.getPackageName(pkg), false));
            this.tableHeaderEnd();
            this.tableEnd();
            this.space();
            this.p();
            this.generateClassUse(pkg);
        }
    }

    protected void generatePackageUse(PackageDoc pkg) throws IOException {
        this.trBgcolorStyle("white", "TableRowColor");
        this.summaryRow(0);
        this.printHyperLink("", pkg.name(), Util.getPackageName(pkg), true);
        this.summaryRowEnd();
        this.summaryRow(0);
        this.printSummaryComment((Doc)pkg);
        this.space();
        this.summaryRowEnd();
        this.trEnd();
    }

    protected void generateClassUse(PackageDoc pkg) throws IOException {
        String classLink = this.getLink(new LinkInfoImpl(33, this.classdoc, false));
        String pkgLink = this.getPackageLink(pkg, Util.getPackageName(pkg), false);
        this.classSubWriter.printUseInfo(this.pkgToClassAnnotations.get(pkg.name()), this.configuration.getText("doclet.ClassUse_Annotation", classLink, pkgLink));
        this.classSubWriter.printUseInfo(this.pkgToClassTypeParameter.get(pkg.name()), this.configuration.getText("doclet.ClassUse_TypeParameter", classLink, pkgLink));
        this.classSubWriter.printUseInfo(this.pkgToSubclass.get(pkg.name()), this.configuration.getText("doclet.ClassUse_Subclass", classLink, pkgLink));
        this.classSubWriter.printUseInfo(this.pkgToSubinterface.get(pkg.name()), this.configuration.getText("doclet.ClassUse_Subinterface", classLink, pkgLink));
        this.classSubWriter.printUseInfo(this.pkgToImplementingClass.get(pkg.name()), this.configuration.getText("doclet.ClassUse_ImplementingClass", classLink, pkgLink));
        this.fieldSubWriter.printUseInfo(this.pkgToField.get(pkg.name()), this.configuration.getText("doclet.ClassUse_Field", classLink, pkgLink));
        this.fieldSubWriter.printUseInfo(this.pkgToFieldAnnotations.get(pkg.name()), this.configuration.getText("doclet.ClassUse_FieldAnnotations", classLink, pkgLink));
        this.fieldSubWriter.printUseInfo(this.pkgToFieldTypeParameter.get(pkg.name()), this.configuration.getText("doclet.ClassUse_FieldTypeParameter", classLink, pkgLink));
        this.methodSubWriter.printUseInfo(this.pkgToMethodAnnotations.get(pkg.name()), this.configuration.getText("doclet.ClassUse_MethodAnnotations", classLink, pkgLink));
        this.methodSubWriter.printUseInfo(this.pkgToMethodParameterAnnotations.get(pkg.name()), this.configuration.getText("doclet.ClassUse_MethodParameterAnnotations", classLink, pkgLink));
        this.methodSubWriter.printUseInfo(this.pkgToMethodTypeParameter.get(pkg.name()), this.configuration.getText("doclet.ClassUse_MethodTypeParameter", classLink, pkgLink));
        this.methodSubWriter.printUseInfo(this.pkgToMethodReturn.get(pkg.name()), this.configuration.getText("doclet.ClassUse_MethodReturn", classLink, pkgLink));
        this.methodSubWriter.printUseInfo(this.pkgToMethodReturnTypeParameter.get(pkg.name()), this.configuration.getText("doclet.ClassUse_MethodReturnTypeParameter", classLink, pkgLink));
        this.methodSubWriter.printUseInfo(this.pkgToMethodArgs.get(pkg.name()), this.configuration.getText("doclet.ClassUse_MethodArgs", classLink, pkgLink));
        this.methodSubWriter.printUseInfo(this.pkgToMethodArgTypeParameter.get(pkg.name()), this.configuration.getText("doclet.ClassUse_MethodArgsTypeParameters", classLink, pkgLink));
        this.methodSubWriter.printUseInfo(this.pkgToMethodThrows.get(pkg.name()), this.configuration.getText("doclet.ClassUse_MethodThrows", classLink, pkgLink));
        this.constrSubWriter.printUseInfo(this.pkgToConstructorAnnotations.get(pkg.name()), this.configuration.getText("doclet.ClassUse_ConstructorAnnotations", classLink, pkgLink));
        this.constrSubWriter.printUseInfo(this.pkgToConstructorParameterAnnotations.get(pkg.name()), this.configuration.getText("doclet.ClassUse_ConstructorParameterAnnotations", classLink, pkgLink));
        this.constrSubWriter.printUseInfo(this.pkgToConstructorArgs.get(pkg.name()), this.configuration.getText("doclet.ClassUse_ConstructorArgs", classLink, pkgLink));
        this.constrSubWriter.printUseInfo(this.pkgToConstructorArgTypeParameter.get(pkg.name()), this.configuration.getText("doclet.ClassUse_ConstructorArgsTypeParameters", classLink, pkgLink));
        this.constrSubWriter.printUseInfo(this.pkgToConstructorThrows.get(pkg.name()), this.configuration.getText("doclet.ClassUse_ConstructorThrows", classLink, pkgLink));
    }

    protected void printClassUseHeader() {
        String cltype = this.configuration.getText(this.classdoc.isInterface() ? "doclet.Interface" : "doclet.Class");
        String clname = this.classdoc.qualifiedName();
        this.printHtmlHeader(this.configuration.getText("doclet.Window_ClassUse_Header", cltype, clname), null, true);
        this.printTop();
        this.navLinks(true);
        this.hr();
        this.center();
        this.h2();
        this.boldText("doclet.ClassUse_Title", cltype, clname);
        this.h2End();
        this.centerEnd();
    }

    protected void printClassUseFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("../package-summary.html", "", this.configuration.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkClass() {
        this.navCellStart();
        this.printLink(new LinkInfoImpl(33, this.classdoc, "", this.configuration.getText("doclet.Class"), true, "NavBarFont1"));
        this.navCellEnd();
    }

    protected void navLinkClassUse() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.navClassUse");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkTree() {
        this.navCellStart();
        if (this.classdoc.containingPackage().isIncluded()) {
            this.printHyperLink("../package-tree.html", "", this.configuration.getText("doclet.Tree"), true, "NavBarFont1");
        } else {
            this.printHyperLink(this.relativePath + "overview-tree.html", "", this.configuration.getText("doclet.Tree"), true, "NavBarFont1");
        }
        this.navCellEnd();
    }
}

