/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.formats.html;

import com.liferay.tools.doclets.formats.html.ConfigurationImpl;
import com.liferay.tools.doclets.formats.html.HtmlDocletWriter;
import com.liferay.tools.doclets.formats.html.LinkInfoImpl;
import com.liferay.tools.doclets.internal.toolkit.ConstantsSummaryWriter;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class ConstantsSummaryWriterImpl
extends HtmlDocletWriter
implements ConstantsSummaryWriter {
    ConfigurationImpl configuration;
    private ClassDoc currentClassDoc;

    public ConstantsSummaryWriterImpl(ConfigurationImpl configuration) throws IOException {
        super(configuration, "constant-values.html");
        this.configuration = configuration;
    }

    public void writeHeader() {
        this.printHtmlHeader(this.configuration.getText("doclet.Constants_Summary"), null, true);
        this.printTop();
        this.navLinks(true);
        this.hr();
        this.center();
        this.h1();
        this.printText("doclet.Constants_Summary");
        this.h1End();
        this.centerEnd();
        this.hr(4, "noshade");
    }

    public void writeFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    public void writeContentsHeader() {
        this.bold(this.configuration.getText("doclet.Contents"));
        this.ul();
    }

    public void writeContentsFooter() {
        this.ulEnd();
        this.println();
    }

    public void writeLinkToPackageContent(PackageDoc pkg, String parsedPackageName, Set printedPackageHeaders) {
        String packageName = pkg.name();
        this.li();
        if (packageName.length() == 0) {
            this.printHyperLink("#unnamed_package", "&lt;Unnamed&gt;");
        } else {
            this.printHyperLink("#" + parsedPackageName, parsedPackageName + ".*");
            printedPackageHeaders.add(parsedPackageName);
        }
        this.println();
    }

    public void writeConstantMembersHeader(ClassDoc cd) {
        String classlink = cd.isPublic() || cd.isProtected() ? this.getLink(new LinkInfoImpl(6, cd, false)) : cd.qualifiedName();
        String name = cd.containingPackage().name();
        if (name.length() > 0) {
            this.writeClassName(name + "." + classlink);
        } else {
            this.writeClassName(classlink);
        }
    }

    public void writeConstantMembersFooter(ClassDoc cd) {
        this.tableFooter(false);
        this.p();
    }

    protected void writeClassName(String classStr) {
        this.table(1, 3, 0);
        this.trBgcolorStyle("#EEEEFF", "TableSubHeadingColor");
        this.thAlignColspan("left", 3);
        this.write(classStr);
        this.thEnd();
        this.trEnd();
    }

    private void tableFooter(boolean isHeader) {
        this.fontEnd();
        if (isHeader) {
            this.thEnd();
        } else {
            this.tdEnd();
        }
        this.trEnd();
        this.tableEnd();
        this.p();
    }

    public void writePackageName(PackageDoc pkg, String parsedPackageName) {
        String pkgname;
        if (parsedPackageName.length() == 0) {
            this.anchor("unnamed_package");
            pkgname = "&lt;Unnamed&gt;";
        } else {
            this.anchor(parsedPackageName);
            pkgname = parsedPackageName;
        }
        this.table(1, "100%", 3, 0);
        this.trBgcolorStyle("#CCCCFF", "TableHeadingColor");
        this.thAlign("left");
        this.font("+2");
        this.write(pkgname + ".*");
        this.tableFooter(true);
    }

    public void writeConstantMembers(ClassDoc cd, List fields) {
        this.currentClassDoc = cd;
        for (int i = 0; i < fields.size(); ++i) {
            this.writeConstantMember((FieldDoc)fields.get(i));
        }
    }

    private void writeConstantMember(FieldDoc member) {
        this.trBgcolorStyle("white", "TableRowColor");
        this.anchor(this.currentClassDoc.qualifiedName() + "." + member.name());
        this.writeTypeColumn(member);
        this.writeNameColumn(member);
        this.writeValue(member);
        this.trEnd();
    }

    private void writeTypeColumn(FieldDoc member) {
        this.tdAlign("right");
        this.font("-1");
        this.code();
        StringTokenizer mods = new StringTokenizer(member.modifiers());
        while (mods.hasMoreTokens()) {
            this.print(mods.nextToken() + "&nbsp;");
        }
        this.printLink(new LinkInfoImpl(6, member.type()));
        this.codeEnd();
        this.fontEnd();
        this.tdEnd();
    }

    private void writeNameColumn(FieldDoc member) {
        this.tdAlign("left");
        this.code();
        this.printDocLink(6, (MemberDoc)member, member.name(), false);
        this.codeEnd();
        this.tdEnd();
    }

    private void writeValue(FieldDoc member) {
        this.tdAlign("right");
        this.code();
        this.print(Util.escapeHtmlChars(member.constantValueExpression()));
        this.codeEnd();
        this.tdEnd();
    }
}

