/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.formats.html;

import com.liferay.tools.doclets.formats.html.ConfigurationImpl;
import com.liferay.tools.doclets.formats.html.HtmlDocletWriter;
import com.liferay.tools.doclets.formats.html.LinkInfoImpl;
import com.liferay.tools.doclets.formats.html.LinkOutputImpl;
import com.liferay.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.liferay.tools.doclets.internal.toolkit.util.links.LinkFactory;
import com.liferay.tools.doclets.internal.toolkit.util.links.LinkInfo;
import com.liferay.tools.doclets.internal.toolkit.util.links.LinkOutput;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.Type;

public class LinkFactoryImpl
extends LinkFactory {
    private HtmlDocletWriter m_writer;

    public LinkFactoryImpl(HtmlDocletWriter writer) {
        this.m_writer = writer;
    }

    protected LinkOutput getOutputInstance() {
        return new LinkOutputImpl();
    }

    protected LinkOutput getClassLink(LinkInfo linkInfo) {
        LinkInfoImpl classLinkInfo = (LinkInfoImpl)linkInfo;
        boolean noLabel = linkInfo.label == null || linkInfo.label.length() == 0;
        ClassDoc classDoc = classLinkInfo.classDoc;
        String title = classLinkInfo.where == null || classLinkInfo.where.length() == 0 ? this.getClassToolTip(classDoc, classLinkInfo.type != null && !classDoc.qualifiedTypeName().equals(classLinkInfo.type.qualifiedTypeName())) : "";
        StringBuffer label = new StringBuffer(classLinkInfo.getClassLinkLabel(this.m_writer.configuration));
        classLinkInfo.displayLength += label.length();
        if (noLabel && classLinkInfo.excludeTypeParameterLinks) {
            label.append(this.getTypeParameterLinks(linkInfo).toString());
        }
        ConfigurationImpl configuration = ConfigurationImpl.getInstance();
        LinkOutputImpl linkOutput = new LinkOutputImpl();
        if (classDoc.isIncluded()) {
            if (configuration.isGeneratedDoc((Doc)classDoc)) {
                String filename = this.pathString(classLinkInfo);
                if (linkInfo.linkToSelf || !(linkInfo.classDoc.name() + ".html").equals(this.m_writer.filename)) {
                    linkOutput.append(this.m_writer.getHyperLink(filename, classLinkInfo.where, label.toString(), classLinkInfo.isBold, classLinkInfo.styleName, title, classLinkInfo.target));
                    if (noLabel && !classLinkInfo.excludeTypeParameterLinks) {
                        linkOutput.append(this.getTypeParameterLinks(linkInfo).toString());
                    }
                    return linkOutput;
                }
            }
        } else {
            String crossLink = this.m_writer.getCrossClassLink(classDoc.qualifiedName(), classLinkInfo.where, label.toString(), classLinkInfo.isBold, classLinkInfo.styleName, true);
            if (crossLink != null) {
                linkOutput.append(crossLink);
                if (noLabel && !classLinkInfo.excludeTypeParameterLinks) {
                    linkOutput.append(this.getTypeParameterLinks(linkInfo).toString());
                }
                return linkOutput;
            }
        }
        linkOutput.append(label.toString());
        if (noLabel && !classLinkInfo.excludeTypeParameterLinks) {
            linkOutput.append(this.getTypeParameterLinks(linkInfo).toString());
        }
        return linkOutput;
    }

    protected LinkOutput getTypeParameterLink(LinkInfo linkInfo, Type typeParam) {
        LinkInfoImpl typeLinkInfo = new LinkInfoImpl(linkInfo.getContext(), typeParam);
        typeLinkInfo.excludeTypeBounds = linkInfo.excludeTypeBounds;
        typeLinkInfo.excludeTypeParameterLinks = linkInfo.excludeTypeParameterLinks;
        typeLinkInfo.linkToSelf = linkInfo.linkToSelf;
        LinkOutput output = this.getLinkOutput(typeLinkInfo);
        ((LinkInfoImpl)linkInfo).displayLength += typeLinkInfo.displayLength;
        return output;
    }

    private String getClassToolTip(ClassDoc classDoc, boolean isTypeLink) {
        ConfigurationImpl configuration = ConfigurationImpl.getInstance();
        if (isTypeLink) {
            return configuration.getText("doclet.Href_Type_Param_Title", classDoc.name());
        }
        if (classDoc.isInterface()) {
            return configuration.getText("doclet.Href_Interface_Title", Util.getPackageName(classDoc.containingPackage()));
        }
        if (classDoc.isAnnotationType()) {
            return configuration.getText("doclet.Href_Annotation_Title", Util.getPackageName(classDoc.containingPackage()));
        }
        if (classDoc.isEnum()) {
            return configuration.getText("doclet.Href_Enum_Title", Util.getPackageName(classDoc.containingPackage()));
        }
        return configuration.getText("doclet.Href_Class_Title", Util.getPackageName(classDoc.containingPackage()));
    }

    private String pathString(LinkInfoImpl linkInfo) {
        if (linkInfo.context == 13) {
            return linkInfo.classDoc.name() + ".html";
        }
        StringBuffer buf = new StringBuffer(this.m_writer.relativePath);
        buf.append(DirectoryManager.getPathToPackage(linkInfo.classDoc.containingPackage(), linkInfo.classDoc.name() + ".html"));
        return buf.toString();
    }
}

