/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.formats.html;

import com.liferay.tools.doclets.formats.html.AbstractPackageIndexWriter;
import com.liferay.tools.doclets.formats.html.ConfigurationImpl;
import com.liferay.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class PackageIndexWriter
extends AbstractPackageIndexWriter {
    private RootDoc root;
    private Map groupPackageMap;
    private List groupList;

    public PackageIndexWriter(ConfigurationImpl configuration, String filename) throws IOException {
        super(configuration, filename);
        this.root = configuration.root;
        this.groupPackageMap = configuration.group.groupPackages(this.packages);
        this.groupList = configuration.group.getGroupList();
    }

    public static void generate(ConfigurationImpl configuration) {
        String filename = "overview-summary.html";
        try {
            PackageIndexWriter packgen = new PackageIndexWriter(configuration, filename);
            packgen.generatePackageIndexFile("doclet.Window_Overview_Summary", true);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void printIndexRow(PackageDoc pkg) {
        if (pkg != null && pkg.name().length() > 0) {
            this.trBgcolorStyle("white", "TableRowColor");
            this.summaryRow(20);
            this.bold();
            this.printPackageLink(pkg, Util.getPackageName(pkg), false);
            this.boldEnd();
            this.summaryRowEnd();
            this.summaryRow(0);
            this.printSummaryComment((Doc)pkg);
            this.summaryRowEnd();
            this.trEnd();
        }
    }

    protected void generateIndex() {
        for (int i = 0; i < this.groupList.size(); ++i) {
            String groupname = (String)this.groupList.get(i);
            List list = (List)this.groupPackageMap.get(groupname);
            if (list == null || list.size() <= 0) continue;
            this.printIndexContents(list.toArray(new PackageDoc[list.size()]), groupname);
        }
    }

    protected void printOverviewHeader() {
        if (this.root.inlineTags().length > 0) {
            this.printSummaryComment((Doc)this.root);
            this.p();
            this.bold(this.configuration.getText("doclet.See"));
            this.br();
            this.printNbsps();
            this.printHyperLink("", "overview_description", this.configuration.getText("doclet.Description"), true);
            this.p();
        }
    }

    protected void printIndexHeader(String text) {
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.bold(text);
        this.tableHeaderEnd();
    }

    protected void printIndexFooter() {
        this.tableEnd();
        this.p();
        this.space();
    }

    protected void printOverviewComment() {
        if (this.root.inlineTags().length > 0) {
            this.anchor("overview_description");
            this.p();
            this.printInlineComment((Doc)this.root);
            this.p();
        }
    }

    protected void printOverview() throws IOException {
        this.printOverviewComment();
        this.printTags((Doc)this.root);
    }

    protected void printNavigationBarHeader() {
        this.printTop();
        this.navLinks(true);
        this.hr();
        this.printConfigurationTitle();
    }

    protected void printNavigationBarFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
    }
}

