/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.formats.html;

import com.liferay.tools.doclets.formats.html.ClassWriterImpl;
import com.liferay.tools.doclets.formats.html.ConfigurationImpl;
import com.liferay.tools.doclets.formats.html.HtmlDocletWriter;
import com.liferay.tools.doclets.formats.html.LinkInfoImpl;
import com.liferay.tools.doclets.formats.html.TagletOutputImpl;
import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.builders.SerializedFormBuilder;
import com.liferay.tools.doclets.internal.toolkit.taglets.TagletOutput;
import com.liferay.tools.doclets.internal.toolkit.taglets.TagletWriter;
import com.liferay.tools.doclets.internal.toolkit.util.DocletConstants;
import com.liferay.tools.doclets.internal.toolkit.util.MessageRetriever;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;

public class TagletWriterImpl
extends TagletWriter {
    private HtmlDocletWriter htmlWriter;

    public TagletWriterImpl(HtmlDocletWriter htmlWriter, boolean isFirstSentence) {
        this.htmlWriter = htmlWriter;
        this.isFirstSentence = isFirstSentence;
    }

    public TagletOutput getOutputInstance() {
        return new TagletOutputImpl("");
    }

    public TagletOutput getDocRootOutput() {
        return new TagletOutputImpl(this.htmlWriter.relativepathNoSlash);
    }

    public TagletOutput deprecatedTagOutput(Doc doc) {
        StringBuffer output = new StringBuffer();
        Tag[] deprs = doc.tags("deprecated");
        if (doc instanceof ClassDoc) {
            if (Util.isDeprecated((ProgramElementDoc)doc)) {
                Tag[] commentTags;
                output.append("<B>" + ConfigurationImpl.getInstance().getText("doclet.Deprecated") + "</B>&nbsp;");
                if (deprs.length > 0 && (commentTags = deprs[0].inlineTags()).length > 0) {
                    output.append(this.commentTagsToOutput(null, doc, deprs[0].inlineTags(), false).toString());
                }
                output.append("<p>");
            }
        } else {
            MemberDoc member = (MemberDoc)doc;
            if (Util.isDeprecated((ProgramElementDoc)doc)) {
                output.append("<DD><B>" + ConfigurationImpl.getInstance().getText("doclet.Deprecated") + "</B>&nbsp;");
                if (deprs.length > 0) {
                    output.append("<I>");
                    output.append(this.commentTagsToOutput(null, doc, deprs[0].inlineTags(), false).toString());
                    output.append("</I>");
                }
                if (member instanceof ExecutableMemberDoc) {
                    output.append(DocletConstants.NL + "<P>" + DocletConstants.NL);
                }
            } else if (Util.isDeprecated((ProgramElementDoc)member.containingClass())) {
                output.append("<DD><B>" + ConfigurationImpl.getInstance().getText("doclet.Deprecated") + "</B>&nbsp;");
            }
        }
        return new TagletOutputImpl(output.toString());
    }

    public MessageRetriever getMsgRetriever() {
        return this.htmlWriter.configuration.message;
    }

    public TagletOutput getParamHeader(String header) {
        StringBuffer result = new StringBuffer();
        result.append("<DT>");
        result.append("<B>" + header + "</B>");
        return new TagletOutputImpl(result.toString());
    }

    public TagletOutput paramTagOutput(ParamTag paramTag, String paramName) {
        TagletOutputImpl result = new TagletOutputImpl("<DD><CODE>" + paramName + "</CODE>" + " - " + this.htmlWriter.commentTagsToString((Tag)paramTag, null, paramTag.inlineTags(), false));
        return result;
    }

    public TagletOutput returnTagOutput(Tag returnTag) {
        TagletOutputImpl result = new TagletOutputImpl(DocletConstants.NL + "<DT>" + "<B>" + this.htmlWriter.configuration.getText("doclet.Returns") + "</B>" + "<DD>" + this.htmlWriter.commentTagsToString(returnTag, null, returnTag.inlineTags(), false));
        return result;
    }

    public TagletOutput seeTagOutput(Doc holder, SeeTag[] seeTags) {
        String result = "";
        if (seeTags.length > 0) {
            result = this.addSeeHeader(result);
            for (int i = 0; i < seeTags.length; ++i) {
                if (i > 0) {
                    result = result + ", " + DocletConstants.NL;
                }
                result = result + this.htmlWriter.seeTagToString(seeTags[i]);
            }
        }
        if (holder.isField() && ((FieldDoc)holder).constantValue() != null && this.htmlWriter instanceof ClassWriterImpl) {
            result = this.addSeeHeader(result);
            result = result + this.htmlWriter.getHyperLink(this.htmlWriter.relativePath + "constant-values.html" + "#" + ((ClassWriterImpl)this.htmlWriter).getClassDoc().qualifiedName() + "." + ((FieldDoc)holder).name(), this.htmlWriter.configuration.getText("doclet.Constants_Summary"));
        }
        if (holder.isClass() && ((ClassDoc)holder).isSerializable()) {
            if (!SerializedFormBuilder.serialInclude(holder) || !SerializedFormBuilder.serialInclude((Doc)((ClassDoc)holder).containingPackage())) {
                return result.equals("") ? null : new TagletOutputImpl(result);
            }
            result = this.addSeeHeader(result);
            result = result + this.htmlWriter.getHyperLink(this.htmlWriter.relativePath + "serialized-form.html", ((ClassDoc)holder).qualifiedName(), this.htmlWriter.configuration.getText("doclet.Serialized_Form"), false);
        }
        return result.equals("") ? null : new TagletOutputImpl(result);
    }

    private String addSeeHeader(String result) {
        if (result != null && result.length() > 0) {
            return result + ", " + DocletConstants.NL;
        }
        return "<DT><B>" + this.htmlWriter.configuration().getText("doclet.See_Also") + "</B><DD>";
    }

    public TagletOutput simpleTagOutput(Tag[] simpleTags, String header) {
        String result = "<DT><B>" + header + "</B></DT>" + DocletConstants.NL + "  <DD>";
        for (int i = 0; i < simpleTags.length; ++i) {
            if (i > 0) {
                result = result + ", ";
            }
            result = result + this.htmlWriter.commentTagsToString(simpleTags[i], null, simpleTags[i].inlineTags(), false);
        }
        return new TagletOutputImpl(result + "</DD>" + DocletConstants.NL);
    }

    public TagletOutput simpleTagOutput(Tag simpleTag, String header) {
        return new TagletOutputImpl("<DT><B>" + header + "</B></DT>" + "  <DD>" + this.htmlWriter.commentTagsToString(simpleTag, null, simpleTag.inlineTags(), false) + "</DD>" + DocletConstants.NL);
    }

    public TagletOutput getThrowsHeader() {
        return new TagletOutputImpl(DocletConstants.NL + "<DT>" + "<B>" + this.htmlWriter.configuration().getText("doclet.Throws") + "</B>");
    }

    public TagletOutput throwsTagOutput(ThrowsTag throwsTag) {
        String result = DocletConstants.NL + "<DD>";
        result = result + (throwsTag.exceptionType() == null ? this.htmlWriter.codeText(throwsTag.exceptionName()) : this.htmlWriter.codeText(this.htmlWriter.getLink(new LinkInfoImpl(3, throwsTag.exceptionType()))));
        TagletOutputImpl text = new TagletOutputImpl(this.htmlWriter.commentTagsToString((Tag)throwsTag, null, throwsTag.inlineTags(), false));
        if (text != null && ((Object)text).toString().length() > 0) {
            result = result + " - " + text;
        }
        return new TagletOutputImpl(result);
    }

    public TagletOutput throwsTagOutput(Type throwsType) {
        return new TagletOutputImpl(DocletConstants.NL + "<DD>" + this.htmlWriter.codeText(this.htmlWriter.getLink(new LinkInfoImpl(3, throwsType))));
    }

    public TagletOutput valueTagOutput(FieldDoc field, String constantVal, boolean includeLink) {
        return new TagletOutputImpl(includeLink ? this.htmlWriter.getDocLink(11, (MemberDoc)field, constantVal, false) : constantVal);
    }

    public TagletOutput commentTagsToOutput(Tag holderTag, Tag[] tags) {
        return this.commentTagsToOutput(holderTag, null, tags, false);
    }

    public TagletOutput commentTagsToOutput(Doc holderDoc, Tag[] tags) {
        return this.commentTagsToOutput(null, holderDoc, tags, false);
    }

    public TagletOutput commentTagsToOutput(Tag holderTag, Doc holderDoc, Tag[] tags, boolean isFirstSentence) {
        return new TagletOutputImpl(this.htmlWriter.commentTagsToString(holderTag, holderDoc, tags, isFirstSentence));
    }

    public Configuration configuration() {
        return this.htmlWriter.configuration();
    }

    public TagletOutput getTagletOutputInstance() {
        return new TagletOutputImpl("");
    }
}

