/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit;

import com.liferay.tools.doclets.internal.toolkit.WriterFactory;
import com.liferay.tools.doclets.internal.toolkit.builders.BuilderFactory;
import com.liferay.tools.doclets.internal.toolkit.taglets.TagletManager;
import com.liferay.tools.doclets.internal.toolkit.util.ClassDocCatalog;
import com.liferay.tools.doclets.internal.toolkit.util.Extern;
import com.liferay.tools.doclets.internal.toolkit.util.Group;
import com.liferay.tools.doclets.internal.toolkit.util.MessageRetriever;
import com.liferay.tools.doclets.internal.toolkit.util.MetaKeywords;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class Configuration {
    protected BuilderFactory builderFactory;
    public TagletManager tagletManager;
    public String builderXMLPath;
    private static final String DEFAULT_BUILDER_XML = "resources/doclet.xml";
    public String tagletpath = "";
    public boolean serialwarn = false;
    public int sourcetab = 8;
    public boolean linksource = false;
    public boolean nosince = false;
    public boolean copydocfilesubdirs = false;
    public String charset = "";
    public boolean keywords = false;
    public final MetaKeywords metakeywords = MetaKeywords.getInstance(this);
    protected Set excludedDocFileDirs;
    protected Set excludedQualifiers;
    public RootDoc root;
    public String destDirName = "";
    public String docFileDestDirName = "";
    public String docencoding = null;
    public boolean nocomment = false;
    public String encoding = null;
    public boolean showauthor = false;
    public boolean showversion = false;
    public String sourcepath = "";
    public boolean nodeprecated = false;
    public ClassDocCatalog classDocCatalog;
    public MessageRetriever message = null;
    public boolean notimestamp = false;
    public final Group group = Group.getInstance(this);
    public final Extern extern = new Extern(this);
    public PackageDoc[] packages;

    public abstract String getDocletSpecificBuildDate();

    public abstract void setSpecificDocletOptions(String[][] var1);

    public abstract MessageRetriever getDocletSpecificMsg();

    public Configuration() {
        this.message = new MessageRetriever(this, "com.liferay.tools.doclets.internal.toolkit.resources.doclets");
        this.excludedDocFileDirs = new HashSet();
        this.excludedQualifiers = new HashSet();
    }

    public BuilderFactory getBuilderFactory() {
        if (this.builderFactory == null) {
            this.builderFactory = new BuilderFactory(this);
        }
        return this.builderFactory;
    }

    public int optionLength(String option) {
        if ((option = option.toLowerCase()).equals("-author") || option.equals("-docfilessubdirs") || option.equals("-keywords") || option.equals("-linksource") || option.equals("-nocomment") || option.equals("-nodeprecated") || option.equals("-nosince") || option.equals("-notimestamp") || option.equals("-quiet") || option.equals("-xnodate") || option.equals("-version")) {
            return 1;
        }
        if (option.equals("-d") || option.equals("-docencoding") || option.equals("-encoding") || option.equals("-excludedocfilessubdir") || option.equals("-link") || option.equals("-sourcetab") || option.equals("-noqualifier") || option.equals("-output") || option.equals("-sourcepath") || option.equals("-tag") || option.equals("-taglet") || option.equals("-tagletpath")) {
            return 2;
        }
        if (option.equals("-group") || option.equals("-linkoffline")) {
            return 3;
        }
        return -1;
    }

    public abstract boolean validOptions(String[][] var1, DocErrorReporter var2);

    private void initPackageArray() {
        HashSet<PackageDoc> set = new HashSet<PackageDoc>(Arrays.asList(this.root.specifiedPackages()));
        ClassDoc[] classes = this.root.specifiedClasses();
        for (int i = 0; i < classes.length; ++i) {
            set.add(classes[i].containingPackage());
        }
        ArrayList<PackageDoc> results = new ArrayList<PackageDoc>(set);
        Collections.sort(results);
        this.packages = results.toArray(new PackageDoc[0]);
    }

    public void setOptions(String[][] options) {
        LinkedHashSet<String[]> customTagStrs = new LinkedHashSet<String[]>();
        for (int oi = 0; oi < options.length; ++oi) {
            String url;
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-d")) {
                this.docFileDestDirName = this.destDirName = this.addTrailingFileSep(os[1]);
                continue;
            }
            if (opt.equals("-docfilessubdirs")) {
                this.copydocfilesubdirs = true;
                continue;
            }
            if (opt.equals("-docencoding")) {
                this.docencoding = os[1];
                continue;
            }
            if (opt.equals("-encoding")) {
                this.encoding = os[1];
                continue;
            }
            if (opt.equals("-author")) {
                this.showauthor = true;
                continue;
            }
            if (opt.equals("-version")) {
                this.showversion = true;
                continue;
            }
            if (opt.equals("-nodeprecated")) {
                this.nodeprecated = true;
                continue;
            }
            if (opt.equals("-sourcepath")) {
                this.sourcepath = os[1];
                continue;
            }
            if (opt.equals("-classpath") && this.sourcepath.length() == 0) {
                this.sourcepath = os[1];
                continue;
            }
            if (opt.equals("-excludedocfilessubdir")) {
                this.addToSet(this.excludedDocFileDirs, os[1]);
                continue;
            }
            if (opt.equals("-noqualifier")) {
                this.addToSet(this.excludedQualifiers, os[1]);
                continue;
            }
            if (opt.equals("-linksource")) {
                this.linksource = true;
                continue;
            }
            if (opt.equals("-sourcetab")) {
                this.linksource = true;
                try {
                    this.sourcetab = Integer.parseInt(os[1]);
                }
                catch (NumberFormatException e) {
                    this.sourcetab = -1;
                }
                if (this.sourcetab > 0) continue;
                this.message.warning("doclet.sourcetab_warning");
                this.sourcetab = 8;
                continue;
            }
            if (opt.equals("-notimestamp")) {
                this.notimestamp = true;
                continue;
            }
            if (opt.equals("-nocomment")) {
                this.nocomment = true;
                continue;
            }
            if (opt.equals("-tag") || opt.equals("-taglet")) {
                customTagStrs.add(os);
                continue;
            }
            if (opt.equals("-tagletpath")) {
                this.tagletpath = os[1];
                continue;
            }
            if (opt.equals("-keywords")) {
                this.keywords = true;
                continue;
            }
            if (opt.equals("-serialwarn")) {
                this.serialwarn = true;
                continue;
            }
            if (opt.equals("-group")) {
                this.group.checkPackageGroups(os[1], os[2]);
                continue;
            }
            if (opt.equals("-link")) {
                url = os[1];
                this.extern.url(url, url, (DocErrorReporter)this.root, false);
                continue;
            }
            if (!opt.equals("-linkoffline")) continue;
            url = os[1];
            String pkglisturl = os[2];
            this.extern.url(url, pkglisturl, (DocErrorReporter)this.root, true);
        }
        if (this.sourcepath.length() == 0) {
            String string = this.sourcepath = System.getProperty("env.class.path") == null ? "" : System.getProperty("env.class.path");
        }
        if (this.docencoding == null) {
            this.docencoding = this.encoding;
        }
        this.classDocCatalog = new ClassDocCatalog(this.root.specifiedClasses());
        this.initTagletManager(customTagStrs);
    }

    public void setOptions() {
        this.initPackageArray();
        this.setOptions(this.root.options());
        this.setSpecificDocletOptions(this.root.options());
    }

    private void initTagletManager(Set customTagStrs) {
        this.tagletManager = this.tagletManager == null ? new TagletManager(this.nosince, this.showversion, this.showauthor, this.message) : this.tagletManager;
        for (String[] args : customTagStrs) {
            if (args[0].equals("-taglet")) {
                this.tagletManager.addCustomTag(args[1], this.tagletpath);
                continue;
            }
            String[] tokens = Util.tokenize(args[1], ':', 3);
            if (tokens.length == 1) {
                String tagName = args[1];
                if (this.tagletManager.isKnownCustomTag(tagName)) {
                    this.tagletManager.addNewSimpleCustomTag(tagName, null, "");
                    continue;
                }
                StringBuffer heading = new StringBuffer(tagName + ":");
                heading.setCharAt(0, Character.toUpperCase(tagName.charAt(0)));
                this.tagletManager.addNewSimpleCustomTag(tagName, heading.toString(), "a");
                continue;
            }
            if (tokens.length == 2) {
                this.tagletManager.addNewSimpleCustomTag(tokens[0], tokens[1], "");
                continue;
            }
            if (tokens.length >= 3) {
                this.tagletManager.addNewSimpleCustomTag(tokens[0], tokens[2], tokens[1]);
                continue;
            }
            this.message.error("doclet.Error_invalid_custom_tag_argument", args[1]);
        }
    }

    private void addToSet(Set s, String str) {
        StringTokenizer st = new StringTokenizer(str, ":");
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            s.add(current);
        }
    }

    String addTrailingFileSep(String path) {
        int indexDblfs;
        String fs = System.getProperty("file.separator");
        String dblfs = fs + fs;
        while ((indexDblfs = path.indexOf(dblfs)) >= 0) {
            path = path.substring(0, indexDblfs) + path.substring(indexDblfs + fs.length());
        }
        if (!path.endsWith(fs)) {
            path = path + fs;
        }
        return path;
    }

    public boolean generalValidOptions(String[][] options, DocErrorReporter reporter) {
        boolean docencodingfound = false;
        String encoding = "";
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-d")) {
                String destdirname = this.addTrailingFileSep(os[1]);
                File destDir = new File(destdirname);
                if (!destDir.exists()) {
                    reporter.printNotice(this.getText("doclet.dest_dir_create", destdirname));
                    new File(destdirname).mkdirs();
                    continue;
                }
                if (!destDir.isDirectory()) {
                    reporter.printError(this.getText("doclet.destination_directory_not_directory_0", destDir.getPath()));
                    return false;
                }
                if (destDir.canWrite()) continue;
                reporter.printError(this.getText("doclet.destination_directory_not_writable_0", destDir.getPath()));
                return false;
            }
            if (opt.equals("-docencoding")) {
                docencodingfound = true;
                if (this.checkOutputFileEncoding(os[1], reporter)) continue;
                return false;
            }
            if (!opt.equals("-encoding")) continue;
            encoding = os[1];
        }
        return docencodingfound || encoding.length() <= 0 || this.checkOutputFileEncoding(encoding, reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOutputFileEncoding(String docencoding, DocErrorReporter reporter) {
        ByteArrayOutputStream ost = new ByteArrayOutputStream();
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)ost, docencoding);
        }
        catch (UnsupportedEncodingException exc) {
            reporter.printError(this.getText("doclet.Encoding_not_supported", docencoding));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException exc) {}
        }
        return true;
    }

    public boolean shouldExcludeDocFileDir(String docfilesubdir) {
        return this.excludedDocFileDirs.contains(docfilesubdir);
    }

    public boolean shouldExcludeQualifier(String qualifier) {
        if (this.excludedQualifiers.contains("all") || this.excludedQualifiers.contains(qualifier) || this.excludedQualifiers.contains(qualifier + ".*")) {
            return true;
        }
        int index = -1;
        while ((index = qualifier.indexOf(".", index + 1)) != -1) {
            if (!this.excludedQualifiers.contains(qualifier.substring(0, index + 1) + "*")) continue;
            return true;
        }
        return false;
    }

    public String getClassName(ClassDoc cd) {
        PackageDoc pd = cd.containingPackage();
        if (pd != null && this.shouldExcludeQualifier(cd.containingPackage().name())) {
            return cd.name();
        }
        return cd.qualifiedName();
    }

    public String getText(String key) {
        try {
            return this.getDocletSpecificMsg().getText(key);
        }
        catch (Exception e) {
            return this.message.getText(key);
        }
    }

    public String getText(String key, String a1) {
        try {
            return this.getDocletSpecificMsg().getText(key, a1);
        }
        catch (Exception e) {
            return this.message.getText(key, a1);
        }
    }

    public String getText(String key, String a1, String a2) {
        try {
            return this.getDocletSpecificMsg().getText(key, a1, a2);
        }
        catch (Exception e) {
            return this.message.getText(key, a1, a2);
        }
    }

    public String getText(String key, String a1, String a2, String a3) {
        try {
            return this.getDocletSpecificMsg().getText(key, a1, a2, a3);
        }
        catch (Exception e) {
            return this.message.getText(key, a1, a2, a3);
        }
    }

    public boolean isGeneratedDoc(Doc doc) {
        if (!this.nodeprecated) {
            return true;
        }
        return doc.tags("deprecated").length == 0;
    }

    public abstract WriterFactory getWriterFactory();

    public InputStream getBuilderXML() throws FileNotFoundException {
        return this.builderXMLPath == null ? Configuration.class.getResourceAsStream(DEFAULT_BUILDER_XML) : new FileInputStream(new File(this.builderXMLPath));
    }

    public abstract Comparator getMemberComparator();
}

