/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.builders;

import com.liferay.tools.doclets.internal.toolkit.ClassWriter;
import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.liferay.tools.doclets.internal.toolkit.builders.LayoutParser;
import com.liferay.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ClassBuilder
extends AbstractBuilder {
    public static final String ROOT = "ClassDoc";
    private ClassDoc classDoc;
    private ClassWriter writer;
    private boolean isInterface = false;
    private boolean isEnum = false;

    private ClassBuilder(Configuration configuration) {
        super(configuration);
    }

    public static ClassBuilder getInstance(Configuration configuration, ClassDoc classDoc, ClassWriter writer) throws Exception {
        ClassBuilder builder = new ClassBuilder(configuration);
        builder.configuration = configuration;
        builder.classDoc = classDoc;
        builder.writer = writer;
        if (classDoc.isInterface()) {
            builder.isInterface = true;
        } else if (classDoc.isEnum()) {
            builder.isEnum = true;
            Util.setEnumDocumentation(configuration, classDoc);
        }
        if (containingPackagesSeen == null) {
            containingPackagesSeen = new HashSet();
        }
        return builder;
    }

    public void invokeMethod(String methodName, Class[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }

    public void build() throws IOException {
        this.build(LayoutParser.getInstance(this.configuration).parseXML(ROOT));
    }

    public String getName() {
        return ROOT;
    }

    public void buildClassDoc(List elements) throws Exception {
        this.build(elements);
        this.writer.close();
        this.copyDocFiles();
    }

    private void copyDocFiles() {
        PackageDoc containingPackage = this.classDoc.containingPackage();
        if (!(this.configuration.packages != null && Arrays.binarySearch(this.configuration.packages, containingPackage) >= 0 || containingPackagesSeen.contains(containingPackage.name()))) {
            Util.copyDocFiles(this.configuration, Util.getPackageSourcePath(this.configuration, this.classDoc.containingPackage()) + DirectoryManager.getDirectoryPath(this.classDoc.containingPackage()) + File.separator, "doc-files", true);
            containingPackagesSeen.add(containingPackage.name());
        }
    }

    public void buildClassHeader() {
        String key = this.isInterface ? "doclet.Interface" : (this.isEnum ? "doclet.Enum" : "doclet.Class");
        this.writer.writeHeader(this.configuration.getText(key) + " " + this.classDoc.name());
    }

    public void buildClassTree() {
        this.writer.writeClassTree();
    }

    public void buildImplementedInterfacesInfo() {
        this.writer.writeImplementedInterfacesInfo();
    }

    public void buildSuperInterfacesInfo() {
        this.writer.writeSuperInterfacesInfo();
    }

    public void buildTypeParamInfo() {
        this.writer.writeTypeParamInfo();
    }

    public void buildSubClassInfo() {
        this.writer.writeSubClassInfo();
    }

    public void buildSubInterfacesInfo() {
        this.writer.writeSubInterfacesInfo();
    }

    public void buildInterfaceUsageInfo() {
        this.writer.writeInterfaceUsageInfo();
    }

    public void buildNestedClassInfo() {
        this.writer.writeNestedClassInfo();
    }

    public void buildDeprecationInfo() {
        this.writer.writeClassDeprecationInfo();
    }

    public void buildClassSignature() {
        StringBuffer modifiers = new StringBuffer(this.classDoc.modifiers() + " ");
        if (this.isEnum) {
            modifiers.append("enum ");
            int index = modifiers.indexOf("abstract");
            if (index >= 0) {
                modifiers.delete(index, index + new String("abstract").length());
                modifiers = new StringBuffer(Util.replaceText(modifiers.toString(), "  ", " "));
            }
            if ((index = modifiers.indexOf("final")) >= 0) {
                modifiers.delete(index, index + new String("final").length());
                modifiers = new StringBuffer(Util.replaceText(modifiers.toString(), "  ", " "));
            }
        } else if (!this.isInterface) {
            modifiers.append("class ");
        }
        this.writer.writeClassSignature(modifiers.toString());
    }

    public void buildClassDescription() {
        this.writer.writeClassDescription();
    }

    public void buildClassTagInfo() {
        this.writer.writeClassTagInfo();
    }

    public void buildMemberSummary(List elements) throws Exception {
        this.configuration.getBuilderFactory().getMemberSummaryBuilder(this.writer).build(elements);
        this.writer.completeMemberSummaryBuild();
    }

    public void buildEnumConstantsDetails(List elements) throws Exception {
        this.configuration.getBuilderFactory().getEnumConstantsBuilder(this.writer).build(elements);
    }

    public void buildFieldDetails(List elements) throws Exception {
        this.configuration.getBuilderFactory().getFieldBuilder(this.writer).build(elements);
    }

    public void buildConstructorDetails(List elements) throws Exception {
        this.configuration.getBuilderFactory().getConstructorBuilder(this.writer).build(elements);
    }

    public void buildMethodDetails(List elements) throws Exception {
        this.configuration.getBuilderFactory().getMethodBuilder(this.writer).build(elements);
    }

    public void buildClassFooter() {
        this.writer.writeFooter();
    }
}

