/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.util;

import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DeprecatedAPIListBuilder {
    public static final int NUM_TYPES = 11;
    public static final int INTERFACE = 0;
    public static final int CLASS = 1;
    public static final int ENUM = 2;
    public static final int EXCEPTION = 3;
    public static final int ERROR = 4;
    public static final int ANNOTATION_TYPE = 5;
    public static final int FIELD = 6;
    public static final int METHOD = 7;
    public static final int CONSTRUCTOR = 8;
    public static final int ENUM_CONSTANT = 9;
    public static final int ANNOTATION_TYPE_MEMBER = 10;
    private List deprecatedLists = new ArrayList();

    public DeprecatedAPIListBuilder(RootDoc root) {
        for (int i = 0; i < 11; ++i) {
            this.deprecatedLists.add(i, new ArrayList());
        }
        this.buildDeprecatedAPIInfo(root);
    }

    private void buildDeprecatedAPIInfo(RootDoc root) {
        ClassDoc[] classes = root.classes();
        for (int i = 0; i < classes.length; ++i) {
            ClassDoc cd = classes[i];
            if (Util.isDeprecated((ProgramElementDoc)cd)) {
                if (cd.isOrdinaryClass()) {
                    this.getList(1).add(cd);
                } else if (cd.isInterface()) {
                    this.getList(0).add(cd);
                } else if (cd.isException()) {
                    this.getList(3).add(cd);
                } else if (cd.isEnum()) {
                    this.getList(2).add(cd);
                } else if (cd.isError()) {
                    this.getList(4).add(cd);
                } else if (cd.isAnnotationType()) {
                    this.getList(5).add(cd);
                }
            }
            this.composeDeprecatedList(this.getList(6), (MemberDoc[])cd.fields());
            this.composeDeprecatedList(this.getList(7), (MemberDoc[])cd.methods());
            this.composeDeprecatedList(this.getList(8), (MemberDoc[])cd.constructors());
            if (cd.isEnum()) {
                this.composeDeprecatedList(this.getList(9), (MemberDoc[])cd.enumConstants());
            }
            if (!cd.isAnnotationType()) continue;
            this.composeDeprecatedList(this.getList(10), (MemberDoc[])((AnnotationTypeDoc)cd).elements());
        }
        this.sortDeprecatedLists();
    }

    private void composeDeprecatedList(List list, MemberDoc[] members) {
        for (int i = 0; i < members.length; ++i) {
            if (!Util.isDeprecated((ProgramElementDoc)members[i])) continue;
            list.add(members[i]);
        }
    }

    private void sortDeprecatedLists() {
        for (int i = 0; i < 11; ++i) {
            Collections.sort(this.getList(i));
        }
    }

    public List getList(int type) {
        return (List)this.deprecatedLists.get(type);
    }

    public boolean hasDocumentation(int type) {
        return ((List)this.deprecatedLists.get(type)).size() > 0;
    }
}

