/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.app;

import ise.antelope.app.jedit.SyntaxStyle;
import ise.library.KappaLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class StyleEditor
extends JDialog {
    private JCheckBox italic_cb;
    private JCheckBox bold_cb;
    private JButton text_color_btn;
    private JButton ok_btn;
    private JButton cancel_btn;
    private SyntaxStyle style = null;

    public StyleEditor(JDialog jDialog, SyntaxStyle syntaxStyle) {
        super(jDialog);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("Set Style");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new KappaLayout());
        this.setContentPane(jPanel);
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.italic_cb = new JCheckBox("Italic");
        this.italic_cb.setSelected(syntaxStyle.isItalic());
        this.bold_cb = new JCheckBox("Bold");
        this.bold_cb.setSelected(syntaxStyle.isBold());
        JLabel jLabel = new JLabel("Text color:");
        this.text_color_btn = new JButton();
        this.text_color_btn.setBackground(syntaxStyle.getColor());
        this.ok_btn = new JButton("OK");
        this.cancel_btn = new JButton("Cancel");
        jPanel.add((Component)this.italic_cb, "0, 0, 3, 1, W, , 3");
        jPanel.add((Component)this.bold_cb, "0, 1, 3, 1, W, , 3");
        jPanel.add((Component)jLabel, "0, 2, 2, 1, W, , 3");
        jPanel.add((Component)this.text_color_btn, "2, 2, 1, 1, 0, wh, 3");
        jPanel.add(KappaLayout.createVerticalStrut(11), "0, 3");
        KappaLayout kappaLayout = new KappaLayout();
        JPanel jPanel2 = new JPanel(kappaLayout);
        jPanel2.add((Component)this.ok_btn, "0, 0, 1, 1, 0, wh, 3");
        jPanel2.add((Component)this.cancel_btn, "1, 0, 1, 1, 0, wh, 3");
        kappaLayout.makeColumnsSameWidth(0, 1);
        jPanel.add((Component)jPanel2, "0, 4, 3, 1, 0, , 6");
        this.text_color_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(StyleEditor.this, "Pick Color", StyleEditor.this.text_color_btn.getBackground());
                if (color != null) {
                    StyleEditor.this.text_color_btn.setBackground(color);
                }
            }
        });
        this.ok_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.style = new SyntaxStyle(StyleEditor.this.text_color_btn.getBackground(), StyleEditor.this.italic_cb.isSelected(), StyleEditor.this.bold_cb.isSelected());
                StyleEditor.this.setVisible(false);
            }
        });
        this.cancel_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleEditor.this.style = null;
                StyleEditor.this.setVisible(false);
            }
        });
        this.pack();
        Rectangle rectangle = jDialog.getBounds();
        this.setLocation(rectangle.x + rectangle.width, rectangle.y);
        this.setVisible(true);
    }

    public SyntaxStyle getStyle() {
        return this.style;
    }
}

