/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import ise.antelope.common.AntFileHandler;
import ise.library.Log;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.StringUtils;

public class AntLogger
implements BuildLogger {
    private String targetIndent = "   ";
    private String taskIndent = this.targetIndent + this.targetIndent;
    private String msgIndent = this.taskIndent + this.targetIndent;
    private PrintStream systemOut;
    private PrintStream systemErr;
    private PrintStream out = null;
    private PrintStream err = null;
    private boolean echo = false;
    protected int msgOutputLevel = 2;
    private long startTime = System.currentTimeMillis();
    protected static final String lSep = System.getProperty("line.separator");
    public boolean SHOW_BUILD_EVENTS = true;
    public boolean SHOW_TARGET_EVENTS = false;
    public boolean SHOW_TASK_EVENTS = false;
    public boolean SHOW_LOG_MSGS = true;
    public static String NAMESPACE = "ise.antelope.Antelope";
    private Logger logger = Logger.getLogger(NAMESPACE);
    private AntFileHandler fileHandler = null;
    private Object[] parameters = new String[]{NAMESPACE};
    private boolean open = false;

    public AntLogger() {
        this(NAMESPACE);
    }

    public AntLogger(String string) {
        NAMESPACE = string;
        this.initLogger();
    }

    public void open() {
        if (!this.open) {
            this.systemOut = System.out;
            this.systemErr = System.err;
            PrintStream printStream = this.createPrintStream();
            PrintStream printStream2 = this.createPrintStream();
            System.setOut(printStream);
            System.setErr(printStream2);
            this.open = true;
        }
    }

    public void close() {
        if (!this.open) {
            return;
        }
        try {
            System.out.flush();
            System.err.flush();
            System.setOut(this.systemOut);
            System.setErr(this.systemErr);
            if (this.fileHandler != null) {
                this.fileHandler.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.open = false;
    }

    public void setMessageOutputLevel(int n) {
        this.msgOutputLevel = n;
    }

    public void setOutputPrintStream(PrintStream printStream) {
    }

    public void setErrorPrintStream(PrintStream printStream) {
    }

    public void setEmacsMode(boolean bl) {
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.handleProperties(buildEvent);
        this.open();
        this.log(" ");
        this.log(Level.CONFIG, "===== BUILD STARTED =====" + lSep);
        this.startTime = System.currentTimeMillis();
    }

    public void buildFinished(BuildEvent buildEvent) {
        Throwable throwable = buildEvent.getException();
        StringBuffer stringBuffer = new StringBuffer();
        if (throwable == null) {
            stringBuffer.append(lSep);
            stringBuffer.append("BUILD SUCCESSFUL");
            this.log(Level.WARNING, stringBuffer.toString());
        } else {
            stringBuffer.append(lSep);
            stringBuffer.append("BUILD FAILED");
            stringBuffer.append(lSep);
            if (3 <= this.msgOutputLevel || !(throwable instanceof BuildException)) {
                stringBuffer.append(StringUtils.getStackTrace((Throwable)throwable));
            } else if (throwable instanceof BuildException) {
                stringBuffer.append(throwable.toString()).append(lSep);
            } else {
                stringBuffer.append(throwable.getMessage()).append(lSep);
            }
            this.log(Level.SEVERE, stringBuffer.toString());
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append("Total time: ");
        stringBuffer.append(AntLogger.formatTime(System.currentTimeMillis() - this.startTime));
        stringBuffer.append(lSep);
        stringBuffer.append("===== BUILD FINISHED =====").append(lSep);
        stringBuffer.append(new Date().toString()).append(lSep);
        String string = stringBuffer.toString();
        this.log(Level.CONFIG, string);
        this.close();
    }

    public void targetStarted(BuildEvent buildEvent) {
        this.handleProperties(buildEvent);
        if (this.SHOW_TARGET_EVENTS) {
            String string = this.targetIndent + "<" + buildEvent.getTarget().getName() + "> ";
            this.log(Level.CONFIG, string);
        }
        this.messageLogged(buildEvent);
    }

    public void targetFinished(BuildEvent buildEvent) {
        if (this.SHOW_TARGET_EVENTS) {
            String string = this.targetIndent + "</" + buildEvent.getTarget().getName() + "> ";
            this.log(Level.CONFIG, string);
        }
        this.messageLogged(buildEvent);
    }

    public void taskStarted(BuildEvent buildEvent) {
        if (this.SHOW_TASK_EVENTS) {
            String string = this.taskIndent + "<" + buildEvent.getTask().getTaskName() + "> ";
            this.log(Level.CONFIG, string);
        }
        this.messageLogged(buildEvent);
    }

    public void taskFinished(BuildEvent buildEvent) {
        if (this.SHOW_TASK_EVENTS) {
            String string = this.taskIndent + "</" + buildEvent.getTask().getTaskName() + "> ";
            this.log(Level.CONFIG, string);
        }
        this.messageLogged(buildEvent);
    }

    public void messageLogged(BuildEvent buildEvent) {
        int n;
        String string = buildEvent.getMessage();
        if (string == null || string.length() == 0) {
            string = "";
        }
        if (this.SHOW_LOG_MSGS && (n = buildEvent.getPriority()) <= this.msgOutputLevel) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.msgIndent);
            stringBuffer.append(string);
            this.log(stringBuffer.toString());
        }
    }

    protected static String formatTime(long l) {
        return DateUtils.formatElapsedTime((long)l);
    }

    protected void log(Level level, String string) {
        if (string == null) {
            string = "";
        }
        Log.log((Object)this, string);
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setParameters(this.parameters);
        this.logger.log(logRecord);
        if (this.echo) {
            // empty if block
        }
    }

    protected void log(String string) {
        this.log(Level.INFO, string);
    }

    public void setEcho(boolean bl) {
        this.echo = bl;
    }

    public boolean getEcho() {
        return this.echo;
    }

    private void initLogger() {
        this.logger = Logger.getLogger(NAMESPACE);
        this.logger.setUseParentHandlers(false);
        this.removeAllLogHandlers();
        this.logger.setLevel(Level.ALL);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        consoleHandler.setFormatter(new PlainFormatter());
        this.logger.addHandler(consoleHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllLogHandlers() {
        if (this.logger == null) {
            return;
        }
        Logger logger = this.logger;
        synchronized (logger) {
            Handler[] handlerArray = this.logger.getHandlers();
            for (int i = 0; i < handlerArray.length; ++i) {
                this.logger.removeHandler(handlerArray[i]);
            }
        }
    }

    private void handleProperties(BuildEvent buildEvent) {
        String string = buildEvent.getProject().getProperty("antlogger.echo");
        if (string == null) {
            string = System.getProperty("antlogger.echo");
        }
        if (string != null) {
            this.setEcho(Project.toBoolean((String)string.toString()));
        }
        if ((string = buildEvent.getProject().getProperty("antlogger.file")) == null) {
            string = System.getProperty("antlogger.file");
        }
        if (string != null) {
            if (this.fileHandler == null) {
                String string2 = string.toString();
                string = buildEvent.getProject().getProperty("antlogger.file.append");
                if (string == null) {
                    string = System.getProperty("antlogger.file.append");
                }
                boolean bl = false;
                if (string != null) {
                    bl = Project.toBoolean((String)string.toString());
                }
                try {
                    this.fileHandler = new AntFileHandler(new File(string2), bl);
                    this.fileHandler.setLevel(Level.ALL);
                    this.fileHandler.setFormatter(new PlainFormatter());
                    this.logger.addHandler(this.fileHandler);
                }
                catch (Exception exception) {}
            }
        } else if (this.fileHandler != null) {
            this.logger.removeHandler(this.fileHandler);
        }
    }

    private PrintStream createPrintStream() {
        PrintStream printStream = new PrintStream(new OutputStream(){
            StringBuffer line = new StringBuffer();

            public void write(int n) {
                byte[] byArray = new byte[]{(byte)n};
                this.write(byArray, 0, 1);
            }

            public void write(byte[] byArray, int n, int n2) {
                String string = new String(byArray, n, n2);
                AntLogger.this.log(string);
            }
        });
        return printStream;
    }

    public class PlainFormatter
    extends Formatter {
        public String format(LogRecord logRecord) {
            return logRecord.getMessage() + lSep;
        }
    }
}

