/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import ise.antelope.common.Constants;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.prefs.Preferences;

public class OptionSettings {
    private Preferences _prefs;
    private boolean _save_before_run = true;
    private boolean _show_all_targets = true;
    private boolean _show_targets_wo_desc = false;
    private boolean _show_targets_w_dot = false;
    private boolean _show_targets_w_dash = false;
    private boolean _sort_targets = true;
    private int _message_level = 2;
    private boolean _show_build_events = true;
    private boolean _show_target_events = false;
    private boolean _show_task_events = false;
    private boolean _show_log_messages = true;
    private boolean _use_error_parsing = true;
    private boolean _show_performance_output = false;
    private boolean _auto_reload = true;
    private boolean _show_button_text = false;
    private boolean _show_button_icon = true;
    private boolean _multiple_targets = false;
    private String _target_list = "";

    public OptionSettings(File file) {
        this.load(file);
    }

    public void load(File file) {
        this._show_button_text = Constants.PREFS.getBoolean("showButtonText", false);
        this._show_button_icon = Constants.PREFS.getBoolean("showButtonIcon", true);
        if (file != null) {
            int n = file.hashCode();
            this._prefs = Constants.PREFS.node(String.valueOf(n));
            this._save_before_run = this._prefs.getBoolean("saveBeforeRun", true);
            this._show_all_targets = this._prefs.getBoolean("showAllTargets", true);
            this._show_targets_wo_desc = this._prefs.getBoolean("showTargetsWODesc", false);
            this._show_targets_w_dot = this._prefs.getBoolean("showTargetsWDots", false);
            this._show_targets_w_dash = this._prefs.getBoolean("showTargetsWDash", false);
            this._sort_targets = this._prefs.getBoolean("sortTargets", true);
            this._message_level = this._prefs.getInt("msgLevel", 2);
            this._show_build_events = this._prefs.getBoolean("showBuildEvents", true);
            this._show_target_events = this._prefs.getBoolean("showTargetEvents", false);
            this._show_task_events = this._prefs.getBoolean("showTaskEvents", false);
            this._show_log_messages = this._prefs.getBoolean("showLogMsgs", true);
            this._use_error_parsing = this._prefs.getBoolean("useErrorParsing", true);
            this._show_performance_output = this._prefs.getBoolean("showPerformanceOutput", false);
            this._auto_reload = this._prefs.getBoolean("autoReload", true);
            this._multiple_targets = this._prefs.getBoolean("multipleTargets", false);
            this._target_list = this._prefs.get("targetList", "");
        }
    }

    public void save() {
        Constants.PREFS.putBoolean("showButtonText", this._show_button_text);
        Constants.PREFS.putBoolean("showButtonIcon", this._show_button_icon);
        if (this._prefs == null) {
            return;
        }
        this._prefs.putBoolean("saveBeforeRun", this._save_before_run);
        this._prefs.putInt("msgLevel", this._message_level);
        this._prefs.putBoolean("showBuildEvents", this._show_build_events);
        this._prefs.putBoolean("showLogMsgs", this._show_log_messages);
        this._prefs.putBoolean("showPerformanceOutput", this._show_performance_output);
        this._prefs.putBoolean("showTargetEvents", this._show_target_events);
        this._prefs.putBoolean("showAllTargets", this._show_all_targets);
        this._prefs.putBoolean("showTargetsWDash", this._show_targets_w_dash);
        this._prefs.putBoolean("showTargetsWDots", this._show_targets_w_dot);
        this._prefs.putBoolean("showTargetsWODesc", this._show_targets_wo_desc);
        this._prefs.putBoolean("sortTargets", this._sort_targets);
        this._prefs.putBoolean("showTaskEvents", this._show_task_events);
        this._prefs.putBoolean("useErrorParsing", this._use_error_parsing);
        this._prefs.putBoolean("autoReload", this._auto_reload);
        this._prefs.putBoolean("multipleTargets", this._multiple_targets);
        this._prefs.put("targetList", this._target_list);
    }

    public Preferences getPrefs() {
        return this._prefs;
    }

    public void setSaveBeforeRun(boolean bl) {
        this._save_before_run = bl;
    }

    public boolean getSaveBeforeRun() {
        return this._save_before_run;
    }

    public void setUseErrorParsing(boolean bl) {
        this._use_error_parsing = bl;
    }

    public void setShowPerformanceOutput(boolean bl) {
        this._show_performance_output = bl;
    }

    public boolean getUseErrorParsing() {
        return this._use_error_parsing;
    }

    public boolean getShowPerformanceOutput() {
        return this._show_performance_output;
    }

    public boolean getAutoReload() {
        return this._auto_reload;
    }

    public void setAutoReload(boolean bl) {
        this._auto_reload = bl;
    }

    public void setShowAllTargets(boolean bl) {
        this._show_all_targets = bl;
    }

    public boolean getShowAllTargets() {
        return this._show_all_targets;
    }

    public void setShowTargetsWODesc(boolean bl) {
        this._show_targets_wo_desc = bl;
    }

    public boolean getShowTargetsWODesc() {
        return this._show_targets_wo_desc;
    }

    public void setShowTargetsWDot(boolean bl) {
        this._show_targets_w_dot = bl;
    }

    public void setShowTargetsWDash(boolean bl) {
        this._show_targets_w_dash = bl;
    }

    public void setSortTargets(boolean bl) {
        this._sort_targets = bl;
    }

    public boolean getShowTargetsWDot() {
        return this._show_targets_w_dot;
    }

    public boolean getShowTargetsWDash() {
        return this._show_targets_w_dash;
    }

    public boolean getSortTargets() {
        return this._sort_targets;
    }

    public void setMessageOutputLevel(int n) {
        this._message_level = n;
    }

    public int getMessageOutputLevel() {
        return this._message_level;
    }

    public void setShowBuildEvents(boolean bl) {
        this._show_build_events = bl;
    }

    public boolean getShowBuildEvents() {
        return this._show_build_events;
    }

    public void setShowTargetEvents(boolean bl) {
        this._show_target_events = bl;
    }

    public boolean getShowTargetEvents() {
        return this._show_target_events;
    }

    public void setShowTaskEvents(boolean bl) {
        this._show_task_events = bl;
    }

    public boolean getShowTaskEvents() {
        return this._show_task_events;
    }

    public void setShowLogMessages(boolean bl) {
        this._show_log_messages = bl;
    }

    public boolean getShowLogMessages() {
        return this._show_log_messages;
    }

    public void setShowButtonText(boolean bl) {
        this._show_button_text = bl;
    }

    public boolean getShowButtonText() {
        return this._show_button_text;
    }

    public void setShowButtonIcon(boolean bl) {
        this._show_button_icon = bl;
    }

    public boolean getShowButtonIcon() {
        return this._show_button_icon;
    }

    public void setMultipleTargets(boolean bl) {
        this._multiple_targets = bl;
    }

    public boolean getMultipleTargets() {
        return this._multiple_targets;
    }

    public void setMultipleTargetList(ArrayList arrayList) {
        if (arrayList == null) {
            this._target_list = "";
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        this._target_list = stringBuffer.toString();
    }

    public ArrayList getMultipleTargetList() {
        if (this._target_list == null || this._target_list.equals("")) {
            return new ArrayList();
        }
        return new ArrayList<String>(Arrays.asList(this._target_list.split(",")));
    }
}

