/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import ise.antelope.common.CommonHelper;
import ise.antelope.common.SAXTreeCellRenderer;
import ise.antelope.common.SAXTreeModel;
import ise.antelope.common.SAXTreeNode;
import ise.library.GUIUtils;
import ise.library.LambdaLayout;
import ise.library.Nav;
import ise.library.Navable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.xml.sax.Attributes;

public class SAXPanel
extends JPanel
implements Navable {
    private JTree tree = null;
    private CommonHelper _helper;
    private Nav _nav;

    public SAXPanel(CommonHelper commonHelper) {
        this._helper = commonHelper;
        this.setLayout(new BorderLayout());
        try {
            this.tree = new JTree();
            this.tree.setCellRenderer(new SAXTreeCellRenderer());
            this.add((Component)new JScrollPane(this.tree), "Center");
            JCheckBox jCheckBox = new JCheckBox("Show Attributes");
            jCheckBox.setSelected(true);
            this.add((Component)jCheckBox, "South");
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    SAXTreeCellRenderer sAXTreeCellRenderer = (SAXTreeCellRenderer)SAXPanel.this.tree.getCellRenderer();
                    sAXTreeCellRenderer.setShowAttributes(jCheckBox.isSelected());
                    SAXPanel.this.tree.repaint();
                }
            });
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    JTree jTree;
                    TreePath treePath;
                    int n = mouseEvent.getClickCount();
                    boolean bl = mouseEvent.isMetaDown();
                    if (mouseEvent.getSource() instanceof JTree && (treePath = (jTree = (JTree)mouseEvent.getSource()).getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                        int n2 = jTree.getRowForPath(treePath);
                        Object object = treePath.getLastPathComponent();
                        if (object instanceof SAXTreeNode) {
                            SAXTreeNode sAXTreeNode = (SAXTreeNode)object;
                            if (sAXTreeNode.getFile() != null) {
                                SAXPanel.this._helper.openFile(sAXTreeNode.getFile());
                            }
                            SAXPanel.this._helper.actionPerformed(new ActionEvent(sAXTreeNode.getLocation(), 470226, ""));
                            SAXPanel.this._nav.update(sAXTreeNode.getLocation());
                        }
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        this.showPopup(mouseEvent);
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        this.showPopup(mouseEvent);
                    }
                }

                private void showPopup(MouseEvent mouseEvent) {
                    JTree jTree;
                    TreePath treePath;
                    if (mouseEvent.getSource().equals(SAXPanel.this.tree) && (treePath = (jTree = (JTree)mouseEvent.getSource()).getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                        int n = jTree.getRowForPath(treePath);
                        Object object = treePath.getLastPathComponent();
                        if (object instanceof SAXTreeNode) {
                            SAXTreeNode sAXTreeNode = (SAXTreeNode)object;
                            if (sAXTreeNode.isTarget()) {
                                TreeModel treeModel = SAXPanel.this.getDependencyModel(sAXTreeNode, (SAXTreeNode)sAXTreeNode.getRoot());
                                if (treeModel != null) {
                                    JPanel jPanel = new JPanel(new BorderLayout());
                                    JTree jTree2 = new JTree(treeModel);
                                    jTree2.addMouseListener(this);
                                    jTree2.setCellRenderer(new SAXTreeCellRenderer());
                                    for (int i = 0; i < jTree2.getRowCount(); ++i) {
                                        jTree2.expandRow(i);
                                    }
                                    jPanel.add(new JScrollPane(jTree2));
                                    final JDialog jDialog = new JDialog(GUIUtils.getRootJFrame(SAXPanel.this), "Dependency Tree", true);
                                    jDialog.getContentPane().add((Component)new JScrollPane(jPanel), "Center");
                                    JButton jButton = new JButton("Close");
                                    JPanel jPanel2 = new JPanel();
                                    jPanel2.add(jButton);
                                    jDialog.getContentPane().add((Component)jPanel2, "South");
                                    jButton.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent actionEvent) {
                                            jDialog.hide();
                                            jDialog.dispose();
                                        }
                                    });
                                    jDialog.pack();
                                    jDialog.setSize(300, 300);
                                    Point point = SAXPanel.this.getLocation();
                                    SwingUtilities.convertPointToScreen(point, SAXPanel.this);
                                    jDialog.setLocation(GUIUtils.getBestAnchorPoint(jDialog, point.x + mouseEvent.getX(), point.y + mouseEvent.getY()));
                                    jDialog.setVisible(true);
                                }
                                return;
                            }
                            String string = null;
                            if (sAXTreeNode.getName().equals("property")) {
                                string = sAXTreeNode.getAttributeValue("file");
                            } else if (sAXTreeNode.getName().equals("loadproperties")) {
                                string = sAXTreeNode.getAttributeValue("srcfile");
                            }
                            if (string == null) {
                                return;
                            }
                            try {
                                File file;
                                File file2 = new File(string);
                                if (!file2.exists()) {
                                    file = sAXTreeNode.getFile();
                                    if (file == null) {
                                        return;
                                    }
                                    file2 = new File(file.getParentFile(), string);
                                }
                                file = file2;
                                JPopupMenu jPopupMenu = new JPopupMenu();
                                JMenuItem jMenuItem = new JMenuItem("Open");
                                jPopupMenu.add(jMenuItem);
                                jMenuItem.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent actionEvent) {
                                        SAXPanel.this._helper.openFile(file);
                                    }
                                });
                                GUIUtils.showPopupMenu(jPopupMenu, SAXPanel.this, mouseEvent.getX(), mouseEvent.getY());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
            this.tree.addMouseListener(mouseAdapter);
            this._nav = new Nav(this);
            JPanel jPanel = new JPanel(new LambdaLayout());
            this.add((Component)jPanel, "South");
            jPanel.add((Component)jCheckBox, "0,0");
            jPanel.add((Component)this._nav, "1, 0");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SAXTreeModel getModel() {
        return (SAXTreeModel)this.tree.getModel();
    }

    public void setPosition(Object object) {
        if (object instanceof Point) {
            this._helper.actionPerformed(new ActionEvent(object, 470226, ""));
        }
    }

    public TreeModel getDependencyModel(String string) {
        SAXTreeNode sAXTreeNode = this.getTargetNode(string, (SAXTreeNode)this.tree.getModel().getRoot());
        return this.getDependencyModel(sAXTreeNode, (SAXTreeNode)this.tree.getModel().getRoot());
    }

    public TreeModel getDependencyModel(SAXTreeNode sAXTreeNode, SAXTreeNode sAXTreeNode2) {
        if (sAXTreeNode == null) {
            return null;
        }
        SAXTreeNode sAXTreeNode3 = (SAXTreeNode)sAXTreeNode.clone();
        sAXTreeNode3.setFile(sAXTreeNode.getFile());
        this.addDependentTargetNodes(sAXTreeNode3, sAXTreeNode2);
        this.addCalledTargetNodes(sAXTreeNode, sAXTreeNode3, sAXTreeNode2);
        return new DefaultTreeModel(sAXTreeNode3);
    }

    private void addCalledTargetNodes(SAXTreeNode sAXTreeNode, SAXTreeNode sAXTreeNode2, SAXTreeNode sAXTreeNode3) {
        SAXTreeNode[] sAXTreeNodeArray = this.getCalledTargetNodes(sAXTreeNode, sAXTreeNode3);
        if (sAXTreeNodeArray.length > 0) {
            SAXTreeNode sAXTreeNode4 = new SAXTreeNode("Calls", sAXTreeNode2.getLocation(), null, sAXTreeNode2.getFile());
            for (int i = 0; i < sAXTreeNodeArray.length; ++i) {
                sAXTreeNode4.add(sAXTreeNodeArray[i]);
            }
            sAXTreeNode2.add(sAXTreeNode4);
        }
    }

    private SAXTreeNode[] getCalledTargetNodes(SAXTreeNode sAXTreeNode, SAXTreeNode sAXTreeNode2) {
        Object object;
        int n = sAXTreeNode.getChildCount();
        ArrayList<SAXTreeNode> arrayList = new ArrayList<SAXTreeNode>();
        for (int i = 0; i < n; ++i) {
            Object object2;
            File file;
            Object object3;
            object = (SAXTreeNode)sAXTreeNode.getChildAt(i);
            String string = ((SAXTreeNode)object).getName();
            Attributes attributes = ((SAXTreeNode)object).getAttributes();
            if (string.equals("antcall") || string.equals("call") || string.equals("runtarget") || string.equals("antcallback")) {
                String string2;
                int n2 = attributes.getIndex("target");
                if (n2 == -1 || (object3 = this.getTargetNode(string2 = attributes.getValue("target"), sAXTreeNode2)) == null) continue;
                ((SAXTreeNode)object3).setCalled(true);
                arrayList.add((SAXTreeNode)object3);
                continue;
            }
            if (!string.equals("ant")) continue;
            String string3 = "build.xml";
            int n3 = attributes.getIndex("antfile");
            if (n3 > -1) {
                string3 = attributes.getValue("antfile");
            }
            object3 = sAXTreeNode.getFile() != null ? sAXTreeNode.getFile().getParent() : "";
            n3 = attributes.getIndex("dir");
            if (n3 > -1) {
                object3 = attributes.getValue("dir");
            }
            if (!(file = new File((String)object3, string3)).exists()) continue;
            SAXTreeNode sAXTreeNode3 = (SAXTreeNode)new SAXTreeModel(file).getRoot();
            String string4 = null;
            n3 = attributes.getIndex("target");
            if (n3 > -1) {
                string4 = attributes.getValue("target");
            } else {
                object2 = sAXTreeNode3.getAttributes();
                n3 = object2.getIndex("default");
                if (n3 > -1) {
                    string4 = object2.getValue("default");
                }
            }
            if (string4 == null) continue;
            object2 = this.getTargetNode(string4, sAXTreeNode3);
            SAXTreeNode sAXTreeNode4 = (SAXTreeNode)((DefaultMutableTreeNode)object2).clone();
            this.addDependentTargetNodes(sAXTreeNode4, sAXTreeNode2);
            this.addCalledTargetNodes((SAXTreeNode)object2, sAXTreeNode4, sAXTreeNode2);
            arrayList.add(sAXTreeNode4);
        }
        SAXTreeNode[] sAXTreeNodeArray = new SAXTreeNode[arrayList.size()];
        object = arrayList.iterator();
        int n4 = 0;
        while (object.hasNext()) {
            sAXTreeNodeArray[n4] = (SAXTreeNode)object.next();
            ++n4;
        }
        return sAXTreeNodeArray;
    }

    private void addDependentTargetNodes(SAXTreeNode sAXTreeNode, SAXTreeNode sAXTreeNode2) {
        SAXTreeNode sAXTreeNode3 = new SAXTreeNode("Depends on", sAXTreeNode.getLocation(), null, sAXTreeNode.getFile());
        SAXTreeNode[] sAXTreeNodeArray = this.getDependentTargetNodes(sAXTreeNode, sAXTreeNode2);
        for (int i = 0; i < sAXTreeNodeArray.length; ++i) {
            if (sAXTreeNodeArray[i] == null) continue;
            sAXTreeNode3.add(sAXTreeNodeArray[i]);
        }
        if (sAXTreeNode3.getChildCount() > 0) {
            sAXTreeNode.add(sAXTreeNode3);
        }
    }

    private SAXTreeNode getTargetNode(String string, SAXTreeNode sAXTreeNode) {
        if (string == null) {
            return null;
        }
        try {
            int n = sAXTreeNode.getChildCount();
            SAXTreeNode sAXTreeNode2 = null;
            for (int i = 0; i < n; ++i) {
                String string2;
                Attributes attributes;
                int n2;
                SAXTreeNode sAXTreeNode3 = (SAXTreeNode)sAXTreeNode.getChildAt(i);
                if (sAXTreeNode3.getName().equals("project") && sAXTreeNode2 == null && (n2 = (attributes = sAXTreeNode3.getAttributes()).getIndex("name")) > -1) {
                    string2 = attributes.getValue(n2);
                    int n3 = sAXTreeNode3.getChildCount();
                    for (int j = 0; j < n3; ++j) {
                        String string3;
                        SAXTreeNode sAXTreeNode4 = (SAXTreeNode)sAXTreeNode3.getChildAt(j);
                        if (!sAXTreeNode4.getName().equals("target") || (n2 = (attributes = sAXTreeNode4.getAttributes()).getIndex("name")) == -1) continue;
                        String string4 = attributes.getValue(n2);
                        if (!string.startsWith(string2) || !(string3 = string.substring(string2.length() + 1)).equals(string4)) continue;
                        sAXTreeNode2 = (SAXTreeNode)sAXTreeNode4.clone();
                        sAXTreeNode2.setImported(sAXTreeNode4.isImported());
                    }
                }
                if (!sAXTreeNode3.getName().equals("target") || (n2 = (attributes = sAXTreeNode3.getAttributes()).getIndex("name")) == -1 || !string.equals(string2 = attributes.getValue(n2))) continue;
                sAXTreeNode2 = (SAXTreeNode)sAXTreeNode3.clone();
                this.addDependentTargetNodes(sAXTreeNode2, sAXTreeNode);
                this.addCalledTargetNodes(sAXTreeNode3, sAXTreeNode2, sAXTreeNode);
                return sAXTreeNode2;
            }
            return sAXTreeNode2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private SAXTreeNode[] getDependentTargetNodes(SAXTreeNode sAXTreeNode, SAXTreeNode sAXTreeNode2) {
        Attributes attributes = sAXTreeNode.getAttributes();
        int n = attributes.getIndex("depends");
        if (n == -1) {
            return new SAXTreeNode[0];
        }
        String string = attributes.getValue(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        if (n2 <= 0) {
            return new SAXTreeNode[0];
        }
        SAXTreeNode[] sAXTreeNodeArray = new SAXTreeNode[n2];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            SAXTreeNode sAXTreeNode3;
            sAXTreeNodeArray[n3] = sAXTreeNode3 = this.getTargetNode(stringTokenizer.nextToken().trim(), sAXTreeNode2);
            ++n3;
        }
        return sAXTreeNodeArray;
    }

    public boolean shouldReload() {
        return ((SAXTreeModel)this.tree.getModel()).shouldReload();
    }

    public boolean openBuildFile(File file) {
        SAXTreeModel sAXTreeModel = new SAXTreeModel(file);
        this.tree.setModel(sAXTreeModel);
        sAXTreeModel.nodeChanged((TreeNode)sAXTreeModel.getRoot());
        this.tree.repaint();
        SAXTreeNode sAXTreeNode = (SAXTreeNode)sAXTreeModel.getRoot();
        if (sAXTreeNode == null) {
            return false;
        }
        if (sAXTreeNode.getName() == null) {
            return false;
        }
        return sAXTreeNode.getName().equals("project");
    }

    protected Map getTargets() {
        SAXTreeModel sAXTreeModel = (SAXTreeModel)this.tree.getModel();
        return sAXTreeModel.getTargets();
    }
}

