/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import ise.antelope.common.SAXTreeNode;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.xml.sax.Attributes;

public class SAXTreeCellRenderer
extends DefaultTreeCellRenderer {
    private boolean showAttributes = true;

    public SAXTreeCellRenderer() {
        this(true);
    }

    public SAXTreeCellRenderer(boolean bl) {
        this.showAttributes = bl;
    }

    public void setShowAttributes(boolean bl) {
        this.showAttributes = bl;
    }

    public boolean getShowAttributes() {
        return this.showAttributes;
    }

    private String getLabelText(SAXTreeNode sAXTreeNode) {
        if (sAXTreeNode != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Attributes attributes = sAXTreeNode.getAttributes();
            if (sAXTreeNode.isTarget() || sAXTreeNode.isProject()) {
                int n;
                stringBuffer.append("<html>");
                if (attributes != null) {
                    stringBuffer.append("<b>");
                    n = sAXTreeNode.isPrivate();
                    if (n != 0) {
                        stringBuffer.append("<i>");
                    }
                    stringBuffer.append(attributes.getValue(attributes.getIndex("name")));
                    if (n != 0) {
                        stringBuffer.append("</i>");
                    }
                    stringBuffer.append("</b>");
                }
                if (attributes != null && this.showAttributes) {
                    for (n = 0; n < attributes.getLength(); ++n) {
                        if (attributes.getQName(n).equals("name")) continue;
                        stringBuffer.append(" ");
                        stringBuffer.append(attributes.getQName(n));
                        stringBuffer.append("=\"");
                        stringBuffer.append(attributes.getValue(n));
                        stringBuffer.append("\"");
                    }
                }
                if (this.showAttributes && sAXTreeNode.isImported()) {
                    stringBuffer.append(" (imported from ").append(sAXTreeNode.getFile()).append(")");
                }
            } else {
                stringBuffer.append(sAXTreeNode.getName());
                if (attributes != null && this.showAttributes) {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        stringBuffer.append(" ");
                        stringBuffer.append(attributes.getQName(i));
                        stringBuffer.append("=\"");
                        stringBuffer.append(attributes.getValue(i));
                        stringBuffer.append("\"");
                    }
                }
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public ImageIcon getImageIcon(SAXTreeNode sAXTreeNode) {
        ImageIcon imageIcon = null;
        if (sAXTreeNode != null) {
            if (sAXTreeNode.isProject()) {
                String string = "";
                string = sAXTreeNode.isImported() ? "images/red_ant.gif" : "images/ant.gif";
                URL uRL = this.getClass().getClassLoader().getResource(string);
                if (uRL != null) {
                    imageIcon = new ImageIcon(uRL);
                }
            } else if (sAXTreeNode.isTarget()) {
                String string = "";
                string = sAXTreeNode.isImported() ? (sAXTreeNode.isDefaultTarget() ? "images/GreenRedTarget16.gif" : (sAXTreeNode.isPrivate() ? "images/GrayRedTarget16.gif" : "images/BlackRedTarget16.gif")) : (sAXTreeNode.isDefaultTarget() ? "images/GreenTarget16.gif" : (sAXTreeNode.isPrivate() ? "images/GrayTarget16.gif" : "images/Target16.gif"));
                URL uRL = this.getClass().getClassLoader().getResource(string);
                if (uRL != null) {
                    imageIcon = new ImageIcon(uRL);
                }
            } else if (sAXTreeNode.isTask()) {
                String string = "images/Wrench16.gif";
                URL uRL = this.getClass().getClassLoader().getResource(string);
                if (uRL != null) {
                    imageIcon = new ImageIcon(uRL);
                }
            }
        }
        return imageIcon;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        if (defaultMutableTreeNode != null && defaultMutableTreeNode instanceof SAXTreeNode) {
            jLabel.setText(this.getLabelText((SAXTreeNode)defaultMutableTreeNode));
            jLabel.setIcon(this.getImageIcon((SAXTreeNode)defaultMutableTreeNode));
        } else {
            jLabel.setText(object.toString());
        }
        return jLabel;
    }
}

