/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import ise.antelope.common.BuildFileException;
import ise.antelope.common.Constants;
import ise.antelope.common.SAXNodeHandler;
import ise.antelope.common.SAXTreeNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class SAXTreeModel
extends DefaultTreeModel {
    private File infile = null;
    private HashMap propertyFiles = null;
    private Logger _logger = Logger.getLogger("ise.antelope.Antelope");

    public SAXTreeModel(String string) {
        super(null);
        this.setRoot(this.load(string));
        try {
            this.validate();
        }
        catch (BuildFileException buildFileException) {
            this._logger.warning("Warning:" + Constants.NL + buildFileException.getMessage());
        }
    }

    public SAXTreeModel(File file) {
        super(null);
        this.setRoot(this.load(file));
        try {
            this.validate();
        }
        catch (BuildFileException buildFileException) {
            this._logger.warning("Warning:" + Constants.NL + buildFileException.getMessage());
        }
    }

    public SAXTreeNode load(String string) {
        try {
            StringReader stringReader = new StringReader(string);
            return this.load(stringReader);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>Error loading xml ").append("<p>");
            stringBuffer.append("The specific error is: ").append(exception.getMessage()).append("<p>");
            this._logger.severe(stringBuffer.toString());
            return null;
        }
    }

    public SAXTreeNode load(File file) {
        try {
            this.infile = file;
            FileReader fileReader = new FileReader(file);
            return this.load(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>Error loading build file: ").append(file.getAbsolutePath()).append("<br>");
            stringBuffer.append("file not found!");
            this._logger.severe(stringBuffer.toString());
            fileNotFoundException.printStackTrace();
            return null;
        }
        catch (SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>Error loading build file: ").append(file.getAbsolutePath()).append("<br>");
            stringBuffer.append("somewhere at or before line number: ").append(sAXParseException.getLineNumber()).append(", and column number: ").append(sAXParseException.getColumnNumber()).append("<p>");
            stringBuffer.append("The specific error is: ").append(sAXParseException.getMessage()).append("<p>");
            this._logger.severe(stringBuffer.toString());
            sAXParseException.printStackTrace();
            return null;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>Error loading build file: ").append(file.getAbsolutePath()).append("<br>");
            stringBuffer.append("The specific error is: ").append(exception.getMessage()).append("<p>");
            this._logger.severe(stringBuffer.toString());
            exception.printStackTrace();
            return null;
        }
    }

    private SAXTreeNode load(Reader reader) throws Exception {
        InputSource inputSource = new InputSource(reader);
        SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
        SAXNodeHandler sAXNodeHandler = new SAXNodeHandler(this.infile);
        sAXNodeHandler.setDocumentLocator(new LocatorImpl());
        sAXParser.parse(inputSource, (DefaultHandler)sAXNodeHandler);
        this.propertyFiles = sAXNodeHandler.getPropertyFiles();
        SAXTreeNode sAXTreeNode = sAXNodeHandler.getRoot();
        this.sort(sAXTreeNode);
        return sAXTreeNode;
    }

    private void sort(SAXTreeNode sAXTreeNode) {
        Object object;
        if (sAXTreeNode == null) {
            return;
        }
        if (sAXTreeNode.getChildCount() == 0) {
            return;
        }
        ArrayList<SAXTreeNode> arrayList = new ArrayList<SAXTreeNode>();
        Enumeration<TreeNode> enumeration = sAXTreeNode.children();
        while (enumeration.hasMoreElements()) {
            object = (SAXTreeNode)enumeration.nextElement();
            arrayList.add((SAXTreeNode)object);
        }
        Collections.sort(arrayList);
        sAXTreeNode.removeAllChildren();
        object = arrayList.iterator();
        while (object.hasNext()) {
            SAXTreeNode sAXTreeNode2 = (SAXTreeNode)object.next();
            sAXTreeNode.add(sAXTreeNode2);
            this.sort(sAXTreeNode2);
        }
    }

    public HashMap getPropertyFiles() {
        return this.propertyFiles;
    }

    public boolean shouldReload() {
        if (this.propertyFiles == null) {
            return false;
        }
        Iterator iterator = this.propertyFiles.keySet().iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            Long l = (Long)this.propertyFiles.get(file);
            if (l == null || l.longValue() == file.lastModified()) continue;
            return true;
        }
        return false;
    }

    public Map getTargets() {
        LinkedHashMap<String, SAXTreeNode> linkedHashMap = new LinkedHashMap<String, SAXTreeNode>();
        Enumeration<TreeNode> enumeration = ((SAXTreeNode)this.getRoot()).children();
        while (enumeration.hasMoreElements()) {
            SAXTreeNode sAXTreeNode = (SAXTreeNode)enumeration.nextElement();
            if (sAXTreeNode.isTarget()) {
                linkedHashMap.put(sAXTreeNode.getAttributeValue("name"), sAXTreeNode);
                continue;
            }
            if (!sAXTreeNode.isProject()) continue;
            this.addSubProjectTargets(sAXTreeNode, linkedHashMap);
        }
        return linkedHashMap;
    }

    private void addSubProjectTargets(SAXTreeNode sAXTreeNode, Map map) {
        Enumeration<TreeNode> enumeration = sAXTreeNode.children();
        String string = sAXTreeNode.getAttributeValue("name");
        if (string == null) {
            string = "";
        }
        while (enumeration.hasMoreElements()) {
            SAXTreeNode sAXTreeNode2 = (SAXTreeNode)enumeration.nextElement();
            if (sAXTreeNode2.isTarget()) {
                String string2 = this.getPQName(sAXTreeNode2);
                map.put(this.getPQName(sAXTreeNode2), sAXTreeNode2);
                continue;
            }
            if (!sAXTreeNode2.isProject()) continue;
            this.addSubProjectTargets(sAXTreeNode2, map);
        }
    }

    private void validate() throws BuildFileException {
        StringBuffer stringBuffer = new StringBuffer();
        Map map = this.getTargets();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SAXTreeNode sAXTreeNode = (SAXTreeNode)map.get(string);
            String string2 = sAXTreeNode.getAttributeValue("depends");
            if (string2 == null) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().trim();
                SAXTreeNode sAXTreeNode2 = (SAXTreeNode)map.get(string3);
                if (sAXTreeNode2 == null) {
                    String string4 = this.getPQName(sAXTreeNode);
                    string3 = string4.substring(0, string4.lastIndexOf(".") + 1) + string3;
                    sAXTreeNode2 = (SAXTreeNode)map.get(string3);
                }
                if (sAXTreeNode2 != null) continue;
                stringBuffer.append("Target \"").append(string).append("\" depends on non-existant target \"").append(string3).append("\".").append(Constants.NL);
            }
        }
        if (stringBuffer.length() > 0) {
            throw new BuildFileException(stringBuffer.toString());
        }
    }

    public String getPQName(SAXTreeNode sAXTreeNode) {
        if (sAXTreeNode.isProject()) {
            return sAXTreeNode.getAttributeValue("name");
        }
        if (sAXTreeNode.isTarget()) {
            String string = ((SAXTreeNode)sAXTreeNode.getParent()).getAttributeValue("name");
            return string + "." + sAXTreeNode.getAttributeValue("name");
        }
        String string = sAXTreeNode.getName();
        for (SAXTreeNode sAXTreeNode2 = (SAXTreeNode)sAXTreeNode.getParent(); sAXTreeNode2 != null; sAXTreeNode2 = (SAXTreeNode)sAXTreeNode2.getParent()) {
            if (sAXTreeNode2.isTarget()) {
                string = sAXTreeNode2.getAttributeValue("name") + "." + string;
                continue;
            }
            if (sAXTreeNode2.isProject()) {
                return sAXTreeNode2.getAttributeValue("name") + "." + string;
            }
            string = sAXTreeNode2.getName() + "." + string;
        }
        return string;
    }
}

