/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import ise.library.TableArray;
import java.awt.Point;
import java.io.File;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SAXTreeNode
extends DefaultMutableTreeNode
implements Cloneable,
Comparable {
    private String name;
    private Point location;
    private Attributes attributes;
    private File file = null;
    private boolean isImported = false;
    private boolean isCalled = false;
    private boolean isTask = false;
    private boolean isType = false;
    private boolean isTarget = false;
    private boolean isDefaultTarget = false;
    private boolean isProject = false;
    protected int ordinal = 3;
    public static int PROJECT = 1;
    public static int TARGET = 2;
    public static int TYPE = 3;
    public static int TASK = 4;

    public SAXTreeNode(String string, Point point, Attributes attributes) {
        this(string, point, attributes, null);
    }

    public SAXTreeNode(String string, Point point, Attributes attributes, File file) {
        super(string);
        this.name = string;
        this.location = point;
        if (attributes != null) {
            this.attributes = new AttributesImpl(attributes);
        }
        this.file = file;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public TableArray getAttributeTable() {
        TableArray tableArray = new TableArray();
        Attributes attributes = this.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            tableArray.put(0, i, attributes.getLocalName(i));
            tableArray.put(1, i, attributes.getQName(i));
            tableArray.put(2, i, attributes.getType(i));
            tableArray.put(3, i, attributes.getValue(i));
        }
        return tableArray;
    }

    public String getAttributeValue(String string) {
        if (this.attributes == null) {
            return null;
        }
        int n = this.attributes.getIndex(string);
        return n > -1 ? this.attributes.getValue(n) : null;
    }

    public Point getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrivate() {
        if (!this.isTarget()) {
            return false;
        }
        String string = this.getAttributeValue("name");
        if (string.indexOf(".") > 0) {
            return true;
        }
        if (string.startsWith("-")) {
            return true;
        }
        String string2 = this.getAttributeValue("description");
        return string2 == null || string2.equals("");
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setImported(boolean bl) {
        this.isImported = bl;
    }

    public boolean isImported() {
        return this.isImported;
    }

    public void setCalled(boolean bl) {
        this.isCalled = bl;
    }

    public boolean isCalled() {
        return this.isCalled;
    }

    public void setType(boolean bl) {
        this.isType = bl;
        this.ordinal = TYPE;
    }

    public boolean isType() {
        return this.isType;
    }

    public void setTask(boolean bl) {
        this.isTask = bl;
        this.ordinal = TASK;
    }

    public boolean isTask() {
        return this.isTask;
    }

    public void setTarget(boolean bl) {
        this.isTarget = bl;
        this.ordinal = TARGET;
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    public void setDefaultTarget(boolean bl) {
        this.isDefaultTarget = bl;
    }

    public boolean isDefaultTarget() {
        return this.isDefaultTarget;
    }

    public void setProject(boolean bl) {
        this.isProject = bl;
        this.ordinal = PROJECT;
    }

    public boolean isProject() {
        return this.isProject;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(this.getName()).append(";");
        if (this.getAttributes() != null) {
            stringBuffer.append(this.getAttributes().toString()).append(";");
        }
        if (this.getFile() != null) {
            stringBuffer.append(this.getFile().toString()).append(";");
        }
        stringBuffer.append(this.isImported() ? "imported;" : "not imported;");
        stringBuffer.append(this.isDefaultTarget() ? "default; " : "not default;");
        stringBuffer.append(this.isCalled() ? "called]" : "not called]");
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        String string;
        if (object == null) {
            return 1;
        }
        SAXTreeNode sAXTreeNode = (SAXTreeNode)object;
        int n = new Integer(this.ordinal).compareTo(new Integer(sAXTreeNode.ordinal));
        if (n != 0) {
            return n;
        }
        String string2 = this.getName();
        n = string2.compareTo(string = sAXTreeNode.getName());
        if (n != 0) {
            return n;
        }
        string2 = this.getAttributeValue("name") == null ? this.getName() : this.getAttributeValue("name");
        n = string2.compareTo(string = sAXTreeNode.getAttributeValue("name") == null ? sAXTreeNode.getName() : sAXTreeNode.getAttributeValue("name"));
        if (n != 0) {
            return n;
        }
        return this.toString().compareTo(sAXTreeNode.toString());
    }
}

