/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class HostnameTask
extends Task {
    private String property = "hostname";
    private boolean useIp = false;
    private String host = null;
    private String nIC = null;
    private boolean failOnError = false;
    private boolean showAll = false;
    private boolean canonical = true;
    private int outputType = 0;
    public static final int HOST = 0;
    public static final int IP = 1;
    public static final int CANON = 2;

    public void setProperty(String string) {
        this.property = string;
    }

    public void setShowip(boolean bl) {
        this.useIp = bl;
        this.outputType = 1;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void setNic(String string) {
        this.nIC = string;
    }

    public void setShowall(boolean bl) {
        this.showAll = bl;
    }

    public void setShowcanonical(boolean bl) {
        this.canonical = bl;
        this.outputType = 2;
    }

    public void execute() {
        try {
            if (this.showAll) {
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    stringBuffer.append(networkInterface.getName() + ":");
                    Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        InetAddress inetAddress = enumeration2.nextElement();
                        String string = this.getAddress(inetAddress);
                        if (string != null && string.trim().length() > 0) {
                            stringBuffer.append(string);
                        }
                        if (!enumeration2.hasMoreElements()) continue;
                        stringBuffer.append(", ");
                    }
                    if (!enumeration.hasMoreElements()) continue;
                    stringBuffer.append(", ");
                }
                this.getProject().setProperty(this.property, stringBuffer.toString());
            } else if (this.nIC != null) {
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    if (!this.nIC.equals(networkInterface.getName())) continue;
                    stringBuffer.append(networkInterface.getName() + ":");
                    Enumeration<InetAddress> enumeration3 = networkInterface.getInetAddresses();
                    while (enumeration3.hasMoreElements()) {
                        InetAddress inetAddress = enumeration3.nextElement();
                        String string = this.getAddress(inetAddress);
                        if (string != null && string.trim().length() > 0) {
                            stringBuffer.append(string);
                        }
                        if (!enumeration3.hasMoreElements()) continue;
                        stringBuffer.append(", ");
                    }
                }
                this.getProject().setProperty(this.property, stringBuffer.toString());
            } else {
                InetAddress inetAddress = InetAddress.getLocalHost();
                String string = this.getAddress(inetAddress);
                this.getProject().setProperty(this.property, string);
            }
        }
        catch (IOException iOException) {
            if (this.failOnError) {
                throw new BuildException(iOException.getMessage());
            }
            this.log(iOException.getMessage());
        }
    }

    private String getAddress(InetAddress inetAddress) {
        String string = "";
        switch (this.outputType) {
            case 1: {
                string = inetAddress.getHostAddress();
                break;
            }
            case 2: {
                string = inetAddress.getCanonicalHostName();
                break;
            }
            default: {
                string = inetAddress.getHostName();
            }
        }
        return string;
    }
}

