/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.BooleanConditionTask;
import ise.antelope.tasks.typedefs.TimeUnit;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class Repeat
extends Task
implements TaskContainer {
    private Vector tasks = new Vector();
    private long repeatInterval = 10L;
    protected TimeUnit unit = TimeUnit.SECOND_UNIT;
    private String timeoutProperty = null;
    private String timeoutValue = "true";
    private boolean failOnError = false;
    private int repeatCount = 1;
    private BooleanConditionTask condition = null;

    public void addTask(Task task) throws BuildException {
        this.tasks.addElement(task);
    }

    public void addUntil(BooleanConditionTask booleanConditionTask) throws BuildException {
        if (this.condition != null) {
            throw new BuildException("Can only add one condition.");
        }
        this.condition = booleanConditionTask;
    }

    public void setInterval(int n) {
        this.repeatInterval = n;
    }

    public void setUnit(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("second")) {
            this.setRepeatunit(TimeUnit.SECOND_UNIT);
            return;
        }
        if (string.equals("millisecond")) {
            this.setRepeatunit(TimeUnit.MILLISECOND_UNIT);
            return;
        }
        if (string.equals("minute")) {
            this.setRepeatunit(TimeUnit.MINUTE_UNIT);
            return;
        }
        if (string.equals("hour")) {
            this.setRepeatunit(TimeUnit.HOUR_UNIT);
            return;
        }
        if (string.equals("day")) {
            this.setRepeatunit(TimeUnit.DAY_UNIT);
            return;
        }
        if (string.equals("week")) {
            this.setRepeatunit(TimeUnit.WEEK_UNIT);
            return;
        }
    }

    public void setMilliseconds(int n) {
        this.setInterval(n);
        this.setRepeatunit(TimeUnit.MILLISECOND_UNIT);
    }

    public void setSeconds(int n) {
        this.setInterval(n);
        this.setRepeatunit(TimeUnit.SECOND_UNIT);
    }

    public void setMinutes(int n) {
        this.setInterval(n);
        this.setRepeatunit(TimeUnit.MINUTE_UNIT);
    }

    public void setHours(int n) {
        this.setInterval(n);
        this.setRepeatunit(TimeUnit.HOUR_UNIT);
    }

    public void setDays(int n) {
        this.setInterval(n);
        this.setRepeatunit(TimeUnit.DAY_UNIT);
    }

    public void setWeeks(int n) {
        this.setInterval(n);
        this.setRepeatunit(TimeUnit.WEEK_UNIT);
    }

    public void setRepeatunit(TimeUnit timeUnit) {
        this.unit = timeUnit;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void setProperty(String string) {
        this.timeoutProperty = string;
    }

    public void setValue(String string) {
        this.timeoutValue = string;
    }

    public void setCount(int n) {
        this.repeatCount = n;
    }

    public void execute() throws BuildException {
        try {
            long l = this.repeatInterval * this.unit.getMultiplier();
            if (l <= 0L) {
                this.log("Interval is set to 0, will only execute tasks 1 time.");
                this.repeatCount = 1;
            }
            if (this.repeatCount >= 1) {
                for (int i = 0; i < this.repeatCount; ++i) {
                    this.repeatTasks();
                    if (this.condition == null || !this.condition.eval()) {
                        if (i + 1 >= this.repeatCount) continue;
                        Thread.currentThread();
                        Thread.sleep(l);
                        continue;
                    }
                    break;
                }
            } else if (this.repeatCount == -1) {
                while (true) {
                    this.repeatTasks();
                    if (this.condition == null || !this.condition.eval()) {
                        Thread.currentThread();
                        Thread.sleep(l);
                        continue;
                    }
                    break;
                }
            } else if (this.repeatCount != 0 && l == 0L) {
                this.repeatTasks();
            }
            if (this.timeoutProperty != null) {
                if (this.timeoutValue == null) {
                    this.timeoutValue = "true";
                }
                this.getProject().setUserProperty(this.timeoutProperty, this.timeoutValue);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new BuildException(interruptedException.getMessage());
        }
    }

    private void repeatTasks() throws BuildException {
        try {
            for (int i = 0; i < this.tasks.size(); ++i) {
                Task task = (Task)this.tasks.get(i);
                try {
                    task.perform();
                    continue;
                }
                catch (Exception exception) {
                    if (!this.failOnError) continue;
                    throw exception;
                }
            }
        }
        catch (Exception exception) {
            if (this.failOnError) {
                throw new BuildException(exception.getMessage());
            }
            this.log(exception.getMessage());
        }
    }
}

