/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.TestCase;
import ise.antelope.tasks.TestStatisticAccumulator;
import ise.library.ascii.MessageBox;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.types.FileSet;

public class Suite
extends Task
implements TaskContainer,
TestStatisticAccumulator {
    private String name = null;
    private Vector tasks = null;
    private Vector filesets = null;
    private int totalTestCount = 0;
    private int totalRanCount = 0;
    private int totalPassedCount = 0;
    private int totalFailedCount = 0;
    private int totalWarningCount = 0;
    private Vector failures = new Vector();
    private boolean showSummary = true;
    private boolean enabled = true;
    private boolean assertEnabled = true;
    private boolean failonerror = false;

    public void init() {
        super.init();
        this.setTaskName("suite");
    }

    public void addTestCase(TestCase testCase) {
        this.addTask(testCase);
    }

    public void addSuite(Suite suite) {
        this.addTask(suite);
    }

    public void addTask(Task task) {
        if (this.tasks == null) {
            this.tasks = new Vector();
        }
        this.tasks.addElement(task);
    }

    public void addFileset(FileSet fileSet) {
        if (this.tasks == null) {
            this.tasks = new Vector();
        }
        this.tasks.addElement(fileSet);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setFailonerror(boolean bl) {
        this.failonerror = bl;
    }

    public boolean getFailonerror() {
        return this.failonerror;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setAssertsenabled(boolean bl) {
        this.assertEnabled = bl;
    }

    public void setShowsummary(boolean bl) {
        this.showSummary = bl;
    }

    public int getTestCaseCount() {
        return this.totalTestCount;
    }

    public int getRanCount() {
        return this.totalRanCount;
    }

    public int getPassedCount() {
        return this.totalPassedCount;
    }

    public int getFailedCount() {
        return this.totalFailedCount;
    }

    public Enumeration getFailures() {
        return this.failures.elements();
    }

    public int getWarningCount() {
        return this.totalWarningCount;
    }

    public void execute() {
        String string;
        if (!this.enabled) {
            return;
        }
        String string2 = string = this.assertEnabled ? "true" : "false";
        if (this.assertEnabled) {
            this.getProject().setProperty("ant.enable.asserts", string);
        }
        try {
            Object object;
            Enumeration enumeration;
            Object object2;
            Target target = null;
            Target target2 = null;
            Hashtable hashtable = this.getProject().getTargets();
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                object2 = (String)enumeration2.nextElement();
                if (((String)object2).equals("setUp")) {
                    target = (Target)hashtable.get(object2);
                    continue;
                }
                if (!((String)object2).equals("tearDown")) continue;
                target2 = (Target)hashtable.get(object2);
            }
            if (target != null) {
                target.execute();
            }
            object2 = new Vector();
            if (this.tasks != null && this.tasks.size() > 0) {
                enumeration = this.tasks.elements();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (object instanceof FileSet) {
                        this.loadTestFiles((FileSet)object, (Vector)object2);
                        continue;
                    }
                    ((Vector)object2).addElement(object);
                }
                enumeration = ((Vector)object2).elements();
                while (enumeration.hasMoreElements()) {
                    object = (Task)enumeration.nextElement();
                    object.perform();
                }
            }
            if (target2 != null) {
                target2.execute();
            }
            enumeration = ((Vector)object2).elements();
            while (enumeration.hasMoreElements()) {
                object = (Task)enumeration.nextElement();
                if (!(object instanceof TestStatisticAccumulator)) continue;
                TestStatisticAccumulator testStatisticAccumulator = (TestStatisticAccumulator)object;
                this.totalTestCount += testStatisticAccumulator.getTestCaseCount();
                this.totalRanCount += testStatisticAccumulator.getRanCount();
                this.totalPassedCount += testStatisticAccumulator.getPassedCount();
                this.totalFailedCount += testStatisticAccumulator.getFailedCount();
                this.totalWarningCount += testStatisticAccumulator.getWarningCount();
                Enumeration enumeration3 = testStatisticAccumulator.getFailures();
                while (enumeration3.hasMoreElements()) {
                    this.failures.add(enumeration3.nextElement());
                }
            }
            if (this.showSummary) {
                this.log(this.getSummary());
            }
            if (this.failonerror && this.totalFailedCount > 0) {
                throw new BuildException("+++++ FAILED +++++\n" + this.getSummary());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BuildException(exception.getMessage());
        }
    }

    public String getSummary() {
        String string = (this.name == null ? "Suite" : this.name) + " Totals";
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        if (this.failures.size() > 0) {
            String string3 = "Errors";
            StringBuffer stringBuffer2 = new StringBuffer();
            Enumeration enumeration = this.failures.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer2.append((String)enumeration.nextElement()).append(string2);
            }
            int n = MessageBox.getMaxWidth();
            MessageBox.setMaxWidth(n - 8);
            stringBuffer.append(MessageBox.box(string3, stringBuffer2));
            MessageBox.setMaxWidth(n);
            stringBuffer.append(string2);
        }
        stringBuffer.append("Total Ran:      ").append(this.totalRanCount).append(" out of ").append(this.totalTestCount).append(" tests.").append(string2);
        stringBuffer.append("Total Passed:   ").append(this.totalPassedCount).append(string2);
        stringBuffer.append("Total Warnings: ").append(this.totalWarningCount).append(string2);
        stringBuffer.append("Total Failed:   ").append(this.totalFailedCount).append(string2);
        return MessageBox.box(string, stringBuffer);
    }

    protected void loadTestFiles(FileSet fileSet, Vector vector) {
        String[] stringArray;
        File file;
        int n;
        File file2 = fileSet.getDir(this.getProject());
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        String[] stringArray2 = directoryScanner.getIncludedFiles();
        String[] stringArray3 = directoryScanner.getIncludedDirectories();
        if (stringArray2.length > 0) {
            for (n = 0; n < stringArray2.length; ++n) {
                file = new File(file2, stringArray2[n]);
                stringArray = this.createTestCase(file);
                vector.addElement(stringArray);
            }
        }
        if (stringArray3.length > 0) {
            for (n = stringArray3.length - 1; n >= 0; --n) {
                file = new File(file2, stringArray3[n]);
                stringArray = file.list();
                if (stringArray == null || stringArray.length <= 0) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    File file3 = new File(file, stringArray[i]);
                    TestCase testCase = this.createTestCase(file3);
                    vector.addElement(testCase);
                }
            }
        }
    }

    private TestCase createTestCase(File file) {
        TestCase testCase = new TestCase();
        testCase.init();
        testCase.setFile(file);
        testCase.setProject(this.getProject());
        return testCase;
    }
}

