/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class XmlPropertyTask
extends Task {
    private File src;
    private String xml = null;
    private String prefix = "";
    private boolean keepRoot = true;
    private boolean validate = false;
    private boolean collapseAttributes = false;
    private boolean semanticAttributes = false;
    private boolean includeSemanticAttribute = false;
    private File rootDirectory = null;
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private Hashtable addedAttributes = new Hashtable();
    private XMLCatalog xmlCatalog = new XMLCatalog();
    private static final String ID = "id";
    private static final String REF_ID = "refid";
    private static final String LOCATION = "location";
    private static final String VALUE = "value";
    private static final String PATH = "path";
    private static final String PATHID = "pathid";
    private static final String[] ATTRIBUTES = new String[]{"id", "refid", "location", "value", "path", "pathid"};

    public void init() {
        super.init();
        this.xmlCatalog.setProject(this.getProject());
    }

    protected EntityResolver getEntityResolver() {
        return this.xmlCatalog;
    }

    public void execute() throws BuildException {
        try {
            InputStream inputStream = this.getInputStream();
            if (inputStream == null) {
                String string = "XmlProperty task requires a file or xml attribute";
                throw new BuildException(string);
            }
            this.log("Loading " + (this.src != null ? this.src.getAbsolutePath() : "xml properties"), 3);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(this.validate);
            documentBuilderFactory.setNamespaceAware(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(this.getEntityResolver());
            Document document = documentBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            this.addedAttributes = new Hashtable();
            if (this.keepRoot) {
                this.addNodeRecursively(element, this.prefix, null);
            } else {
                NodeList nodeList = element.getChildNodes();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    this.addNodeRecursively(nodeList.item(i), this.prefix, null);
                }
            }
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            throw new BuildException((Throwable)exception);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BuildException((Throwable)parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    private InputStream getInputStream() throws IOException {
        if (this.src != null && this.src.exists()) {
            return new BufferedInputStream(new FileInputStream(this.src));
        }
        if (this.xml != null) {
            return new BufferedInputStream(new ByteArrayInputStream(this.xml.getBytes()));
        }
        return null;
    }

    private void addNodeRecursively(Node node, String string, Object object) {
        String string2 = string;
        if (node.getNodeType() != 3) {
            if (string.trim().length() > 0) {
                string2 = string2 + ".";
            }
            string2 = string2 + node.getNodeName();
        }
        Object object2 = this.processNode(node, string2, object);
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.addNodeRecursively(nodeList.item(i), string2, object2);
            }
        }
    }

    void addNodeRecursively(Node node, String string) {
        this.addNodeRecursively(node, string, null);
    }

    public Object processNode(Node node, String string, Object object) {
        Object object2;
        String string2 = null;
        String string3 = null;
        if (node.hasAttributes()) {
            object2 = node.getAttributes();
            Node node2 = object2.getNamedItem(ID);
            string3 = this.semanticAttributes && node2 != null ? node2.getNodeValue() : null;
            for (int i = 0; i < object2.getLength(); ++i) {
                Path path;
                String string4;
                String string5;
                Node node3 = object2.item(i);
                if (!this.semanticAttributes) {
                    string5 = this.getAttributeName(node3);
                    string4 = this.getAttributeValue(node3);
                    this.addProperty(string + string5, string4, null);
                    continue;
                }
                string5 = node3.getNodeName();
                string4 = this.getAttributeValue(node3);
                Path path2 = path = object != null && object instanceof Path ? (Path)object : null;
                if (string5.equals(ID)) continue;
                if (path != null && string5.equals(PATH)) {
                    path.setPath(string4);
                    continue;
                }
                if (object instanceof Path && string5.equals(REF_ID)) {
                    path.setPath(string4);
                    continue;
                }
                if (object instanceof Path && string5.equals(LOCATION)) {
                    path.setLocation(this.resolveFile(string4));
                    continue;
                }
                if (string5.equals(PATHID)) {
                    if (object != null) {
                        throw new BuildException("XmlProperty does not support nested paths");
                    }
                    string2 = new Path(this.getProject());
                    this.getProject().addReference(string4, (Object)string2);
                    continue;
                }
                String string6 = this.getAttributeName(node3);
                this.addProperty(string + string6, string4, string3);
            }
        }
        object2 = null;
        if (node.getNodeType() == 3) {
            object2 = this.getAttributeValue(node);
        } else if (node.getNodeType() == 1 && node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 4) {
            object2 = node.getFirstChild().getNodeValue();
        }
        if (object2 != null) {
            if (this.semanticAttributes && string3 == null && object instanceof String) {
                string3 = (String)object;
            }
            if (((String)object2).trim().length() != 0) {
                this.addProperty(string, (String)object2, string3);
            }
        }
        return string2 != null ? string2 : string3;
    }

    private void addProperty(String string, String string2, String string3) {
        String string4 = string + ":" + string2;
        if (string3 != null) {
            string4 = string4 + "(id=" + string3 + ")";
        }
        this.log(string4, 4);
        if (this.addedAttributes.containsKey(string)) {
            string2 = (String)this.addedAttributes.get(string) + "," + string2;
            this.getProject().setProperty(string, string2);
        } else {
            this.getProject().setNewProperty(string, string2);
        }
        this.addedAttributes.put(string, string2);
        if (string3 != null) {
            this.getProject().addReference(string3, (Object)string2);
        }
    }

    private String getAttributeName(Node node) {
        String string = node.getNodeName();
        if (this.semanticAttributes) {
            if (string.equals(REF_ID)) {
                return "";
            }
            if (!XmlPropertyTask.isSemanticAttribute(string) || this.includeSemanticAttribute) {
                return "." + string;
            }
            return "";
        }
        if (this.collapseAttributes) {
            return "." + string;
        }
        return "(" + string + ")";
    }

    private static boolean isSemanticAttribute(String string) {
        for (int i = 0; i < ATTRIBUTES.length; ++i) {
            if (!string.equals(ATTRIBUTES[i])) continue;
            return true;
        }
        return false;
    }

    private String getAttributeValue(Node node) {
        String string = node.getNodeValue().trim();
        if (this.semanticAttributes) {
            Object object;
            String string2 = node.getNodeName();
            string = this.getProject().replaceProperties(string);
            if (string2.equals(LOCATION)) {
                File file = this.resolveFile(string);
                return file.getPath();
            }
            if (string2.equals(REF_ID) && (object = this.getProject().getReference(string)) != null) {
                return object.toString();
            }
        }
        return string;
    }

    public void setFile(File file) {
        this.src = file;
    }

    public void setXml(String string) {
        this.xml = string;
    }

    public void setPrefix(String string) {
        this.prefix = string.trim();
    }

    public void setKeeproot(boolean bl) {
        this.keepRoot = bl;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    public void setCollapseAttributes(boolean bl) {
        this.collapseAttributes = bl;
    }

    public void setSemanticAttributes(boolean bl) {
        this.semanticAttributes = bl;
    }

    public void setRootDirectory(File file) {
        this.rootDirectory = file;
    }

    public void setIncludeSemanticAttribute(boolean bl) {
        this.includeSemanticAttribute = bl;
    }

    public void addConfiguredXMLCatalog(XMLCatalog xMLCatalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(xMLCatalog);
    }

    protected File getFile() {
        return this.src;
    }

    protected String getXML() {
        return this.xml;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected boolean getKeeproot() {
        return this.keepRoot;
    }

    protected boolean getValidate() {
        return this.validate;
    }

    protected boolean getCollapseAttributes() {
        return this.collapseAttributes;
    }

    protected boolean getSemanticAttributes() {
        return this.semanticAttributes;
    }

    protected File getRootDirectory() {
        return this.rootDirectory;
    }

    protected boolean getIncludeSementicAttribute() {
        return this.includeSemanticAttribute;
    }

    private File resolveFile(String string) {
        if (this.rootDirectory == null) {
            return this.getProject().resolveFile(string);
        }
        return this.fileUtils.resolveFile(this.rootDirectory, string);
    }
}

