/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class FileUtilities {
    public static int BUFFER_SIZE = 8192;

    public static void copy(File file, File file2) throws Exception {
        FileUtilities.copyFile(file, file2);
    }

    public static void copy(InputStream inputStream, File file) throws Exception {
        FileUtilities.copyToFile(inputStream, file);
    }

    public static void copy(InputStream inputStream, boolean bl, File file) throws Exception {
        FileUtilities.copyToFile(inputStream, bl, file);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws Exception {
        FileUtilities.copyToStream(inputStream, outputStream);
    }

    public static void copy(Reader reader, Writer writer) throws Exception {
        FileUtilities.copyToWriter(reader, writer);
    }

    public static void copyFile(File file, File file2) throws Exception {
        int n;
        if (!file.exists()) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[BUFFER_SIZE];
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        fileInputStream.close();
    }

    public static void copyToFile(InputStream inputStream, File file) throws Exception {
        FileUtilities.copyToFile(inputStream, true, file);
    }

    public static void copyToFile(InputStream inputStream, boolean bl, File file) throws Exception {
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[BUFFER_SIZE];
        while ((n = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        if (bl) {
            inputStream.close();
        }
    }

    public static void copyToStream(InputStream inputStream, OutputStream outputStream) throws Exception {
        int n;
        byte[] byArray = new byte[BUFFER_SIZE];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
        inputStream.close();
    }

    public static void copyToWriter(Reader reader, Writer writer) throws Exception {
        int n;
        char[] cArray = new char[BUFFER_SIZE];
        while ((n = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
        }
        writer.flush();
        reader.close();
    }
}

