/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import ise.library.FileUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

public class Os {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    private static final String PATH_SEP = System.getProperty("path.separator");
    private String family;
    private String name;
    private String version;
    private String arch;
    private static Hashtable environment;

    public Os() {
    }

    public Os(String string) {
        this.setFamily(string);
    }

    public void setFamily(String string) {
        this.family = string.toLowerCase(Locale.US);
    }

    public void setName(String string) {
        this.name = string.toLowerCase(Locale.US);
    }

    public void setArch(String string) {
        this.arch = string.toLowerCase(Locale.US);
    }

    public void setVersion(String string) {
        this.version = string.toLowerCase(Locale.US);
    }

    public boolean eval() {
        return Os.isOs(this.family, this.name, this.arch, this.version);
    }

    public static boolean isFamily(String string) {
        return Os.isOs(string, null, null, null);
    }

    public static boolean isName(String string) {
        return Os.isOs(null, string, null, null);
    }

    public static boolean isArch(String string) {
        return Os.isOs(null, null, string, null);
    }

    public static boolean isVersion(String string) {
        return Os.isOs(null, null, null, string);
    }

    public static boolean isOs(String string, String string2, String string3, String string4) {
        boolean bl = false;
        if (string != null || string2 != null || string3 != null || string4 != null) {
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = true;
            if (string != null) {
                if (string.equals("windows")) {
                    bl2 = OS_NAME.indexOf("windows") > -1;
                } else if (string.equals("os/2")) {
                    bl2 = OS_NAME.indexOf("os/2") > -1;
                } else if (string.equals("netware")) {
                    bl2 = OS_NAME.indexOf("netware") > -1;
                } else if (string.equals("dos")) {
                    bl2 = PATH_SEP.equals(";") && !Os.isFamily("netware");
                } else if (string.equals("mac")) {
                    bl2 = OS_NAME.indexOf("mac") > -1;
                } else if (string.equals("tandem")) {
                    bl2 = OS_NAME.indexOf("nonstop_kernel") > -1;
                } else if (string.equals("unix")) {
                    bl2 = PATH_SEP.equals(":") && !Os.isFamily("openvms") && (!Os.isFamily("mac") || OS_NAME.endsWith("x"));
                } else if (string.equals("win9x")) {
                    bl2 = Os.isFamily("windows") && (OS_NAME.indexOf("95") >= 0 || OS_NAME.indexOf("98") >= 0 || OS_NAME.indexOf("me") >= 0 || OS_NAME.indexOf("ce") >= 0);
                } else if (string.equals("z/os")) {
                    bl2 = OS_NAME.indexOf("z/os") > -1 || OS_NAME.indexOf("os/390") > -1;
                } else if (string.equals("os/400")) {
                    bl2 = OS_NAME.indexOf("os/400") > -1;
                } else if (string.equals("openvms")) {
                    bl2 = OS_NAME.indexOf("openvms") > -1;
                } else {
                    return false;
                }
            }
            if (string2 != null) {
                bl3 = string2.equals(OS_NAME);
            }
            if (string3 != null) {
                bl4 = string3.equals(OS_ARCH);
            }
            if (string4 != null) {
                bl5 = string4.equals(OS_VERSION);
            }
            bl = bl2 && bl3 && bl4 && bl5;
        }
        return bl;
    }

    public static String getEnvironmentValue(String string) {
        if (environment != null) {
            return (String)environment.get(string);
        }
        environment = new Hashtable();
        try {
            String string2;
            String[] stringArray = Os.getProcEnvCommand();
            Process process = Runtime.getRuntime().exec(stringArray);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FileUtilities.copy((InputStream)bufferedInputStream, byteArrayOutputStream);
            BufferedReader bufferedReader = new BufferedReader(new StringReader(byteArrayOutputStream.toString()));
            Vector<String> vector = new Vector<String>();
            String string3 = null;
            String string4 = System.getProperty("line.separator");
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf(61) == -1) {
                    if (string3 == null) {
                        string3 = string4 + string2;
                        continue;
                    }
                    string3 = string3 + string4 + string2;
                    continue;
                }
                if (string3 != null) {
                    vector.addElement(string3);
                }
                string3 = string2;
            }
            if (string3 != null) {
                vector.addElement(string3);
            }
            if (vector.size() > 0) {
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    string3 = (String)iterator.next();
                    int n = string3.indexOf("=");
                    String string5 = string3.substring(0, n);
                    String string6 = string3.substring(n + 1);
                    environment.put(string5, string6);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Os.getEnvironmentValue(string);
    }

    private static String[] getProcEnvCommand() {
        if (Os.isFamily("os/2")) {
            String[] stringArray = new String[]{"cmd", "/c", "set"};
            return stringArray;
        }
        if (Os.isFamily("windows")) {
            if (!Os.isFamily("win9x")) {
                String[] stringArray = new String[]{"cmd", "/c", "set"};
                return stringArray;
            }
            String[] stringArray = new String[]{"command.com", "/c", "set"};
            return stringArray;
        }
        if (Os.isFamily("z/os") || Os.isFamily("unix")) {
            String[] stringArray = new String[]{new File("/bin/env").canRead() ? "/bin/env" : (new File("/usr/bin/env").canRead() ? "/usr/bin/env" : "env")};
            return stringArray;
        }
        if (Os.isFamily("netware") || Os.isFamily("os/400")) {
            String[] stringArray = new String[]{"env"};
            return stringArray;
        }
        if (Os.isFamily("openvms")) {
            String[] stringArray = new String[]{"show", "logical"};
            return stringArray;
        }
        String[] stringArray = null;
        return stringArray;
    }
}

