/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.calendar.model.impl;

import com.liferay.portal.kernel.cal.TZSRecurrence;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.Validator;

/**
 * @author Brian Wing Shun Chan
 */
public class CalEventImpl extends CalEventBaseImpl {

	public CalEventImpl() {
	}

	@Override
	public TZSRecurrence getRecurrenceObj() {
		if (_recurrenceObj == null) {
			String recurrence = getRecurrence();

			if (Validator.isNotNull(recurrence)) {
				_recurrenceObj = (TZSRecurrence)JSONFactoryUtil.deserialize(
					recurrence);
			}
		}

		return _recurrenceObj;
	}

	@Override
	public void setRecurrence(String recurrence) {
		_recurrenceObj = null;

		super.setRecurrence(recurrence);
	}

	@Override
	public void setRecurrenceObj(TZSRecurrence recurrenceObj) {
		_recurrenceObj = recurrenceObj;

		super.setRecurrence(JSONFactoryUtil.serialize(recurrenceObj));
	}

	private TZSRecurrence _recurrenceObj = null;

}