/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.concurrent.TimeUnit;
import javax.cache.CacheLoader;
import javax.cache.CacheWriter;
import javax.cache.InvalidConfigurationException;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CacheConfiguration<K, V> {
    public boolean isReadThrough();

    public boolean isWriteThrough();

    public boolean isStoreByValue();

    public boolean isStatisticsEnabled();

    public void setStatisticsEnabled(boolean var1);

    public boolean isTransactionEnabled();

    public IsolationLevel getTransactionIsolationLevel();

    public Mode getTransactionMode();

    public CacheLoader<K, ? extends V> getCacheLoader();

    public CacheWriter<? super K, ? super V> getCacheWriter();

    public Duration getExpiry(ExpiryType var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpiryType {
        MODIFIED,
        ACCESSED;

    }

    public static class Duration {
        public static final Duration ETERNAL = new Duration(TimeUnit.SECONDS, 0L);
        private final TimeUnit timeUnit;
        private final long timeToLive;

        public Duration(TimeUnit timeUnit, long timeToLive) {
            if (timeUnit == null) {
                throw new NullPointerException();
            }
            switch (timeUnit) {
                case NANOSECONDS: 
                case MICROSECONDS: {
                    throw new InvalidConfigurationException();
                }
            }
            this.timeUnit = timeUnit;
            if (timeToLive < 0L) {
                throw new IllegalArgumentException();
            }
            this.timeToLive = timeToLive;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public long getDurationAmount() {
            return this.timeToLive;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.getDurationAmount() + "," + (Object)((Object)this.getTimeUnit()) + "]";
        }
    }
}

